/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import com.github.sarxos.webcam.Webcam;
import java.io.Serializable;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.WebcamCapture;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;

public final class WebcamCapture$
implements Logging {
    public static final WebcamCapture$ MODULE$ = new WebcamCapture$();
    private static final Duration ocelot$desktop$util$WebcamCapture$$FrameTimeout;
    private static final Duration ocelot$desktop$util$WebcamCapture$$DeviceTimeout;
    private static final float ocelot$desktop$util$WebcamCapture$$MaxDistance;
    private static final float InvGamma;
    private static final HashMap<String, WebcamCapture> instances;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        ocelot$desktop$util$WebcamCapture$$FrameTimeout = new package.DurationInt(package$.MODULE$.DurationInt(500)).millis();
        ocelot$desktop$util$WebcamCapture$$DeviceTimeout = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
        ocelot$desktop$util$WebcamCapture$$MaxDistance = 32.0f;
        InvGamma = 0.45454544f;
        instances = new HashMap();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public final Duration ocelot$desktop$util$WebcamCapture$$FrameTimeout() {
        return ocelot$desktop$util$WebcamCapture$$FrameTimeout;
    }

    public final Duration ocelot$desktop$util$WebcamCapture$$DeviceTimeout() {
        return ocelot$desktop$util$WebcamCapture$$DeviceTimeout;
    }

    public final float ocelot$desktop$util$WebcamCapture$$MaxDistance() {
        return ocelot$desktop$util$WebcamCapture$$MaxDistance;
    }

    private final float InvGamma() {
        return InvGamma;
    }

    private HashMap<String, WebcamCapture> instances() {
        return instances;
    }

    public Option<WebcamCapture> getInstance(String name) {
        if (this.instances().contains(name)) {
            return new Some<WebcamCapture>(this.instances().apply(name));
        }
        Option<Webcam> option = Option$.MODULE$.apply(Webcam.getWebcamByName(name));
        if (option instanceof Some) {
            Some some = (Some)option;
            Webcam webcam = (Webcam)some.value();
            WebcamCapture webcamCapture = new WebcamCapture(webcam);
            this.instances().update(name, webcamCapture);
            return new Some<WebcamCapture>(webcamCapture);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().warn(new StringBuilder(16).append("No such webcam: ").append(name).toString());
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<WebcamCapture> getInstance(Webcam webcam) {
        return this.getInstance(webcam.getName());
    }

    public Option<WebcamCapture> getDefault() {
        return Option$.MODULE$.apply(Webcam.getDefault()).flatMap((Function1<Webcam, Option> & Serializable)webcam -> MODULE$.getInstance((Webcam)webcam));
    }

    public void cleanup() {
        this.instances().values().foreach((Function1<WebcamCapture, Object> & Serializable)instance -> {
            instance.interrupt();
            return BoxedUnit.UNIT;
        });
        this.instances().values().foreach((Function1<WebcamCapture, Object> & Serializable)instance -> {
            instance.join();
            return BoxedUnit.UNIT;
        });
    }

    public float ocelot$desktop$util$WebcamCapture$$toLinear(int value) {
        return (float)Math.pow((float)value / 255.0f, this.InvGamma());
    }

    private WebcamCapture$() {
    }
}

