/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import com.github.sarxos.webcam.Webcam;
import java.awt.Color;
import java.awt.image.BufferedImage;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.WebcamCapture$;
import org.apache.logging.log4j.Logger;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichFloat$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00055t!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%i\u0001\u000f\u0005\u0007\u0003\u0006\u0001\u000bQB\u001d\t\u000f\t\u000b!\u0019!C\u0007q!11)\u0001Q\u0001\u000eeBq\u0001R\u0001C\u0002\u00135Q\t\u0003\u0004J\u0003\u0001\u0006iA\u0012\u0005\b\u0015\u0006\u0011\r\u0011\"\u0004F\u0011\u0019Y\u0015\u0001)A\u0007\r\"9A*\u0001b\u0001\n\u0013i\u0005bBA&\u0003\u0001\u0006IA\u0014\u0005\b\u0003\u001b\nA\u0011AA(\u0011\u001d\ti%\u0001C\u0001\u0003+Bq!!\u0017\u0002\t\u0003\tY\u0006C\u0004\u0002^\u0005!\t!!\u000e\t\u000f\u0005}\u0013\u0001\"\u0003\u0002b\u0019!!&\t\u0001c\u0011!Y'C!b\u0001\n\u0013a\u0007\u0002\u0003=\u0013\u0005\u0003\u0005\u000b\u0011B7\t\u000bU\u0012B\u0011A=\t\u000fm\u0014\u0002\u0019!C\u0005y\"I\u0011\u0011\u0003\nA\u0002\u0013%\u00111\u0003\u0005\b\u0003?\u0011\u0002\u0015)\u0003~\u0011%\t\tC\u0005a\u0001\n\u0013\t\u0019\u0003C\u0005\u0002,I\u0001\r\u0011\"\u0003\u0002.!A\u0011\u0011\u0007\n!B\u0013\t)\u0003C\u0004\u00024I!\t%!\u000e\t\u000f\u0005]\"\u0003\"\u0001\u0002:!9\u00111\t\n\u0005\u0002\u0005\u0015\u0003bBA$%\u0011\u0005\u0013\u0011J\u0001\u000e/\u0016\u00147-Y7DCB$XO]3\u000b\u0005\t\u001a\u0013\u0001B;uS2T!\u0001J\u0013\u0002\u000f\u0011,7o\u001b;pa*\ta%\u0001\u0004pG\u0016dw\u000e^\u0002\u0001!\tI\u0013!D\u0001\"\u000559VMY2b[\u000e\u000b\u0007\u000f^;sKN\u0019\u0011\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\tI3'\u0003\u00025C\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001)\u000311%/Y7f)&lWm\\;u+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003!!WO]1uS>t'B\u0001 /\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0001n\u0012\u0001\u0002R;sCRLwN\\\u0001\u000e\rJ\fW.\u001a+j[\u0016|W\u000f\u001e\u0011\u0002\u001b\u0011+g/[2f)&lWm\\;u\u00039!UM^5dKRKW.Z8vi\u0002\n1\"T1y\t&\u001cH/\u00198dKV\ta\t\u0005\u0002.\u000f&\u0011\u0001J\f\u0002\u0006\r2|\u0017\r^\u0001\r\u001b\u0006DH)[:uC:\u001cW\rI\u0001\t\u0013:4x)Y7nC\u0006I\u0011J\u001c<HC6l\u0017\rI\u0001\nS:\u001cH/\u00198dKN,\u0012A\u0014\t\u0005\u001fR3\u0016-D\u0001Q\u0015\t\t&+A\u0004nkR\f'\r\\3\u000b\u0005Ms\u0013AC2pY2,7\r^5p]&\u0011Q\u000b\u0015\u0002\b\u0011\u0006\u001c\b.T1q!\t9fL\u0004\u0002Y9B\u0011\u0011LL\u0007\u00025*\u00111lJ\u0001\u0007yI|w\u000e\u001e \n\u0005us\u0013A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018\u0018\u0011\u0005%\u00122c\u0001\ndeA\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0005Y\u0006twMC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'A\u0002+ie\u0016\fG-\u0001\u0004xK\n\u001c\u0017-\\\u000b\u0002[B\u0011aN^\u0007\u0002_*\u00111\u000e\u001d\u0006\u0003cJ\faa]1sq>\u001c(BA:u\u0003\u00199\u0017\u000e\u001e5vE*\tQ/A\u0002d_6L!a^8\u0003\r]+'mY1n\u0003\u001d9XMY2b[\u0002\"\"!\u0019>\t\u000b-,\u0002\u0019A7\u0002\u000b\u0019\u0014\u0018-\\3\u0016\u0003u\u0004B!\f@\u0002\u0002%\u0011qP\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005)\u0011.\\1hK*\u0019\u00111B4\u0002\u0007\u0005<H/\u0003\u0003\u0002\u0010\u0005\u0015!!\u0004\"vM\u001a,'/\u001a3J[\u0006<W-A\u0005ge\u0006lWm\u0018\u0013fcR!\u0011QCA\u000e!\ri\u0013qC\u0005\u0004\u00033q#\u0001B+oSRD\u0001\"!\b\u0018\u0003\u0003\u0005\r!`\u0001\u0004q\u0012\n\u0014A\u00024sC6,\u0007%A\u0007mCN$Xk]1hKRKW.Z\u000b\u0003\u0003K\u00012!LA\u0014\u0013\r\tIC\f\u0002\u0005\u0019>tw-A\tmCN$Xk]1hKRKW.Z0%KF$B!!\u0006\u00020!I\u0011Q\u0004\u000e\u0002\u0002\u0003\u0007\u0011QE\u0001\u000fY\u0006\u001cH/V:bO\u0016$\u0016.\\3!\u0003\r\u0011XO\u001c\u000b\u0003\u0003+\t1A]1z)\u00151\u00151HA \u0011\u0019\ti$\ba\u0001\r\u0006\t\u0001\u0010\u0003\u0004\u0002Bu\u0001\rAR\u0001\u0002s\u0006!a.Y7f+\u00051\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003Y\u000b!\"\u001b8ti\u0006t7-Z:!\u0003-9W\r^%ogR\fgnY3\u0015\t\u0005E\u00131\u000b\t\u0004[y\f\u0007BBA\"\u001b\u0001\u0007a\u000b\u0006\u0003\u0002R\u0005]\u0003\"B6\u000f\u0001\u0004i\u0017AC4fi\u0012+g-Y;miV\u0011\u0011\u0011K\u0001\bG2,\u0017M\\;q\u0003!!x\u000eT5oK\u0006\u0014Hc\u0001$\u0002d!9\u0011QM\tA\u0002\u0005\u001d\u0014!\u0002<bYV,\u0007cA\u0017\u0002j%\u0019\u00111\u000e\u0018\u0003\u0007%sG\u000f")
public class WebcamCapture
extends Thread
implements Logging {
    private final Webcam webcam;
    private Option<BufferedImage> frame;
    private long lastUsageTime;
    private Logger logger;

    public static void cleanup() {
        WebcamCapture$.MODULE$.cleanup();
    }

    public static Option<WebcamCapture> getDefault() {
        return WebcamCapture$.MODULE$.getDefault();
    }

    public static Option<WebcamCapture> getInstance(Webcam webcam) {
        return WebcamCapture$.MODULE$.getInstance(webcam);
    }

    public static Option<WebcamCapture> getInstance(String name) {
        return WebcamCapture$.MODULE$.getInstance(name);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Webcam webcam() {
        return this.webcam;
    }

    private Option<BufferedImage> frame() {
        return this.frame;
    }

    private void frame_$eq(Option<BufferedImage> x$1) {
        this.frame = x$1;
    }

    private long lastUsageTime() {
        return this.lastUsageTime;
    }

    private void lastUsageTime_$eq(long x$1) {
        this.lastUsageTime = x$1;
    }

    @Override
    public void run() {
        this.logger().debug(new StringBuilder(28).append("Started thread for webcam '").append(this.name()).append("'").toString());
        while (!this.isInterrupted()) {
            try {
                if (System.currentTimeMillis() - this.lastUsageTime() >= WebcamCapture$.MODULE$.ocelot$desktop$util$WebcamCapture$$DeviceTimeout().toMillis()) {
                    this.webcam().close();
                    WebcamCapture webcamCapture = this;
                    synchronized (webcamCapture) {
                        this.wait();
                        continue;
                    }
                }
                this.webcam().open();
                Option<BufferedImage> image = Option$.MODULE$.apply(this.webcam().getImage());
                WebcamCapture webcamCapture = this;
                synchronized (webcamCapture) {
                    this.frame_$eq(image);
                }
                Thread.sleep(WebcamCapture$.MODULE$.ocelot$desktop$util$WebcamCapture$$FrameTimeout().toMillis());
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
        }
        this.logger().debug(new StringBuilder(21).append("Cleaning up webcam '").append(this.name()).append("'").toString());
        if (this.webcam().isOpen()) {
            this.webcam().close();
            return;
        }
    }

    public synchronized float ray(float x, float y) {
        this.lastUsageTime_$eq(System.currentTimeMillis());
        this.notify();
        if (this.frame().isEmpty()) {
            return 0.0f;
        }
        float clampedX = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), x)), 1.0f);
        float clampedY = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), y)), 1.0f);
        float frameX = clampedX * (float)(this.frame().get().getWidth() - 1);
        float frameY = clampedY * (float)(this.frame().get().getHeight() - 1);
        Color color = new Color(this.frame().get().getRGB((int)frameX, (int)frameY));
        float normalizedDistance = 0.2126f * WebcamCapture$.MODULE$.ocelot$desktop$util$WebcamCapture$$toLinear(color.getRed()) + 0.7152f * WebcamCapture$.MODULE$.ocelot$desktop$util$WebcamCapture$$toLinear(color.getGreen()) + 0.0722f * WebcamCapture$.MODULE$.ocelot$desktop$util$WebcamCapture$$toLinear(color.getBlue());
        return WebcamCapture$.MODULE$.ocelot$desktop$util$WebcamCapture$$MaxDistance() * (1.0f - normalizedDistance);
    }

    public String name() {
        return this.webcam().getName();
    }

    @Override
    public String toString() {
        return this.name();
    }

    public WebcamCapture(Webcam webcam) {
        this.webcam = webcam;
        super(new StringBuilder(20).append("WebcamCaptureThread-").append(webcam.getName()).toString());
        Logging.$init$(this);
        this.frame = None$.MODULE$;
        this.lastUsageTime = -1L;
        this.start();
        Statics.releaseFence();
    }
}

