/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.MurmurHash;

public final class MurmurHash2 {
    private static final int M32 = 1540483477;
    private static final int R32 = 24;
    private static final long M64 = -4132994306676758123L;
    private static final int R64 = 47;

    public static int hash32(byte[] data, int length) {
        return MurmurHash2.hash32(data, length, -1756908916);
    }

    public static int hash32(byte[] data, int length, int seed) {
        int h2 = seed ^ length;
        int nblocks = length >> 2;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            int index = i2 << 2;
            int k2 = MurmurHash.getLittleEndianInt(data, index);
            k2 *= 1540483477;
            k2 ^= k2 >>> 24;
            h2 *= 1540483477;
            h2 ^= (k2 *= 1540483477);
        }
        int index = nblocks << 2;
        switch (length - index) {
            case 3: {
                h2 ^= (data[index + 2] & 0xFF) << 16;
            }
            case 2: {
                h2 ^= (data[index + 1] & 0xFF) << 8;
            }
            case 1: {
                h2 ^= data[index] & 0xFF;
                h2 *= 1540483477;
            }
        }
        h2 ^= h2 >>> 13;
        h2 *= 1540483477;
        h2 ^= h2 >>> 15;
        return h2;
    }

    public static int hash32(String text) {
        byte[] bytes = StringUtils.getBytesUtf8(text);
        return MurmurHash2.hash32(bytes, bytes.length);
    }

    public static int hash32(String text, int from, int length) {
        return MurmurHash2.hash32(text.substring(from, from + length));
    }

    public static long hash64(byte[] data, int length) {
        return MurmurHash2.hash64(data, length, -512093083);
    }

    public static long hash64(byte[] data, int length, int seed) {
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int nblocks = length >> 3;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            int index = i2 << 3;
            long k2 = MurmurHash.getLittleEndianLong(data, index);
            k2 *= -4132994306676758123L;
            k2 ^= k2 >>> 47;
            h2 ^= (k2 *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
        }
        int index = nblocks << 3;
        switch (length - index) {
            case 7: {
                h2 ^= ((long)data[index + 6] & 0xFFL) << 48;
            }
            case 6: {
                h2 ^= ((long)data[index + 5] & 0xFFL) << 40;
            }
            case 5: {
                h2 ^= ((long)data[index + 4] & 0xFFL) << 32;
            }
            case 4: {
                h2 ^= ((long)data[index + 3] & 0xFFL) << 24;
            }
            case 3: {
                h2 ^= ((long)data[index + 2] & 0xFFL) << 16;
            }
            case 2: {
                h2 ^= ((long)data[index + 1] & 0xFFL) << 8;
            }
            case 1: {
                h2 ^= (long)data[index] & 0xFFL;
                h2 *= -4132994306676758123L;
            }
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }

    public static long hash64(String text) {
        byte[] bytes = StringUtils.getBytesUtf8(text);
        return MurmurHash2.hash64(bytes, bytes.length);
    }

    public static long hash64(String text, int from, int length) {
        return MurmurHash2.hash64(text.substring(from, from + length));
    }

    private MurmurHash2() {
    }
}

