/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class HermiteInterpolator
implements UnivariateDifferentiableVectorFunction {
    private final List<Double> abscissae = new ArrayList<Double>();
    private final List<double[]> topDiagonal = new ArrayList<double[]>();
    private final List<double[]> bottomDiagonal = new ArrayList<double[]>();

    public void addSamplePoint(double x, double[] ... value) throws ZeroException, MathArithmeticException {
        for (int i2 = 0; i2 < value.length; ++i2) {
            int j2;
            double[] y = (double[])value[i2].clone();
            if (i2 > 1) {
                double inv = 1.0 / (double)CombinatoricsUtils.factorial(i2);
                j2 = 0;
                while (j2 < y.length) {
                    int n2 = j2++;
                    y[n2] = y[n2] * inv;
                }
            }
            int n3 = this.abscissae.size();
            this.bottomDiagonal.add(n3 - i2, y);
            double[] bottom0 = y;
            for (j2 = i2; j2 < n3; ++j2) {
                double[] bottom1 = this.bottomDiagonal.get(n3 - (j2 + 1));
                double inv = 1.0 / (x - this.abscissae.get(n3 - (j2 + 1)));
                if (Double.isInfinite(inv)) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, x);
                }
                for (int k2 = 0; k2 < y.length; ++k2) {
                    bottom1[k2] = inv * (bottom0[k2] - bottom1[k2]);
                }
                bottom0 = bottom1;
            }
            this.topDiagonal.add((double[])bottom0.clone());
            this.abscissae.add(x);
        }
    }

    public PolynomialFunction[] getPolynomials() throws NoDataException {
        this.checkInterpolation();
        PolynomialFunction zero = this.polynomial(0.0);
        PolynomialFunction[] polynomials = new PolynomialFunction[this.topDiagonal.get(0).length];
        for (int i2 = 0; i2 < polynomials.length; ++i2) {
            polynomials[i2] = zero;
        }
        PolynomialFunction coeff = this.polynomial(1.0);
        for (int i3 = 0; i3 < this.topDiagonal.size(); ++i3) {
            double[] tdi = this.topDiagonal.get(i3);
            for (int k2 = 0; k2 < polynomials.length; ++k2) {
                polynomials[k2] = polynomials[k2].add(coeff.multiply(this.polynomial(tdi[k2])));
            }
            coeff = coeff.multiply(this.polynomial(-this.abscissae.get(i3).doubleValue(), 1.0));
        }
        return polynomials;
    }

    public double[] value(double x) throws NoDataException {
        this.checkInterpolation();
        double[] value = new double[this.topDiagonal.get(0).length];
        double valueCoeff = 1.0;
        for (int i2 = 0; i2 < this.topDiagonal.size(); ++i2) {
            double[] dividedDifference = this.topDiagonal.get(i2);
            for (int k2 = 0; k2 < value.length; ++k2) {
                int n2 = k2;
                value[n2] = value[n2] + dividedDifference[k2] * valueCoeff;
            }
            double deltaX = x - this.abscissae.get(i2);
            valueCoeff *= deltaX;
        }
        return value;
    }

    public DerivativeStructure[] value(DerivativeStructure x) throws NoDataException {
        this.checkInterpolation();
        Object[] value = new DerivativeStructure[this.topDiagonal.get(0).length];
        Arrays.fill(value, x.getField().getZero());
        DerivativeStructure valueCoeff = x.getField().getOne();
        for (int i2 = 0; i2 < this.topDiagonal.size(); ++i2) {
            double[] dividedDifference = this.topDiagonal.get(i2);
            for (int k2 = 0; k2 < value.length; ++k2) {
                value[k2] = ((DerivativeStructure)value[k2]).add(valueCoeff.multiply(dividedDifference[k2]));
            }
            DerivativeStructure deltaX = x.subtract(this.abscissae.get(i2));
            valueCoeff = valueCoeff.multiply(deltaX);
        }
        return value;
    }

    private void checkInterpolation() throws NoDataException {
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
    }

    private PolynomialFunction polynomial(double ... c2) {
        return new PolynomialFunction(c2);
    }
}

