/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double r, double theta) throws MathIllegalArgumentException {
        if (r < 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_COMPLEX_MODULE, r);
        }
        return new Complex(r * FastMath.cos(theta), r * FastMath.sin(theta));
    }

    public static Complex[] convertToComplex(double[] real) {
        Complex[] c2 = new Complex[real.length];
        for (int i2 = 0; i2 < real.length; ++i2) {
            c2[i2] = new Complex(real[i2], 0.0);
        }
        return c2;
    }
}

