/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import java.util.Arrays;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.Precision;

public class LevenbergMarquardtOptimizer
implements LeastSquaresOptimizer {
    private static final double TWO_EPS = 2.0 * Precision.EPSILON;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double initialStepBoundFactor, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, double qrRankingThreshold) {
        this.initialStepBoundFactor = initialStepBoundFactor;
        this.costRelativeTolerance = costRelativeTolerance;
        this.parRelativeTolerance = parRelativeTolerance;
        this.orthoTolerance = orthoTolerance;
        this.qrRankingThreshold = qrRankingThreshold;
    }

    public LevenbergMarquardtOptimizer withInitialStepBoundFactor(double newInitialStepBoundFactor) {
        return new LevenbergMarquardtOptimizer(newInitialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withCostRelativeTolerance(double newCostRelativeTolerance) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, newCostRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withParameterRelativeTolerance(double newParRelativeTolerance) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, newParRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withOrthoTolerance(double newOrthoTolerance) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, newOrthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withRankingThreshold(double newQRRankingThreshold) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, newQRRankingThreshold);
    }

    public double getInitialStepBoundFactor() {
        return this.initialStepBoundFactor;
    }

    public double getCostRelativeTolerance() {
        return this.costRelativeTolerance;
    }

    public double getParameterRelativeTolerance() {
        return this.parRelativeTolerance;
    }

    public double getOrthoTolerance() {
        return this.orthoTolerance;
    }

    public double getRankingThreshold() {
        return this.qrRankingThreshold;
    }

    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem problem) {
        int nR = problem.getObservationSize();
        int nC = problem.getParameterSize();
        Incrementor iterationCounter = problem.getIterationCounter();
        Incrementor evaluationCounter = problem.getEvaluationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = problem.getConvergenceChecker();
        int solvedCols = FastMath.min(nR, nC);
        double[] lmDir = new double[nC];
        double lmPar = 0.0;
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[nC];
        double[] oldX = new double[nC];
        double[] oldRes = new double[nR];
        double[] qtf = new double[nR];
        double[] work1 = new double[nC];
        double[] work2 = new double[nC];
        double[] work3 = new double[nC];
        evaluationCounter.incrementCount();
        LeastSquaresProblem.Evaluation current = problem.evaluate(problem.getStart());
        double[] currentResiduals = current.getResiduals().toArray();
        double currentCost = current.getCost();
        double[] currentPoint = current.getPoint().toArray();
        boolean firstIteration = true;
        block0: while (true) {
            int j2;
            int k2;
            iterationCounter.incrementCount();
            LeastSquaresProblem.Evaluation previous = current;
            InternalData internalData = this.qrDecomposition(current.getJacobian(), solvedCols);
            double[][] weightedJacobian = internalData.weightedJacobian;
            int[] permutation = internalData.permutation;
            double[] diagR = internalData.diagR;
            double[] jacNorm = internalData.jacNorm;
            double[] weightedResidual = currentResiduals;
            for (int i2 = 0; i2 < nR; ++i2) {
                qtf[i2] = weightedResidual[i2];
            }
            this.qTy(qtf, internalData);
            for (k2 = 0; k2 < solvedCols; ++k2) {
                int pk = permutation[k2];
                weightedJacobian[k2][pk] = diagR[pk];
            }
            if (firstIteration) {
                xNorm = 0.0;
                for (k2 = 0; k2 < nC; ++k2) {
                    double dk = jacNorm[k2];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * currentPoint[k2];
                    xNorm += xk * xk;
                    diag[k2] = dk;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (currentCost != 0.0) {
                for (j2 = 0; j2 < solvedCols; ++j2) {
                    int pj = permutation[j2];
                    double s = jacNorm[pj];
                    if (s == 0.0) continue;
                    double sum = 0.0;
                    for (int i3 = 0; i3 <= j2; ++i3) {
                        sum += weightedJacobian[i3][pj] * qtf[i3];
                    }
                    maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s * currentCost));
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
            }
            for (j2 = 0; j2 < nC; ++j2) {
                diag[j2] = FastMath.max(diag[j2], jacNorm[j2]);
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                for (int j3 = 0; j3 < solvedCols; ++j3) {
                    int pj = permutation[j3];
                    oldX[pj] = currentPoint[pj];
                }
                double previousCost = currentCost;
                double[] tmpVec = weightedResidual;
                weightedResidual = oldRes;
                oldRes = tmpVec;
                lmPar = this.determineLMParameter(qtf, delta, diag, internalData, solvedCols, work1, work2, work3, lmDir, lmPar);
                double lmNorm = 0.0;
                for (int j4 = 0; j4 < solvedCols; ++j4) {
                    int pj = permutation[j4];
                    lmDir[pj] = -lmDir[pj];
                    currentPoint[pj] = oldX[pj] + lmDir[pj];
                    double s = diag[pj] * lmDir[pj];
                    lmNorm += s * s;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                evaluationCounter.incrementCount();
                current = problem.evaluate(new ArrayRealVector(currentPoint));
                currentResiduals = current.getResiduals().toArray();
                currentCost = current.getCost();
                currentPoint = current.getPoint().toArray();
                double actRed = -1.0;
                if (0.1 * currentCost < previousCost) {
                    double r = currentCost / previousCost;
                    actRed = 1.0 - r * r;
                }
                for (int j5 = 0; j5 < solvedCols; ++j5) {
                    int pj = permutation[j5];
                    double dirJ = lmDir[pj];
                    work1[j5] = 0.0;
                    for (int i4 = 0; i4 <= j5; ++i4) {
                        int n2 = i4;
                        work1[n2] = work1[n2] + weightedJacobian[i4][pj] * dirJ;
                    }
                }
                double coeff1 = 0.0;
                for (int j6 = 0; j6 < solvedCols; ++j6) {
                    coeff1 += work1[j6] * work1[j6];
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d2 = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d3 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * currentCost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    lmPar /= tmp;
                } else if (lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    for (int k3 = 0; k3 < nC; ++k3) {
                        double xK = diag[k3] * currentPoint[k3];
                        xNorm += xK * xK;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                    if (checker != null && checker.converged(iterationCounter.getCount(), previous, current)) {
                        return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
                    }
                } else {
                    currentCost = previousCost;
                    for (int j7 = 0; j7 < solvedCols; ++j7) {
                        int pj = permutation[j7];
                        currentPoint[pj] = oldX[pj];
                    }
                    tmpVec = weightedResidual;
                    weightedResidual = oldRes;
                    oldRes = tmpVec;
                    current = previous;
                }
                if (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm) {
                    return new OptimumImpl(current, evaluationCounter.getCount(), iterationCounter.getCount());
                }
                if (FastMath.abs(actRed) <= TWO_EPS && preRed <= TWO_EPS && ratio <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(delta <= TWO_EPS * xNorm)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(maxCosine <= TWO_EPS));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private double determineLMParameter(double[] qy, double delta, double[] diag, InternalData internalData, int solvedCols, double[] work1, double[] work2, double[] work3, double[] lmDir, double lmPar) {
        double sum;
        int pj;
        int j2;
        int j3;
        double[][] weightedJacobian = internalData.weightedJacobian;
        int[] permutation = internalData.permutation;
        int rank = internalData.rank;
        double[] diagR = internalData.diagR;
        int nC = weightedJacobian[0].length;
        for (j3 = 0; j3 < rank; ++j3) {
            lmDir[permutation[j3]] = qy[j3];
        }
        for (j3 = rank; j3 < nC; ++j3) {
            lmDir[permutation[j3]] = 0.0;
        }
        for (int k2 = rank - 1; k2 >= 0; --k2) {
            int pk = permutation[k2];
            double ypk = lmDir[pk] / diagR[pk];
            for (int i2 = 0; i2 < k2; ++i2) {
                int n2 = permutation[i2];
                lmDir[n2] = lmDir[n2] - ypk * weightedJacobian[i2][pk];
            }
            lmDir[pk] = ypk;
        }
        double dxNorm = 0.0;
        for (int j4 = 0; j4 < solvedCols; ++j4) {
            double s;
            int pj2 = permutation[j4];
            work1[pj2] = s = diag[pj2] * lmDir[pj2];
            dxNorm += s * s;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            lmPar = 0.0;
            return lmPar;
        }
        double parl = 0.0;
        if (rank == solvedCols) {
            for (j2 = 0; j2 < solvedCols; ++j2) {
                int n3 = pj = permutation[j2];
                work1[n3] = work1[n3] * (diag[pj] / dxNorm);
            }
            double sum2 = 0.0;
            for (j2 = 0; j2 < solvedCols; ++j2) {
                double s;
                pj = permutation[j2];
                sum = 0.0;
                for (int i3 = 0; i3 < j2; ++i3) {
                    sum += weightedJacobian[i3][pj] * work1[permutation[i3]];
                }
                work1[pj] = s = (work1[pj] - sum) / diagR[pj];
                sum2 += s * s;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        for (j2 = 0; j2 < solvedCols; ++j2) {
            pj = permutation[j2];
            sum = 0.0;
            for (int i4 = 0; i4 <= j2; ++i4) {
                sum += weightedJacobian[i4][pj] * qy[i4];
            }
            sum2 += (sum /= diag[pj]) * sum;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = Precision.SAFE_MIN / FastMath.min(delta, 0.1);
        }
        if ((lmPar = FastMath.min(paru, FastMath.max(lmPar, parl))) == 0.0) {
            lmPar = gNorm / dxNorm;
        }
        for (int countdown = 10; countdown >= 0; --countdown) {
            int pj3;
            int j5;
            int pj4;
            int j6;
            if (lmPar == 0.0) {
                lmPar = FastMath.max(Precision.SAFE_MIN, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(lmPar);
            for (j6 = 0; j6 < solvedCols; ++j6) {
                pj4 = permutation[j6];
                work1[pj4] = sPar * diag[pj4];
            }
            this.determineLMDirection(qy, work1, work2, internalData, solvedCols, work3, lmDir);
            dxNorm = 0.0;
            for (j6 = 0; j6 < solvedCols; ++j6) {
                double s;
                pj4 = permutation[j6];
                work3[pj4] = s = diag[pj4] * lmDir[pj4];
                dxNorm += s * s;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return lmPar;
            }
            for (j5 = 0; j5 < solvedCols; ++j5) {
                pj3 = permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
            }
            for (j5 = 0; j5 < solvedCols; ++j5) {
                int n4 = pj3 = permutation[j5];
                work1[n4] = work1[n4] / work2[j5];
                double tmp = work1[pj3];
                for (int i5 = j5 + 1; i5 < solvedCols; ++i5) {
                    int n5 = permutation[i5];
                    work1[n5] = work1[n5] - weightedJacobian[i5][pj3] * tmp;
                }
            }
            sum2 = 0.0;
            for (j5 = 0; j5 < solvedCols; ++j5) {
                double s = work1[permutation[j5]];
                sum2 += s * s;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, lmPar);
            }
            lmPar = FastMath.max(parl, lmPar + correction);
        }
        return lmPar;
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, InternalData internalData, int solvedCols, double[] work, double[] lmDir) {
        int j2;
        int pj;
        int j3;
        int[] permutation = internalData.permutation;
        double[][] weightedJacobian = internalData.weightedJacobian;
        double[] diagR = internalData.diagR;
        for (j3 = 0; j3 < solvedCols; ++j3) {
            pj = permutation[j3];
            for (int i2 = j3 + 1; i2 < solvedCols; ++i2) {
                weightedJacobian[i2][pj] = weightedJacobian[j3][permutation[i2]];
            }
            lmDir[j3] = diagR[pj];
            work[j3] = qy[j3];
        }
        for (j3 = 0; j3 < solvedCols; ++j3) {
            pj = permutation[j3];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j3 + 1, lmDiag.length, 0.0);
            }
            lmDiag[j3] = dpj;
            double qtbpj = 0.0;
            for (int k2 = j3; k2 < solvedCols; ++k2) {
                double cos2;
                double sin2;
                int pk = permutation[k2];
                if (lmDiag[k2] == 0.0) continue;
                double rkk = weightedJacobian[k2][pk];
                if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k2])) {
                    double cotan = rkk / lmDiag[k2];
                    sin2 = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                    cos2 = sin2 * cotan;
                } else {
                    double tan2 = lmDiag[k2] / rkk;
                    cos2 = 1.0 / FastMath.sqrt(1.0 + tan2 * tan2);
                    sin2 = cos2 * tan2;
                }
                weightedJacobian[k2][pk] = cos2 * rkk + sin2 * lmDiag[k2];
                double temp = cos2 * work[k2] + sin2 * qtbpj;
                qtbpj = -sin2 * work[k2] + cos2 * qtbpj;
                work[k2] = temp;
                for (int i3 = k2 + 1; i3 < solvedCols; ++i3) {
                    double rik = weightedJacobian[i3][pk];
                    double temp2 = cos2 * rik + sin2 * lmDiag[i3];
                    lmDiag[i3] = -sin2 * rik + cos2 * lmDiag[i3];
                    weightedJacobian[i3][pk] = temp2;
                }
            }
            lmDiag[j3] = weightedJacobian[j3][permutation[j3]];
            weightedJacobian[j3][permutation[j3]] = lmDir[j3];
        }
        int nSing = solvedCols;
        for (j2 = 0; j2 < solvedCols; ++j2) {
            if (lmDiag[j2] == 0.0 && nSing == solvedCols) {
                nSing = j2;
            }
            if (nSing >= solvedCols) continue;
            work[j2] = 0.0;
        }
        if (nSing > 0) {
            for (j2 = nSing - 1; j2 >= 0; --j2) {
                int pj2 = permutation[j2];
                double sum = 0.0;
                for (int i4 = j2 + 1; i4 < nSing; ++i4) {
                    sum += weightedJacobian[i4][pj2] * work[i4];
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
            }
        }
        for (j2 = 0; j2 < lmDir.length; ++j2) {
            lmDir[permutation[j2]] = work[j2];
        }
    }

    private InternalData qrDecomposition(RealMatrix jacobian, int solvedCols) throws ConvergenceException {
        int k2;
        double[][] weightedJacobian = jacobian.scalarMultiply(-1.0).getData();
        int nR = weightedJacobian.length;
        int nC = weightedJacobian[0].length;
        int[] permutation = new int[nC];
        double[] diagR = new double[nC];
        double[] jacNorm = new double[nC];
        double[] beta = new double[nC];
        for (k2 = 0; k2 < nC; ++k2) {
            permutation[k2] = k2;
            double norm2 = 0.0;
            for (int i2 = 0; i2 < nR; ++i2) {
                double akk = weightedJacobian[i2][k2];
                norm2 += akk * akk;
            }
            jacNorm[k2] = FastMath.sqrt(norm2);
        }
        for (k2 = 0; k2 < nC; ++k2) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            for (int i3 = k2; i3 < nC; ++i3) {
                double norm2 = 0.0;
                for (int j2 = k2; j2 < nR; ++j2) {
                    double aki = weightedJacobian[j2][permutation[i3]];
                    norm2 += aki * aki;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, nR, nC);
                }
                if (!(norm2 > ak2)) continue;
                nextColumn = i3;
                ak2 = norm2;
            }
            if (ak2 <= this.qrRankingThreshold) {
                return new InternalData(weightedJacobian, permutation, k2, diagR, jacNorm, beta);
            }
            int pk = permutation[nextColumn];
            permutation[nextColumn] = permutation[k2];
            permutation[k2] = pk;
            double akk = weightedJacobian[k2][pk];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            diagR[pk] = alpha;
            double[] dArray = weightedJacobian[k2];
            int n2 = pk;
            dArray[n2] = dArray[n2] - alpha;
            for (int dk = nC - 1 - k2; dk > 0; --dk) {
                int j3;
                double gamma = 0.0;
                for (j3 = k2; j3 < nR; ++j3) {
                    gamma += weightedJacobian[j3][pk] * weightedJacobian[j3][permutation[k2 + dk]];
                }
                gamma *= betak;
                for (j3 = k2; j3 < nR; ++j3) {
                    double[] dArray2 = weightedJacobian[j3];
                    int n3 = permutation[k2 + dk];
                    dArray2[n3] = dArray2[n3] - gamma * weightedJacobian[j3][pk];
                }
            }
        }
        return new InternalData(weightedJacobian, permutation, solvedCols, diagR, jacNorm, beta);
    }

    private void qTy(double[] y, InternalData internalData) {
        double[][] weightedJacobian = internalData.weightedJacobian;
        int[] permutation = internalData.permutation;
        double[] beta = internalData.beta;
        int nR = weightedJacobian.length;
        int nC = weightedJacobian[0].length;
        for (int k2 = 0; k2 < nC; ++k2) {
            int i2;
            int pk = permutation[k2];
            double gamma = 0.0;
            for (i2 = k2; i2 < nR; ++i2) {
                gamma += weightedJacobian[i2][pk] * y[i2];
            }
            gamma *= beta[pk];
            for (i2 = k2; i2 < nR; ++i2) {
                int n2 = i2;
                y[n2] = y[n2] - gamma * weightedJacobian[i2][pk];
            }
        }
    }

    private static class InternalData {
        private final double[][] weightedJacobian;
        private final int[] permutation;
        private final int rank;
        private final double[] diagR;
        private final double[] jacNorm;
        private final double[] beta;

        InternalData(double[][] weightedJacobian, int[] permutation, int rank, double[] diagR, double[] jacNorm, double[] beta) {
            this.weightedJacobian = weightedJacobian;
            this.permutation = permutation;
            this.rank = rank;
            this.diagR = diagR;
            this.jacNorm = jacNorm;
            this.beta = beta;
        }
    }
}

