/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.IterationEvent;
import org.apache.commons.math3.util.IterationListener;

public class IterationManager {
    private final Incrementor iterations;
    private final Collection<IterationListener> listeners;

    public IterationManager(int maxIterations) {
        this.iterations = new Incrementor(maxIterations);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public IterationManager(int maxIterations, Incrementor.MaxCountExceededCallback callBack) {
        this.iterations = new Incrementor(maxIterations, callBack);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public void addIterationListener(IterationListener listener) {
        this.listeners.add(listener);
    }

    public void fireInitializationEvent(IterationEvent e2) {
        for (IterationListener l2 : this.listeners) {
            l2.initializationPerformed(e2);
        }
    }

    public void fireIterationPerformedEvent(IterationEvent e2) {
        for (IterationListener l2 : this.listeners) {
            l2.iterationPerformed(e2);
        }
    }

    public void fireIterationStartedEvent(IterationEvent e2) {
        for (IterationListener l2 : this.listeners) {
            l2.iterationStarted(e2);
        }
    }

    public void fireTerminationEvent(IterationEvent e2) {
        for (IterationListener l2 : this.listeners) {
            l2.terminationPerformed(e2);
        }
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public void incrementIterationCount() throws MaxCountExceededException {
        this.iterations.incrementCount();
    }

    public void removeIterationListener(IterationListener listener) {
        this.listeners.remove(listener);
    }

    public void resetIterationCount() {
        this.iterations.resetCount();
    }
}

