/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SizeT;
import org.bridj.StructDescription;
import org.bridj.StructFieldDeclaration;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.StructUtils;
import org.bridj.TypedPointer;
import org.bridj.ValuedEnum;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPType;
import org.bridj.util.DefaultParameterizedType;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructFieldDescription {
    public final List<StructFieldDeclaration> aggregatedFields = new ArrayList<StructFieldDeclaration>();
    public long alignment = -1L;
    public long byteOffset = -1L;
    public long byteLength = -1L;
    public long bitOffset = 0L;
    public long bitLength = -1L;
    public long arrayLength = 1L;
    public long bitMask = -1L;
    public boolean isArray;
    public boolean isNativeObject;
    public Type nativeTypeOrPointerTargetType;
    public Field field;
    Type valueType;
    Method getter;
    String name;
    boolean isCLong;
    boolean isSizeT;

    public void offset(long bytes) {
        this.byteOffset += bytes;
    }

    public String toString() {
        return "Field(byteOffset = " + this.byteOffset + ", byteLength = " + this.byteLength + ", bitOffset = " + this.bitOffset + ", bitLength = " + this.bitLength + (this.nativeTypeOrPointerTargetType == null ? "" : ", ttype = " + this.nativeTypeOrPointerTargetType) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Type resolveType(Type tpe, Type structType) {
        Type ret;
        if (tpe == null || tpe instanceof WildcardType) {
            return null;
        }
        if (tpe instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)tpe;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            Object[] resolvedActualTypeArguments = new Type[actualTypeArguments.length];
            for (int i2 = 0; i2 < actualTypeArguments.length; ++i2) {
                resolvedActualTypeArguments[i2] = StructFieldDescription.resolveType(actualTypeArguments[i2], structType);
            }
            Type resolvedOwnerType = StructFieldDescription.resolveType(pt.getOwnerType(), structType);
            Type rawType = pt.getRawType();
            ret = tpe instanceof CPPType || CPPObject.class.isAssignableFrom(Utils.getClass(rawType)) ? new CPPType(resolvedOwnerType, rawType, resolvedActualTypeArguments) : new DefaultParameterizedType(resolvedOwnerType, rawType, (Type[])resolvedActualTypeArguments);
        } else if (tpe instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)tpe;
            Class structClass = Utils.getClass(structType);
            TypeVariable<Class<T>>[] typeParameters = structClass.getTypeParameters();
            int i3 = Arrays.asList(typeParameters).indexOf(tv);
            if (i3 < 0) throw new RuntimeException("Type param " + tpe + " not found in params of " + structType + " (" + Arrays.asList(typeParameters) + ")");
            if (!(structType instanceof ParameterizedType)) throw new RuntimeException("Type " + structType + " does not have params, cannot resolve " + tpe);
            ParameterizedType pt = (ParameterizedType)structType;
            ret = pt.getActualTypeArguments()[i3];
        } else {
            ret = tpe;
        }
        assert (!Utils.containsTypeVariables(ret));
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StructFieldDescription aggregateDeclarations(Type structType, List<StructFieldDeclaration> fieldGroup) {
        StructFieldDescription aggregatedField = new StructFieldDescription();
        boolean isMultiFields = fieldGroup.size() > 1;
        aggregatedField.aggregatedFields.addAll(fieldGroup);
        for (StructFieldDeclaration field2 : fieldGroup) {
            StructDescription desc;
            if (field2.valueClass.isArray()) {
                throw new RuntimeException("Struct fields cannot be array types : please use a combination of Pointer and @Array (for instance, an int[10] is a @Array(10) Pointer<Integer>).");
            }
            if (field2.valueClass.isPrimitive()) {
                if (field2.desc.isCLong) {
                    field2.desc.byteLength = CLong.SIZE;
                } else if (field2.desc.isSizeT) {
                    field2.desc.byteLength = SizeT.SIZE;
                } else {
                    field2.desc.byteLength = StructUtils.primTypeLength(field2.valueClass);
                    if (field2.desc.alignment < 0L) {
                        field2.desc.alignment = StructUtils.primTypeAlignment(field2.valueClass, field2.desc.byteLength);
                    }
                }
            } else if (field2.valueClass == CLong.class) {
                field2.desc.byteLength = CLong.SIZE;
            } else if (field2.valueClass == SizeT.class) {
                field2.desc.byteLength = SizeT.SIZE;
            } else if (StructObject.class.isAssignableFrom(field2.valueClass)) {
                field2.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(field2.desc.valueType, structType);
                desc = StructIO.getInstance(field2.valueClass, (Type)field2.desc.valueType).desc;
                field2.desc.byteLength = desc.getStructSize();
                if (field2.desc.alignment < 0L) {
                    field2.desc.alignment = desc.getStructAlignment();
                }
                field2.desc.isNativeObject = true;
            } else if (ValuedEnum.class.isAssignableFrom(field2.valueClass)) {
                field2.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(field2.desc.valueType instanceof ParameterizedType ? PointerIO.getClass(((ParameterizedType)field2.desc.valueType).getActualTypeArguments()[0]) : null, structType);
                Class<?> c2 = PointerIO.getClass(field2.desc.nativeTypeOrPointerTargetType);
                if (!IntValuedEnum.class.isAssignableFrom(c2)) throw new RuntimeException("Enum type unknown : " + c2);
                field2.desc.byteLength = 4L;
            } else if (TypedPointer.class.isAssignableFrom(field2.valueClass)) {
                field2.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(field2.desc.valueType, structType);
                if (field2.desc.isArray) {
                    throw new RuntimeException("Typed pointer field cannot be an array : " + field2.desc.name);
                }
                field2.desc.byteLength = Pointer.SIZE;
            } else if (Pointer.class.isAssignableFrom(field2.valueClass)) {
                Type tpe = field2.desc.valueType instanceof ParameterizedType ? ((ParameterizedType)field2.desc.valueType).getActualTypeArguments()[0] : null;
                field2.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(tpe, structType);
                if (field2.desc.isArray) {
                    field2.desc.byteLength = BridJ.sizeOf(field2.desc.nativeTypeOrPointerTargetType);
                    if (field2.desc.alignment < 0L) {
                        field2.desc.alignment = StructUtils.alignmentOf(field2.desc.nativeTypeOrPointerTargetType);
                    }
                } else {
                    field2.desc.byteLength = Pointer.SIZE;
                }
            } else if (Buffer.class.isAssignableFrom(field2.valueClass)) {
                if (field2.valueClass == IntBuffer.class) {
                    field2.desc.byteLength = 4L;
                } else if (field2.valueClass == LongBuffer.class) {
                    field2.desc.byteLength = 8L;
                } else if (field2.valueClass == ShortBuffer.class) {
                    field2.desc.byteLength = 2L;
                } else if (field2.valueClass == ByteBuffer.class) {
                    field2.desc.byteLength = 1L;
                } else if (field2.valueClass == FloatBuffer.class) {
                    field2.desc.byteLength = 4L;
                } else {
                    if (field2.valueClass != DoubleBuffer.class) throw new UnsupportedOperationException("Field array type " + field2.valueClass.getName() + " not supported yet");
                    field2.desc.byteLength = 8L;
                }
            } else if (field2.valueClass.isArray() && field2.valueClass.getComponentType().isPrimitive()) {
                field2.desc.byteLength = StructUtils.primTypeLength(field2.valueClass.getComponentType());
                if (field2.desc.alignment < 0L) {
                    field2.desc.alignment = StructUtils.primTypeAlignment(field2.valueClass, field2.desc.byteLength);
                }
            } else {
                desc = StructIO.getInstance(field2.valueClass, (Type)field2.desc.valueType).desc;
                long s = desc.getStructSize();
                if (s <= 0L) throw new UnsupportedOperationException("Field type " + field2.valueClass.getName() + " not supported yet");
                field2.desc.byteLength = s;
            }
            aggregatedField.alignment = Math.max(aggregatedField.alignment, field2.desc.alignment >= 0L ? field2.desc.alignment : field2.desc.byteLength);
            long length = field2.desc.arrayLength * field2.desc.byteLength;
            if (length >= aggregatedField.byteLength) {
                aggregatedField.byteLength = length;
            }
            if (field2.desc.bitLength < 0L) continue;
            if (isMultiFields) {
                throw new RuntimeException("No support for bit fields unions yet !");
            }
            aggregatedField.bitLength = field2.desc.bitLength;
            aggregatedField.byteLength = (aggregatedField.bitLength >>> 3) + (long)((aggregatedField.bitLength & 7L) != 0L ? 1 : 0);
        }
        return aggregatedField;
    }

    void computeBitMask() {
        if (this.bitLength < 0L) {
            this.bitMask = -1L;
        } else {
            this.bitMask = 0L;
            int i2 = 0;
            while ((long)i2 < this.bitLength) {
                this.bitMask = this.bitMask << 1 | 1L;
                ++i2;
            }
            this.bitMask <<= (int)this.bitOffset;
        }
    }
}

