/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.CRuntime;
import org.bridj.Callback;
import org.bridj.FlagSet;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.TimeT;
import org.bridj.ValuedEnum;
import org.bridj.ann.Convention;
import org.bridj.ann.Name;
import org.bridj.ann.Namespace;
import org.bridj.ann.Ptr;
import org.bridj.ann.Template;
import org.bridj.demangling.GCC4Demangler;
import org.bridj.demangling.VC9Demangler;
import org.bridj.util.AnnotationUtils;
import org.bridj.util.DefaultParameterizedType;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Demangler {
    protected final String str;
    protected final int length;
    protected int position = 0;
    protected final NativeLibrary library;

    public static void main(String[] args) {
        for (String arg : args) {
            try {
                System.out.println("VC9: " + new VC9Demangler(null, arg).parseSymbol());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                System.out.println("GCC4: " + new GCC4Demangler(null, arg).parseSymbol());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Annotations annotations(final Annotation[] aa) {
        return new Annotations(){

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> c2) {
                if (aa == null) {
                    return null;
                }
                for (Annotation a2 : aa) {
                    if (!c2.isInstance(a2)) continue;
                    return (A)a2;
                }
                return null;
            }

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> c2) {
                return AnnotationUtils.isAnnotationPresent(c2, aa);
            }
        };
    }

    public static Annotations annotations(Type e2) {
        return Demangler.annotations(Utils.getClass(e2));
    }

    public static Annotations annotations(final AnnotatedElement e2) {
        return new Annotations(){

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> c2) {
                return e2.getAnnotation(c2);
            }

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> c2) {
                return AnnotationUtils.isAnnotationPresent(c2, e2, new Annotation[0]);
            }
        };
    }

    public abstract MemberRef parseSymbol() throws DemanglingException;

    public Demangler(NativeLibrary library, String str) {
        this.str = str;
        this.length = str.length();
        this.library = library;
    }

    public String getString() {
        return this.str;
    }

    protected void expectChars(char ... cs) throws DemanglingException {
        for (char c2 : cs) {
            char cc = this.consumeChar();
            if (cc == c2) continue;
            throw this.error("Expected char '" + c2 + "', found '" + cc + "'");
        }
    }

    protected void expectAnyChar(char ... cs) throws DemanglingException {
        char cc = this.consumeChar();
        for (char c2 : cs) {
            if (cc != c2) continue;
            return;
        }
        throw this.error("Expected any of " + Arrays.toString(cs) + ", found '" + cc + "'");
    }

    public static StringBuilder implode(StringBuilder b2, Object[] items, String sep) {
        return Demangler.implode(b2, Arrays.asList(items), sep);
    }

    public static StringBuilder implode(StringBuilder b2, Iterable<?> items, String sep) {
        boolean first = true;
        for (Object item : items) {
            if (first) {
                first = false;
            } else {
                b2.append(sep);
            }
            b2.append(item);
        }
        return b2;
    }

    protected char peekChar() {
        return this.peekChar(1);
    }

    protected char peekChar(int dist) {
        int p = this.position + dist - 1;
        return p >= this.length ? (char)'\u0000' : this.str.charAt(p);
    }

    protected char lastChar() {
        return this.position == 0 ? (char)'\u0000' : this.str.charAt(this.position - 1);
    }

    protected char consumeChar() throws DemanglingException {
        char c2 = this.peekChar();
        if (c2 != '\u0000') {
            ++this.position;
        } else {
            throw new DemanglingException("Reached end of string '" + this.str + "'");
        }
        return c2;
    }

    protected boolean consumeCharsIf(char ... nextChars) {
        int initialPosition = this.position;
        try {
            for (char c2 : nextChars) {
                char cc = this.consumeChar();
                if (cc == c2) continue;
                this.position = initialPosition;
                return false;
            }
            return true;
        }
        catch (DemanglingException ex) {
            this.position = initialPosition;
            return false;
        }
    }

    protected boolean consumeCharIf(char ... allowedChars) {
        char c2 = this.peekChar();
        for (char allowedChar : allowedChars) {
            if (allowedChar != c2) continue;
            ++this.position;
            return true;
        }
        return false;
    }

    protected DemanglingException error(int deltaPosition) {
        return this.error(null, deltaPosition);
    }

    protected DemanglingException error(String mess) {
        return this.error(mess, -1);
    }

    protected DemanglingException error(String mess, int deltaPosition) {
        StringBuilder err = new StringBuilder(this.position + 1);
        int position = this.position + deltaPosition;
        for (int i2 = 0; i2 < position; ++i2) {
            err.append(' ');
        }
        err.append('^');
        return new DemanglingException("Parsing error at position " + position + (mess == null ? "" : ": " + mess) + " \n\t" + this.str + "\n\t" + err);
    }

    public static String getMethodName(Method method) {
        Name name = method.getAnnotation(Name.class);
        return name == null ? method.getName() : name.value();
    }

    public static String getClassName(Type type2) {
        assert (type2 != null);
        Class typeClass = Utils.getClass(type2);
        Name name = typeClass.getAnnotation(Name.class);
        return name == null ? typeClass.getSimpleName() : name.value();
    }

    public static String getFullClassName(Type type2) {
        Class typeClass = Utils.getClass(type2);
        String simpleName = Demangler.getClassName(typeClass);
        Namespace namespace = typeClass.getAnnotation(Namespace.class);
        return namespace != null ? namespace.value().replaceAll("::", ".") + "." + simpleName : simpleName;
    }

    protected static TypeRef pointerType(TypeRef tr, boolean isConst, boolean isReference) {
        return new PointerTypeRef(tr, isConst, isReference);
    }

    protected static TypeRef classType(Class<?> c2, Class<? extends Annotation> ... annotations) {
        return Demangler.classType(c2, null, annotations);
    }

    protected static TypeRef classType(Class<?> c2, Type[] genericTypes, Class<? extends Annotation> ... annotations) {
        JavaTypeRef tr = new JavaTypeRef();
        tr.type = genericTypes == null ? c2 : new DefaultParameterizedType(c2, genericTypes);
        tr.annotations = annotations;
        return tr;
    }

    protected static TypeRef simpleType(String name, TemplateArg ... args) {
        return new ClassRef(new Ident(name, args));
    }

    protected static TypeRef simpleType(Ident ident) {
        return new ClassRef(ident);
    }

    static Class<?> getTypeClass(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type2;
            Class<Integer> c2 = (Class<Integer>)pt.getRawType();
            if (ValuedEnum.class.isAssignableFrom(c2)) {
                Type[] types = pt.getActualTypeArguments();
                c2 = types == null || types.length != 1 ? Integer.TYPE : Demangler.getTypeClass(pt.getActualTypeArguments()[0]);
            }
            return c2;
        }
        if (type2 instanceof GenericArrayType && Object.class.isAssignableFrom(Demangler.getTypeClass(((GenericArrayType)type2).getGenericComponentType()))) {
            return Object[].class;
        }
        return null;
    }

    private static Type normalize(Type t) {
        if (t instanceof WildcardType) {
            WildcardType wt = (WildcardType)t;
            if (wt.getLowerBounds().length == 1) {
                return Demangler.normalize(wt.getLowerBounds()[0]);
            }
            return null;
        }
        Class c2 = Utils.getClass(t);
        if (c2 != null && c2.isPrimitive()) {
            if (t == Float.TYPE) {
                return Float.class;
            }
            if (t == Double.TYPE) {
                return Double.class;
            }
            if (t == Byte.TYPE) {
                return Byte.class;
            }
            if (t == Character.TYPE) {
                return Character.class;
            }
            if (t == Short.TYPE) {
                return Short.class;
            }
            if (t == Integer.TYPE) {
                return Integer.class;
            }
            if (t == Long.TYPE) {
                return Long.class;
            }
            if (t == Boolean.TYPE) {
                return Boolean.class;
            }
            if (t == Void.TYPE) {
                return Void.class;
            }
        }
        return t;
    }

    static boolean equivalentTypes(Type a2, Class ac, Annotations aAnnotations, Type b2, Class bc, Annotations bAnnotations) {
        if (Demangler.normalize(a2).equals(Demangler.normalize(b2))) {
            return true;
        }
        if (aAnnotations != null && bAnnotations != null) {
            if (Demangler.xor(Demangler.isPointerLike(a2, ac, aAnnotations), Demangler.isPointerLike(b2, bc, bAnnotations))) {
                return false;
            }
            if (Demangler.xor(Demangler.isCLong(a2, ac, aAnnotations), Demangler.isCLong(b2, bc, bAnnotations))) {
                return false;
            }
        }
        int as = Demangler.getIntegralSize(a2, ac, aAnnotations);
        int bs = Demangler.getIntegralSize(b2, bc, bAnnotations);
        return as != -1 && as == bs;
    }

    static boolean xor(boolean a2, boolean b2) {
        return a2 && !b2 || !a2 && b2;
    }

    static boolean isPointerLike(Type type2, Class typec, Annotations annotations) {
        if (type2 == Long.TYPE || type2 == Long.class) {
            return annotations == null && Pointer.SIZE == 8 || annotations != null && annotations.isAnnotationPresent(Ptr.class) && !annotations.isAnnotationPresent(org.bridj.ann.CLong.class);
        }
        return type2 == SizeT.class || Pointer.class.isAssignableFrom(typec);
    }

    static boolean isCLong(Type type2, Class typec, Annotations annotations) {
        if (type2 == Long.TYPE || type2 == Long.class) {
            return annotations == null && CLong.SIZE == 8 || annotations != null && annotations.isAnnotationPresent(org.bridj.ann.CLong.class);
        }
        return type2 == CLong.class;
    }

    static int getIntegralSize(Type type2, Class typec, Annotations annotations) {
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return 4;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            if (annotations != null) {
                if (annotations.isAnnotationPresent(Ptr.class)) {
                    return Pointer.SIZE;
                }
                if (annotations.isAnnotationPresent(org.bridj.ann.CLong.class)) {
                    return CLong.SIZE;
                }
            }
            return 8;
        }
        if (type2 == CLong.class) {
            return CLong.SIZE;
        }
        if (type2 == SizeT.class) {
            return SizeT.SIZE;
        }
        if (type2 == TimeT.class) {
            return TimeT.SIZE;
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return 1;
        }
        if (type2 == Character.TYPE || type2 == Character.class || type2 == Short.TYPE || type2 == Short.class) {
            return 2;
        }
        if (ValuedEnum.class.isAssignableFrom(typec)) {
            return 4;
        }
        if (Pointer.class.isAssignableFrom(typec)) {
            return SizeT.SIZE;
        }
        return -1;
    }

    public static boolean equivalentTypes(Type a2, Annotations aAnnotations, Type b2, Annotations bAnnotations) {
        return Demangler.equivalentTypes(a2, Demangler.getTypeClass(a2), aAnnotations, b2, Demangler.getTypeClass(b2), bAnnotations);
    }

    static void appendTemplateArgs(StringBuilder b2, Object[] params) {
        if (params == null || params.length == 0) {
            return;
        }
        Demangler.appendArgs(b2, '<', '>', params);
    }

    static void appendArgs(StringBuilder b2, char pre, char post, Object[] params) {
        b2.append(pre);
        if (params != null) {
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 != 0) {
                    b2.append(", ");
                }
                b2.append(params[i2]);
            }
        }
        b2.append(post);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberRef {
        private Integer argumentsStackSize;
        private TypeRef enclosingType;
        private TypeRef valueType;
        private IdentLike memberName;
        Boolean isStatic;
        Boolean isProtected;
        Boolean isPrivate;
        public int modifiers;
        public TypeRef[] paramTypes;
        public TypeRef[] throwTypes;
        TemplateArg[] templateArguments;
        public Convention.Style callingConvention;

        public void setTemplateArguments(TemplateArg[] templateArguments) {
            this.templateArguments = templateArguments;
        }

        public Integer getArgumentsStackSize() {
            return this.argumentsStackSize;
        }

        public void setArgumentsStackSize(Integer argumentsStackSize) {
            this.argumentsStackSize = argumentsStackSize;
        }

        protected boolean matchesEnclosingType(Type type2) {
            return this.getEnclosingType() != null && this.getEnclosingType().matches(type2, Demangler.annotations(type2));
        }

        protected boolean matchesVirtualTable(Type type2) {
            return this.memberName == SpecialName.VFTable && this.matchesEnclosingType(type2);
        }

        protected boolean matchesConstructor(Type type2, Constructor<?> constr) {
            int overrideOffset;
            if (this.memberName != SpecialName.Constructor) {
                return false;
            }
            if (!this.matchesEnclosingType(type2)) {
                return false;
            }
            Template temp = Utils.getClass(type2).getAnnotation(Template.class);
            Annotation[][] anns = constr.getParameterAnnotations();
            Type[] parameterTypes = constr.getGenericParameterTypes();
            return this.matchesArgs(parameterTypes, anns, (overrideOffset = Utils.getEnclosedConstructorParametersOffset(constr)) + (temp == null ? 0 : temp.value().length));
        }

        protected boolean matchesDestructor(Type type2) {
            return this.memberName == SpecialName.Destructor && this.matchesEnclosingType(type2);
        }

        static boolean hasInstance(Object[] array, Class<? extends Annotation> ... cs) {
            for (Object o2 : array) {
                for (Class<? extends Annotation> c2 : cs) {
                    if (!c2.isInstance(o2)) continue;
                    return true;
                }
            }
            return false;
        }

        static int getArgumentsStackSize(Method method) {
            int total = 0;
            Type[] paramTypes = method.getGenericParameterTypes();
            Annotation[][] anns = method.getParameterAnnotations();
            int nArgs = paramTypes.length;
            for (int iArg = 0; iArg < nArgs; ++iArg) {
                Class<?> paramType = Demangler.getTypeClass(paramTypes[iArg]);
                if (paramType == Integer.TYPE) {
                    total += 4;
                    continue;
                }
                if (paramType == Long.TYPE) {
                    Annotation[] as = anns[iArg];
                    if (AnnotationUtils.isAnnotationPresent(Ptr.class, as) || AnnotationUtils.isAnnotationPresent(org.bridj.ann.CLong.class, as)) {
                        total += Pointer.SIZE;
                        continue;
                    }
                    total += 8;
                    continue;
                }
                if (paramType == Float.TYPE) {
                    total += 4;
                    continue;
                }
                if (paramType == Double.TYPE) {
                    total += 8;
                    continue;
                }
                if (paramType == Byte.TYPE) {
                    ++total;
                    continue;
                }
                if (paramType == Character.TYPE) {
                    total += Platform.WCHAR_T_SIZE;
                    continue;
                }
                if (paramType == CLong.class) {
                    total += Platform.CLONG_SIZE;
                    continue;
                }
                if (paramType == SizeT.class) {
                    total += Platform.SIZE_T_SIZE;
                    continue;
                }
                if (paramType == TimeT.class) {
                    total += Platform.TIME_T_SIZE;
                    continue;
                }
                if (paramType == Short.TYPE) {
                    total += 2;
                    continue;
                }
                if (paramType == Boolean.TYPE) {
                    ++total;
                    continue;
                }
                if (Pointer.class.isAssignableFrom(paramType)) {
                    total += Pointer.SIZE;
                    continue;
                }
                if (NativeObject.class.isAssignableFrom(paramType)) {
                    total = (int)((long)total + ((CRuntime)BridJ.getRuntime(paramType)).sizeOf(paramTypes[iArg], null));
                    continue;
                }
                if (FlagSet.class.isAssignableFrom(paramType)) {
                    total += 4;
                    continue;
                }
                throw new RuntimeException("Type not handled : " + paramType.getName());
            }
            return total;
        }

        protected boolean matches(Method method) {
            if (this.memberName instanceof SpecialName) {
                return false;
            }
            if (!this.matchesEnclosingType(method)) {
                return false;
            }
            return this.matchesSignature(method);
        }

        public boolean matchesEnclosingType(Method method) {
            TypeRef et = this.getEnclosingType();
            if (et == null) {
                return true;
            }
            Annotations annotations = Demangler.annotations(method);
            Class<?> dc = method.getDeclaringClass();
            do {
                if (!et.matches(dc, annotations)) continue;
                return true;
            } while ((dc = dc.getSuperclass()) != null && dc != Object.class);
            return false;
        }

        public boolean matchesSignature(Method method) {
            if (this.getArgumentsStackSize() != null && this.getArgumentsStackSize() != MemberRef.getArgumentsStackSize(method)) {
                return false;
            }
            if (this.getMemberName() != null && !this.getMemberName().toString().equals(Demangler.getMethodName(method))) {
                return false;
            }
            if (this.getValueType() != null && !this.getValueType().matches(method.getReturnType(), Demangler.annotations(method))) {
                return false;
            }
            Template temp = method.getAnnotation(Template.class);
            Annotation[][] anns = method.getParameterAnnotations();
            Type[] parameterTypes = method.getGenericParameterTypes();
            return this.paramTypes == null || this.matchesArgs(parameterTypes, anns, temp == null ? 0 : temp.value().length);
        }

        private boolean matchesArgs(Type[] parameterTypes, Annotation[][] anns, int offset) {
            Object paramType;
            int i2;
            int n2;
            int totalArgs = offset;
            int n3 = n2 = this.templateArguments == null ? 0 : this.templateArguments.length;
            for (i2 = 0; i2 < n2; ++i2) {
                if (totalArgs >= parameterTypes.length) {
                    return false;
                }
                paramType = parameterTypes[offset + i2];
                TemplateArg arg = this.templateArguments[i2];
                if (arg instanceof TypeRef) {
                    if (!paramType.equals(Class.class)) {
                        return false;
                    }
                } else if (arg instanceof Constant) {
                    try {
                        Demangler.getTypeClass((Type)paramType).cast(((Constant)arg).value);
                    }
                    catch (ClassCastException ex) {
                        return false;
                    }
                }
                ++totalArgs;
            }
            int n4 = n2 = this.paramTypes == null ? 0 : this.paramTypes.length;
            for (i2 = 0; i2 < n2; ++i2) {
                if (totalArgs >= parameterTypes.length) {
                    return false;
                }
                paramType = this.paramTypes[i2];
                Type parameterType = parameterTypes[totalArgs];
                if (!((TypeRef)paramType).matches(parameterType, Demangler.annotations(anns == null ? null : anns[i2]))) {
                    return false;
                }
                ++totalArgs;
            }
            if (totalArgs != parameterTypes.length) {
                BridJ.error("Not enough args for " + this);
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder b2 = new StringBuilder();
            b2.append(this.valueType).append(' ');
            boolean nameWritten = false;
            if (this.enclosingType != null) {
                b2.append(this.enclosingType);
                b2.append('.');
                if (this.memberName instanceof SpecialName) {
                    switch ((SpecialName)this.memberName) {
                        case Destructor: {
                            b2.append('~');
                        }
                        case Constructor: {
                            b2.append(((ClassRef)this.enclosingType).ident.simpleName);
                            nameWritten = true;
                        }
                    }
                }
            }
            if (!nameWritten) {
                b2.append(this.memberName);
            }
            Demangler.appendTemplateArgs(b2, this.templateArguments);
            Demangler.appendArgs(b2, '(', ')', this.paramTypes);
            return b2.toString();
        }

        public void setMemberName(IdentLike memberName) {
            this.memberName = memberName;
        }

        public IdentLike getMemberName() {
            return this.memberName;
        }

        public void setValueType(TypeRef valueType) {
            this.valueType = valueType;
        }

        public TypeRef getValueType() {
            return this.valueType;
        }

        public void setEnclosingType(TypeRef enclosingType) {
            this.enclosingType = enclosingType;
        }

        public TypeRef getEnclosingType() {
            return this.enclosingType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialName implements IdentLike
    {
        Constructor("", true, true),
        SpecialConstructor("", true, true),
        Destructor("", true, true),
        SelfishDestructor("", true, true),
        DeletingDestructor("", true, true),
        New("new", true, true),
        Delete("delete", true, true),
        NewArray("new[]", true, true),
        DeleteArray("delete[]", true, true),
        VFTable("vftable", false, true),
        VBTable("vbtable", false, true),
        VCall("vcall", false, false),
        TypeOf("typeof", false, false),
        ScalarDeletingDestructor("'scalar deleting destructor'", true, true),
        VectorDeletingDestructor("'vector deleting destructor'", true, true),
        OperatorAssign("operator=", true, true),
        OperatorRShift("operator>>", true, true),
        OperatorDivideAssign("operator/=", true, true),
        OperatorModuloAssign("operator%=", true, true),
        OperatorRShiftAssign("operator>>=", true, true),
        OperatorLShiftAssign("operator<<=", true, true),
        OperatorBitAndAssign("operator&=", true, true),
        OperatorBitOrAssign("operator|=", true, true),
        OperatorXORAssign("operator^=", true, true),
        OperatorLShift("operator<<", true, true),
        OperatorLogicNot("operator!", true, true),
        OperatorEquals("operator==", true, true),
        OperatorDifferent("operator!=", true, true),
        OperatorSquareBrackets("operator[]", true, true),
        OperatorCast("'some cast operator'", true, true),
        OperatorArrow("operator->", true, true),
        OperatorMultiply("operator*", true, true),
        OperatorIncrement("operator++", true, true),
        OperatorDecrement("operator--", true, true),
        OperatorSubstract("operator-", true, true),
        OperatorAdd("operator+", true, true),
        OperatorBitAnd("operator&=", true, true),
        OperatorArrowStar("operator->*", true, true),
        OperatorDivide("operator/", true, true),
        OperatorModulo("operator%", true, true),
        OperatorLower("operator<", true, true),
        OperatorLowerEquals("operator<=", true, true),
        OperatorGreater("operator>", true, true),
        OperatorGreaterEquals("operator>=", true, true),
        OperatorComma("operator,", true, true),
        OperatorParenthesis("operator()", true, true),
        OperatorBitNot("operator~", true, true),
        OperatorXOR("operator^", true, true),
        OperatorBitOr("operator|", true, true),
        OperatorLogicAnd("operator&&", true, true),
        OperatorLogicOr("operator||", true, true),
        OperatorMultiplyAssign("operator*=", true, true),
        OperatorAddAssign("operator+=", true, true),
        OperatorSubstractAssign("operator-=", true, true);

        final String name;
        final boolean isFunction;
        final boolean isMember;

        private SpecialName(String name, boolean isFunction, boolean isMember) {
            this.name = name;
            this.isFunction = isFunction;
            this.isMember = isMember;
        }

        public String toString() {
            return this.name;
        }

        public boolean isFunction() {
            return this.isFunction;
        }

        public boolean isMember() {
            return this.isMember;
        }
    }

    public static class FunctionTypeRef
    extends TypeRef {
        MemberRef function;

        public FunctionTypeRef(MemberRef function) {
            this.function = function;
        }

        public StringBuilder getQualifiedName(StringBuilder b2, boolean generic) {
            return null;
        }

        public boolean matches(Type type2, Annotations annotations) {
            Class<?> typeClass = Demangler.getTypeClass(type2);
            if (!Callback.class.isAssignableFrom(typeClass)) {
                return false;
            }
            Method method = CRuntime.getInstance().getFastestCallbackMethod(typeClass);
            if (method == null) {
                return false;
            }
            return this.function.matches(method);
        }

        public String toString() {
            return this.function.toString();
        }
    }

    public static class ClassRef
    extends TypeRef {
        private TypeRef enclosingType;
        final Ident ident;

        public ClassRef(Ident ident) {
            this.ident = ident;
        }

        public StringBuilder getQualifiedName(StringBuilder b2, boolean generic) {
            if (this.getEnclosingType() instanceof ClassRef) {
                this.getEnclosingType().getQualifiedName(b2, generic).append('$');
            } else if (this.getEnclosingType() instanceof NamespaceRef) {
                this.getEnclosingType().getQualifiedName(b2, generic).append('.');
            }
            b2.append(this.ident.simpleName);
            if (generic && this.ident.templateArguments != null) {
                int args = 0;
                for (TemplateArg arg : this.ident.templateArguments) {
                    if (!(arg instanceof TypeRef)) continue;
                    if (args == 0) {
                        b2.append('<');
                    } else {
                        b2.append(", ");
                    }
                    ((TypeRef)arg).getQualifiedName(b2, generic);
                    ++args;
                }
                if (args > 0) {
                    b2.append('>');
                }
            }
            return b2;
        }

        public Ident getIdent() {
            return this.ident;
        }

        public void setEnclosingType(TypeRef enclosingType) {
            this.enclosingType = enclosingType;
        }

        public TypeRef getEnclosingType() {
            return this.enclosingType;
        }

        public boolean matches(Type type2, Annotations annotations) {
            Class<?> typeClass = Demangler.getTypeClass(type2);
            if (typeClass == null) {
                return false;
            }
            String fullName = Demangler.getFullClassName(ValuedEnum.class.isAssignableFrom(typeClass) ? Demangler.normalize(Utils.getUniqueParameterizedTypeParameter(type2)) : typeClass);
            String qname = this.getQualifiedName(false);
            return fullName != null && fullName.equals(qname);
        }

        public String toString() {
            StringBuilder b2 = new StringBuilder();
            if (this.enclosingType != null) {
                b2.append(this.enclosingType).append('.');
            }
            b2.append(this.ident);
            return b2.toString();
        }
    }

    public static class Ident
    implements IdentLike {
        Object simpleName;
        TemplateArg[] templateArguments;

        public Ident(String simpleName, TemplateArg ... templateArguments) {
            this.simpleName = simpleName;
            this.templateArguments = templateArguments;
        }

        public boolean equals(Object o2) {
            if (o2 == null || !(o2 instanceof Ident)) {
                return false;
            }
            Ident ident = (Ident)o2;
            if (!this.simpleName.equals(ident.simpleName)) {
                return false;
            }
            int n2 = this.templateArguments.length;
            if (ident.templateArguments.length != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.templateArguments[i2].equals(ident.templateArguments[i2])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder b2 = new StringBuilder();
            b2.append(this.simpleName);
            Demangler.appendTemplateArgs(b2, this.templateArguments);
            return b2.toString();
        }
    }

    public static interface IdentLike {
    }

    public static class JavaTypeRef
    extends TypeRef {
        Type type;
        Class<? extends Annotation>[] annotations;

        public StringBuilder getQualifiedName(StringBuilder b2, boolean generic) {
            return b2.append(Demangler.getFullClassName(this.type));
        }

        public boolean matches(Type type2, Annotations annotations) {
            Class<?> tc = Demangler.getTypeClass(this.type);
            Class<?> typec = Demangler.getTypeClass(type2);
            if (typec == null) {
                return true;
            }
            if (tc == typec || tc.equals(typec)) {
                return true;
            }
            if (type2 == Long.TYPE && Pointer.class.isAssignableFrom(tc) || Pointer.class.isAssignableFrom(typec) && tc == Long.TYPE) {
                return true;
            }
            return Demangler.equivalentTypes(type2, typec, annotations, this.type, tc, null);
        }

        public String toString() {
            StringBuilder b2 = new StringBuilder();
            for (Class<? extends Annotation> ann : this.annotations) {
                b2.append(ann.getSimpleName()).append(' ');
            }
            b2.append(this.type instanceof Class ? ((Class)this.type).getSimpleName() : this.type.toString());
            return b2.toString();
        }
    }

    public static class PointerTypeRef
    extends TypeRef {
        public TypeRef pointedType;
        public boolean isReference;
        public boolean isConst;

        public PointerTypeRef(TypeRef pointedType, boolean isConst, boolean isReference) {
            assert (pointedType != null);
            this.pointedType = pointedType;
            this.isReference = isReference;
            this.isConst = isConst;
        }

        public StringBuilder getQualifiedName(StringBuilder b2, boolean generic) {
            return b2.append("org.bridj.Pointer");
        }

        public String toString() {
            return (this.isConst ? "const " : "") + this.pointedType + (this.isReference ? "&" : "*");
        }

        public boolean matches(Type type2, Annotations annotations) {
            if (super.matches(type2, annotations)) {
                return true;
            }
            if (type2 == Long.TYPE && annotations.isAnnotationPresent(Ptr.class)) {
                return true;
            }
            Class<?> typeClass = Demangler.getTypeClass(type2);
            if (!Pointer.class.isAssignableFrom(typeClass)) {
                return false;
            }
            Type pointedType = Demangler.normalize(Utils.getUniqueParameterizedTypeParameter(type2));
            if (this.pointedType == null || this.pointedType.toString().equals("void")) {
                return pointedType == null;
            }
            if (pointedType == null) {
                return true;
            }
            return this.pointedType.matches(pointedType, annotations);
        }
    }

    public static class NamespaceRef
    extends TypeRef {
        Object[] namespace;

        public NamespaceRef(Object ... namespace) {
            this.namespace = namespace;
        }

        public StringBuilder getQualifiedName(StringBuilder b2, boolean generic) {
            return Demangler.implode(b2, this.namespace, ".");
        }

        public String toString() {
            return this.getQualifiedName(new StringBuilder(), true).toString();
        }
    }

    public static class Constant
    implements TemplateArg {
        Object value;

        public Constant(Object value) {
            this.value = value;
        }

        public boolean matchesParam(Object param2, Annotations annotations) {
            return this.value.equals(param2);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static abstract class TypeRef
    implements TemplateArg {
        public abstract StringBuilder getQualifiedName(StringBuilder var1, boolean var2);

        public String getQualifiedName(boolean generic) {
            StringBuilder sb = this.getQualifiedName(new StringBuilder(), generic);
            return sb == null ? null : sb.toString();
        }

        public boolean matchesParam(Object param2, Annotations annotations) {
            return param2 instanceof Type && this.matches((Type)param2, annotations);
        }

        public boolean matches(Type type2, Annotations annotations) {
            String thisName = this.getQualifiedName(false);
            if (thisName == null) {
                return false;
            }
            Class<?> typeClass = Demangler.getTypeClass(type2);
            String name = Demangler.getClassName(typeClass);
            if (thisName.equals(name)) {
                return true;
            }
            Namespace ns = typeClass.getAnnotation(Namespace.class);
            String pack2 = ns == null ? (typeClass.getPackage() == null ? "" : typeClass.getPackage().getName()) : ns.value().replaceAll("\b::\b", ".").trim();
            if (pack2.length() == 0) {
                return false;
            }
            String qname = pack2 + "." + name;
            return thisName.matches("\b" + Pattern.quote(qname));
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Symbol {
        final String symbol;
        long address;
        MemberRef ref;
        boolean refParsed;
        final NativeLibrary library;
        private Convention.Style style;

        public Symbol(String symbol, NativeLibrary library) {
            this.symbol = symbol;
            this.library = library;
        }

        public NativeLibrary getLibrary() {
            return this.library;
        }

        public MemberRef getRef() {
            return this.ref;
        }

        public Convention.Style getStyle() {
            return this.style;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.symbol + (this.ref == null ? "" : " (" + this.ref + ")");
        }

        public long getAddress() {
            if (this.address == 0L) {
                this.address = this.library.getSymbolAddress(this.symbol);
            }
            return this.address;
        }

        public void setAddress(long address) {
            this.address = address;
        }

        public Convention.Style getInferredCallingConvention() {
            if (this.style == null) {
                if (this.symbol.matches("_.*?@\\d+")) {
                    this.style = Convention.Style.StdCall;
                } else if (this.symbol.matches("@.*?@\\d+")) {
                    this.style = Convention.Style.FastCall;
                } else if (Platform.isWindows() && this.symbol.contains("@")) {
                    try {
                        MemberRef mr = this.getParsedRef();
                        if (mr != null) {
                            this.style = mr.callingConvention;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return this.style;
        }

        public boolean matches(Method method) {
            if (!this.symbol.contains(Demangler.getMethodName(method))) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    boolean res = this.ref.matches(method);
                    if (!res && BridJ.debug) {
                        BridJ.debug("Symbol " + this.symbol + " was a good candidate but expected demangled signature " + this.ref + " did not match the method " + method);
                    }
                    return res;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public MemberRef getParsedRef() {
            this.parse();
            return this.ref;
        }

        synchronized void parse() {
            if (!this.refParsed) {
                block4: {
                    try {
                        this.ref = this.library.parseSymbol(this.symbol);
                    }
                    catch (DemanglingException ex) {
                        if (BridJ.debug) {
                            ex.printStackTrace();
                        }
                        if (!BridJ.verbose) break block4;
                        BridJ.warning("Symbol parsing failed : " + ex.getMessage());
                    }
                }
                this.refParsed = true;
            }
        }

        public String getName() {
            return this.symbol;
        }

        public boolean matchesVirtualTable(Class<?> type2) {
            if (!this.symbol.contains(type2.getSimpleName())) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    return this.ref.matchesVirtualTable(type2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public boolean matchesConstructor(Type type2, Constructor<?> constr) {
            if (!this.symbol.contains(Demangler.getClassName(type2))) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    return this.ref.matchesConstructor(type2, constr);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public boolean matchesDestructor(Class<?> type2) {
            if (!this.symbol.contains(type2.getSimpleName())) {
                return false;
            }
            this.parse();
            try {
                if (this.ref != null) {
                    return this.ref.matchesDestructor(type2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        public boolean isVirtualTable() {
            return false;
        }
    }

    public static interface TemplateArg {
        public boolean matchesParam(Object var1, Annotations var2);
    }

    public class DemanglingException
    extends Exception {
        public DemanglingException(String mess) {
            this(mess, null);
        }

        public DemanglingException(String mess, Throwable cause) {
            super(mess + " (in symbol '" + Demangler.this.str + "')", cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Annotations {
        public <A extends Annotation> A getAnnotation(Class<A> var1);

        public boolean isAnnotationPresent(Class<? extends Annotation> var1);
    }
}

