/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class RealFFTUtils_2D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private static final long ONEL = 1L;
    private static final long TWOL = 2L;
    private static final long ZEROL = 0L;
    private final int columns;
    private final int rows;
    private final long columnsl;
    private final long rowsl;

    public RealFFTUtils_2D(long rows, long columns) {
        this.columns = (int)columns;
        this.rows = (int)rows;
        this.columnsl = columns;
        this.rowsl = rows;
    }

    public int getIndex(int r, int c2) {
        int cmod2 = c2 & 1;
        int rmul2 = r << 1;
        if (r != 0) {
            if (c2 <= 1) {
                if (rmul2 == this.rows) {
                    if (cmod2 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return this.rows * this.columns >> 1;
                }
                if (rmul2 < this.rows) {
                    return this.columns * r + cmod2;
                }
                if (cmod2 == 0) {
                    return this.columns * (this.rows - r);
                }
                return -(this.columns * (this.rows - r) + 1);
            }
            if (c2 == this.columns || c2 == this.columns + 1) {
                if (rmul2 == this.rows) {
                    if (cmod2 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return (this.rows * this.columns >> 1) + 1;
                }
                if (rmul2 < this.rows) {
                    if (cmod2 == 0) {
                        return this.columns * (this.rows - r) + 1;
                    }
                    return -(this.columns * (this.rows - r));
                }
                return this.columns * r + 1 - cmod2;
            }
            if (c2 < this.columns) {
                return this.columns * r + c2;
            }
            if (cmod2 == 0) {
                return this.columns * (this.rows + 2 - r) - c2;
            }
            return -(this.columns * (this.rows + 2 - r) - c2 + 2);
        }
        if (c2 == 1 || c2 == this.columns + 1) {
            return Integer.MIN_VALUE;
        }
        if (c2 == this.columns) {
            return 1;
        }
        if (c2 < this.columns) {
            return c2;
        }
        if (cmod2 == 0) {
            return (this.columns << 1) - c2;
        }
        return -((this.columns << 1) - c2 + 2);
    }

    public long getIndex(long r, long c2) {
        long cmod2 = c2 & 1L;
        long rmul2 = r << 1;
        if (r != 0L) {
            if (c2 <= 1L) {
                if (rmul2 == this.rowsl) {
                    if (cmod2 == 1L) {
                        return Long.MIN_VALUE;
                    }
                    return this.rowsl * this.columnsl >> 1;
                }
                if (rmul2 < this.rowsl) {
                    return this.columnsl * r + cmod2;
                }
                if (cmod2 == 0L) {
                    return this.columnsl * (this.rowsl - r);
                }
                return -(this.columnsl * (this.rowsl - r) + 1L);
            }
            if (c2 == this.columnsl || c2 == this.columnsl + 1L) {
                if (rmul2 == this.rowsl) {
                    if (cmod2 == 1L) {
                        return Long.MIN_VALUE;
                    }
                    return (this.rowsl * this.columnsl >> 1) + 1L;
                }
                if (rmul2 < this.rowsl) {
                    if (cmod2 == 0L) {
                        return this.columnsl * (this.rowsl - r) + 1L;
                    }
                    return -(this.columnsl * (this.rowsl - r));
                }
                return this.columnsl * r + 1L - cmod2;
            }
            if (c2 < this.columnsl) {
                return this.columnsl * r + c2;
            }
            if (cmod2 == 0L) {
                return this.columnsl * (this.rowsl + 2L - r) - c2;
            }
            return -(this.columnsl * (this.rowsl + 2L - r) - c2 + 2L);
        }
        if (c2 == 1L || c2 == this.columnsl + 1L) {
            return Long.MIN_VALUE;
        }
        if (c2 == this.columnsl) {
            return 1L;
        }
        if (c2 < this.columnsl) {
            return c2;
        }
        if (cmod2 == 0L) {
            return (this.columnsl << 1) - c2;
        }
        return -((this.columnsl << 1) - c2 + 2L);
    }

    public void pack(double val, int r, int c2, double[] packed, int pos) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            packed[pos + index] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[pos - index] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public void pack(double val, long r, long c2, DoubleLargeArray packed, long pos) {
        long index = this.getIndex(r, c2);
        if (index >= 0L) {
            packed.setDouble(pos + index, val);
        } else if (index > Long.MIN_VALUE) {
            packed.setDouble(pos - index, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public void pack(double val, int r, int c2, double[][] packed) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            packed[index / this.columns][index % this.columns] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[-index / this.columns][-index % this.columns] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public void pack(float val, int r, int c2, float[] packed, int pos) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            packed[pos + index] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[pos - index] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public void pack(float val, long r, long c2, FloatLargeArray packed, long pos) {
        long index = this.getIndex(r, c2);
        if (index >= 0L) {
            packed.setFloat(pos + index, val);
        } else if (index > Long.MIN_VALUE) {
            packed.setFloat(pos - index, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public void pack(float val, int r, int c2, float[][] packed) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            packed[index / this.columns][index % this.columns] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[-index / this.columns][-index % this.columns] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public double unpack(int r, int c2, double[] packed, int pos) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            return packed[pos + index];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[pos - index];
        }
        return 0.0;
    }

    public double unpack(long r, long c2, DoubleLargeArray packed, long pos) {
        long index = this.getIndex(r, c2);
        if (index >= 0L) {
            return packed.getDouble(pos + index);
        }
        if (index > Long.MIN_VALUE) {
            return -packed.getDouble(pos - index);
        }
        return 0.0;
    }

    public double unpack(int r, int c2, double[][] packed) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            return packed[index / this.columns][index % this.columns];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[-index / this.columns][-index % this.columns];
        }
        return 0.0;
    }

    public float unpack(int r, int c2, float[] packed, int pos) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            return packed[pos + index];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[pos - index];
        }
        return 0.0f;
    }

    public float unpack(long r, long c2, FloatLargeArray packed, long pos) {
        long index = this.getIndex(r, c2);
        if (index >= 0L) {
            return packed.getFloat(pos + index);
        }
        if (index > Long.MIN_VALUE) {
            return -packed.getFloat(pos - index);
        }
        return 0.0f;
    }

    public float unpack(int r, int c2, float[][] packed) {
        int index = this.getIndex(r, c2);
        if (index >= 0) {
            return packed[index / this.columns][index % this.columns];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[-index / this.columns][-index % this.columns];
        }
        return 0.0f;
    }
}

