/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class RealFFTUtils_3D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private static final long ONEL = 1L;
    private static final long TWOL = 2L;
    private static final long ZEROL = 0L;
    private final int columns;
    private final long columnsl;
    private final int rows;
    private final long rowsl;
    private final int rowStride;
    private final long rowStridel;
    private final int slices;
    private final long slicesl;
    private final int sliceStride;
    private final long sliceStridel;

    public RealFFTUtils_3D(long slices, long rows, long columns) {
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowStride = (int)columns;
        this.sliceStride = (int)rows * this.rowStride;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.rowStridel = columns;
        this.sliceStridel = rows * this.rowStridel;
    }

    public int getIndex(int s, int r, int c2) {
        int rr;
        int cmod2 = c2 & 1;
        int rmul2 = r << 1;
        int smul2 = s << 1;
        int ss = s == 0 ? 0 : this.slices - s;
        int n2 = rr = r == 0 ? 0 : this.rows - r;
        if (c2 <= 1) {
            if (r == 0) {
                if (s == 0) {
                    return c2 == 0 ? 0 : Integer.MIN_VALUE;
                }
                if (smul2 < this.slices) {
                    return s * this.sliceStride + c2;
                }
                if (smul2 > this.slices) {
                    int index = ss * this.sliceStride;
                    return cmod2 == 0 ? index : -(index + 1);
                }
                return cmod2 == 0 ? s * this.sliceStride : Integer.MIN_VALUE;
            }
            if (rmul2 < this.rows) {
                return s * this.sliceStride + r * this.rowStride + c2;
            }
            if (rmul2 > this.rows) {
                int index = ss * this.sliceStride + rr * this.rowStride;
                return cmod2 == 0 ? index : -(index + 1);
            }
            if (s == 0) {
                return cmod2 == 0 ? r * this.rowStride : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                return s * this.sliceStride + r * this.rowStride + c2;
            }
            if (smul2 > this.slices) {
                int index = ss * this.sliceStride + r * this.rowStride;
                return cmod2 == 0 ? index : -(index + 1);
            }
            int index = s * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index : Integer.MIN_VALUE;
        }
        if (c2 < this.columns) {
            return s * this.sliceStride + r * this.rowStride + c2;
        }
        if (c2 > this.columns + 1) {
            int cc = (this.columns << 1) - c2;
            int index = ss * this.sliceStride + rr * this.rowStride + cc;
            return cmod2 == 0 ? index : -(index + 2);
        }
        if (r == 0) {
            if (s == 0) {
                return cmod2 == 0 ? 1 : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                int index = ss * this.sliceStride;
                return cmod2 == 0 ? index + 1 : -index;
            }
            if (smul2 > this.slices) {
                int index = s * this.sliceStride;
                return cmod2 == 0 ? index + 1 : index;
            }
            int index = s * this.sliceStride;
            return cmod2 == 0 ? index + 1 : Integer.MIN_VALUE;
        }
        if (rmul2 < this.rows) {
            int index = ss * this.sliceStride + rr * this.rowStride;
            return cmod2 == 0 ? index + 1 : -index;
        }
        if (rmul2 > this.rows) {
            int index = s * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index + 1 : index;
        }
        if (s == 0) {
            int index = r * this.rowStride + 1;
            return cmod2 == 0 ? index : Integer.MIN_VALUE;
        }
        if (smul2 < this.slices) {
            int index = ss * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index + 1 : -index;
        }
        if (smul2 > this.slices) {
            int index = s * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index + 1 : index;
        }
        int index = s * this.sliceStride + r * this.rowStride;
        return cmod2 == 0 ? index + 1 : Integer.MIN_VALUE;
    }

    public long getIndex(long s, long r, long c2) {
        long rr;
        long cmod2 = c2 & 1L;
        long rmul2 = r << 1;
        long smul2 = s << 1;
        long ss = s == 0L ? 0L : this.slicesl - s;
        long l2 = rr = r == 0L ? 0L : this.rowsl - r;
        if (c2 <= 1L) {
            if (r == 0L) {
                if (s == 0L) {
                    return c2 == 0L ? 0L : Long.MIN_VALUE;
                }
                if (smul2 < this.slicesl) {
                    return s * this.sliceStridel + c2;
                }
                if (smul2 > this.slicesl) {
                    long index = ss * this.sliceStridel;
                    return cmod2 == 0L ? index : -(index + 1L);
                }
                return cmod2 == 0L ? s * this.sliceStridel : Long.MIN_VALUE;
            }
            if (rmul2 < this.rowsl) {
                return s * this.sliceStridel + r * this.rowStridel + c2;
            }
            if (rmul2 > this.rowsl) {
                long index = ss * this.sliceStridel + rr * this.rowStridel;
                return cmod2 == 0L ? index : -(index + 1L);
            }
            if (s == 0L) {
                return cmod2 == 0L ? r * this.rowStridel : Long.MIN_VALUE;
            }
            if (smul2 < this.slicesl) {
                return s * this.sliceStridel + r * this.rowStridel + c2;
            }
            if (smul2 > this.slicesl) {
                long index = ss * this.sliceStridel + r * this.rowStridel;
                return cmod2 == 0L ? index : -(index + 1L);
            }
            long index = s * this.sliceStridel + r * this.rowStridel;
            return cmod2 == 0L ? index : Long.MIN_VALUE;
        }
        if (c2 < this.columnsl) {
            return s * this.sliceStridel + r * this.rowStridel + c2;
        }
        if (c2 > this.columnsl + 1L) {
            long cc = (this.columnsl << 1) - c2;
            long index = ss * this.sliceStridel + rr * this.rowStridel + cc;
            return cmod2 == 0L ? index : -(index + 2L);
        }
        if (r == 0L) {
            if (s == 0L) {
                return cmod2 == 0L ? 1L : Long.MIN_VALUE;
            }
            if (smul2 < this.slicesl) {
                long index = ss * this.sliceStridel;
                return cmod2 == 0L ? index + 1L : -index;
            }
            if (smul2 > this.slicesl) {
                long index = s * this.sliceStridel;
                return cmod2 == 0L ? index + 1L : index;
            }
            long index = s * this.sliceStridel;
            return cmod2 == 0L ? index + 1L : Long.MIN_VALUE;
        }
        if (rmul2 < this.rowsl) {
            long index = ss * this.sliceStridel + rr * this.rowStridel;
            return cmod2 == 0L ? index + 1L : -index;
        }
        if (rmul2 > this.rowsl) {
            long index = s * this.sliceStridel + r * this.rowStridel;
            return cmod2 == 0L ? index + 1L : index;
        }
        if (s == 0L) {
            long index = r * this.rowStridel + 1L;
            return cmod2 == 0L ? index : Long.MIN_VALUE;
        }
        if (smul2 < this.slicesl) {
            long index = ss * this.sliceStridel + r * this.rowStridel;
            return cmod2 == 0L ? index + 1L : -index;
        }
        if (smul2 > this.slicesl) {
            long index = s * this.sliceStridel + r * this.rowStridel;
            return cmod2 == 0L ? index + 1L : index;
        }
        long index = s * this.sliceStridel + r * this.rowStridel;
        return cmod2 == 0L ? index + 1L : Long.MIN_VALUE;
    }

    public void pack(double val, int s, int r, int c2, double[] packed, int pos) {
        int i2 = this.getIndex(s, r, c2);
        if (i2 >= 0) {
            packed[pos + i2] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[pos - i2] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c2));
        }
    }

    public void pack(double val, long s, long r, long c2, DoubleLargeArray packed, long pos) {
        long i2 = this.getIndex(s, r, c2);
        if (i2 >= 0L) {
            packed.setDouble(pos + i2, val);
        } else if (i2 > Long.MIN_VALUE) {
            packed.setDouble(pos - i2, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c2));
        }
    }

    public void pack(double val, int s, int r, int c2, double[][][] packed) {
        int i2 = this.getIndex(s, r, c2);
        int ii = FastMath.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            packed[ss][rr][cc] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c2));
        }
    }

    public void pack(float val, int s, int r, int c2, float[] packed, int pos) {
        int i2 = this.getIndex(s, r, c2);
        if (i2 >= 0) {
            packed[pos + i2] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[pos - i2] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c2));
        }
    }

    public void pack(float val, long s, long r, long c2, FloatLargeArray packed, long pos) {
        long i2 = this.getIndex(s, r, c2);
        if (i2 >= 0L) {
            packed.setFloat(pos + i2, val);
        } else if (i2 > Long.MIN_VALUE) {
            packed.setFloat(pos - i2, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c2));
        }
    }

    public void pack(float val, int s, int r, int c2, float[][][] packed) {
        int i2 = this.getIndex(s, r, c2);
        int ii = FastMath.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            packed[ss][rr][cc] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s, r, c2));
        }
    }

    public double unpack(int s, int r, int c2, double[] packed, int pos) {
        int i2 = this.getIndex(s, r, c2);
        if (i2 >= 0) {
            return packed[pos + i2];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[pos - i2];
        }
        return 0.0;
    }

    public double unpack(long s, long r, long c2, DoubleLargeArray packed, long pos) {
        long i2 = this.getIndex(s, r, c2);
        if (i2 >= 0L) {
            return packed.getDouble(pos + i2);
        }
        if (i2 > Long.MIN_VALUE) {
            return -packed.getDouble(pos - i2);
        }
        return 0.0;
    }

    public double unpack(int s, int r, int c2, double[][][] packed) {
        int i2 = this.getIndex(s, r, c2);
        int ii = FastMath.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            return packed[ss][rr][cc];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[ss][rr][cc];
        }
        return 0.0;
    }

    public float unpack(int s, int r, int c2, float[] packed, int pos) {
        int i2 = this.getIndex(s, r, c2);
        if (i2 >= 0) {
            return packed[pos + i2];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[pos - i2];
        }
        return 0.0f;
    }

    public float unpack(long s, long r, long c2, FloatLargeArray packed, long pos) {
        long i2 = this.getIndex(s, r, c2);
        if (i2 >= 0L) {
            return packed.getFloat(pos + i2);
        }
        if (i2 > Long.MIN_VALUE) {
            return -packed.getFloat(pos - i2);
        }
        return 0.0f;
    }

    public float unpack(int s, int r, int c2, float[][][] packed) {
        int i2 = this.getIndex(s, r, c2);
        int ii = FastMath.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            return packed[ss][rr][cc];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed[ss][rr][cc];
        }
        return 0.0f;
    }
}

