/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AiffAudioOutputStream;
import org.tritonus.sampled.file.AuAudioOutputStream;
import org.tritonus.sampled.file.WaveAudioOutputStream;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;
import org.tritonus.share.sampled.file.TNonSeekableDataOutputStream;
import org.tritonus.share.sampled.file.TSeekableDataOutputStream;

public class AudioSystemShadow {
    public static TDataOutputStream getDataOutputStream(File file) throws IOException {
        return new TSeekableDataOutputStream(file);
    }

    public static TDataOutputStream getDataOutputStream(OutputStream stream) throws IOException {
        return new TNonSeekableDataOutputStream(stream);
    }

    public static AudioOutputStream getAudioOutputStream(AudioFileFormat.Type type2, AudioFormat audioFormat, long lLengthInBytes, TDataOutputStream dataOutputStream) {
        TAudioOutputStream audioOutputStream = null;
        if (type2.equals(AudioFileFormat.Type.AIFF) || type2.equals(AudioFileFormat.Type.AIFF)) {
            audioOutputStream = new AiffAudioOutputStream(audioFormat, type2, lLengthInBytes, dataOutputStream);
        } else if (type2.equals(AudioFileFormat.Type.AU)) {
            audioOutputStream = new AuAudioOutputStream(audioFormat, lLengthInBytes, dataOutputStream);
        } else if (type2.equals(AudioFileFormat.Type.WAVE)) {
            audioOutputStream = new WaveAudioOutputStream(audioFormat, lLengthInBytes, dataOutputStream);
        }
        return audioOutputStream;
    }

    public static AudioOutputStream getAudioOutputStream(AudioFileFormat.Type type2, AudioFormat audioFormat, long lLengthInBytes, File file) throws IOException {
        TDataOutputStream dataOutputStream = AudioSystemShadow.getDataOutputStream(file);
        AudioOutputStream audioOutputStream = AudioSystemShadow.getAudioOutputStream(type2, audioFormat, lLengthInBytes, dataOutputStream);
        return audioOutputStream;
    }

    public static AudioOutputStream getAudioOutputStream(AudioFileFormat.Type type2, AudioFormat audioFormat, long lLengthInBytes, OutputStream outputStream) throws IOException {
        TDataOutputStream dataOutputStream = AudioSystemShadow.getDataOutputStream(outputStream);
        AudioOutputStream audioOutputStream = AudioSystemShadow.getAudioOutputStream(type2, audioFormat, lLengthInBytes, dataOutputStream);
        return audioOutputStream;
    }
}

