/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayArithmetics;
import pl.edu.icm.jlargearrays.LargeArrayStatistics;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class Benchmark {
    private static void writeToFile(long[] sizes, int[] nthreads, double[][] results, String file) {
        try {
            int th;
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
            writer.newLine();
            writer.write(System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
            writer.newLine();
            writer.write("Available processors (cores): " + Runtime.getRuntime().availableProcessors());
            writer.newLine();
            writer.write("Total memory (bytes): " + Runtime.getRuntime().totalMemory());
            writer.newLine();
            writer.write("Number of threads: {");
            for (th = 0; th < nthreads.length; ++th) {
                if (th < nthreads.length - 1) {
                    writer.write(nthreads[th] + ",");
                    continue;
                }
                writer.write(nthreads[nthreads.length - 1] + "}");
            }
            writer.newLine();
            writer.write("Sizes: {");
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                if (i2 < sizes.length - 1) {
                    writer.write(sizes[i2] + ",");
                    continue;
                }
                writer.write(sizes[sizes.length - 1] + "}");
            }
            writer.newLine();
            writer.write("Timings: {");
            for (th = 0; th < nthreads.length; ++th) {
                int i3;
                writer.write("{");
                if (th < nthreads.length - 1) {
                    for (i3 = 0; i3 < sizes.length; ++i3) {
                        if (i3 < sizes.length - 1) {
                            writer.write(results[th][i3] + ",");
                            continue;
                        }
                        writer.write(results[th][i3] + "},");
                    }
                    writer.newLine();
                    continue;
                }
                for (i3 = 0; i3 < sizes.length; ++i3) {
                    if (i3 < sizes.length - 1) {
                        writer.write(results[th][i3] + ",");
                        continue;
                    }
                    writer.write(results[th][i3] + "}}");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static double[][] benchmarkJavaArraysByteSequential(long[] sizes, int[] nthreads, int iters, String file) {
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] <= 0x7FFFFFFBL) continue;
            return null;
        }
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking java arrays (bytes, sequentual)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i3 = 0; i3 < sizes.length; ++i3) {
                System.out.print("\tSize = " + sizes[i3]);
                final byte[] a2 = new byte[(int)sizes[i3]];
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i3] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final int firstIdx = (int)((long)j2 * k2);
                        final int lastIdx = (int)(j2 == nt - 1 ? sizes[i3] : (long)firstIdx + k2);
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int k2 = firstIdx;
                                while (k2 < lastIdx) {
                                    a2[k2] = 1;
                                    int n2 = k2++;
                                    a2[n2] = (byte)(a2[n2] + 1);
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i3] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i3]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJavaArraysDoubleSequential(long[] sizes, int[] nthreads, int iters, String file) {
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] <= 0x7FFFFFFBL) continue;
            return null;
        }
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking java arrays (doubles, sequentual)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i3 = 0; i3 < sizes.length; ++i3) {
                System.out.print("\tSize = " + sizes[i3]);
                final double[] a2 = new double[(int)sizes[i3]];
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i3] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final int firstIdx = (int)((long)j2 * k2);
                        final int lastIdx = (int)(j2 == nt - 1 ? sizes[i3] : (long)firstIdx + k2);
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int k2 = firstIdx;
                                while (k2 < lastIdx) {
                                    a2[k2] = 1.0;
                                    int n2 = k2++;
                                    a2[n2] = a2[n2] + 1.0;
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i3] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i3]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJavaArraysByteRandom(long[] sizes, int[] nthreads, int iters, String file) {
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] <= 0x7FFFFFFBL) continue;
            return null;
        }
        final int[] randIdx = new int[(int)sizes[sizes.length - 1]];
        double[][] results = new double[nthreads.length][sizes.length];
        Random r = new Random(0L);
        System.out.println("generating random indices.");
        int max2 = (int)sizes[sizes.length - 1];
        for (int i3 = 0; i3 < max2; ++i3) {
            randIdx[i3] = (int)(r.nextDouble() * (double)(max2 - 1));
        }
        System.out.println("Benchmarking java arrays (bytes, random)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i4 = 0; i4 < sizes.length; ++i4) {
                System.out.print("\tSize = " + sizes[i4]);
                final byte[] a2 = new byte[(int)sizes[i4]];
                final long size = sizes[i4];
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i4] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final int firstIdx = (int)((long)j2 * k2);
                        final int lastIdx = (int)(j2 == nt - 1 ? size : (long)firstIdx + k2);
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (int k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    int idx = (int)((long)randIdx[k2] % size);
                                    a2[idx] = 1;
                                    int n2 = idx;
                                    a2[n2] = (byte)(a2[n2] + 1);
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i4] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i4]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJavaArraysDoubleRandom(long[] sizes, int[] nthreads, int iters, String file) {
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            if (sizes[i2] <= 0x7FFFFFFBL) continue;
            return null;
        }
        final int[] randIdx = new int[(int)sizes[sizes.length - 1]];
        double[][] results = new double[nthreads.length][sizes.length];
        Random r = new Random(0L);
        System.out.println("generating random indices.");
        int max2 = (int)sizes[sizes.length - 1];
        for (int i3 = 0; i3 < max2; ++i3) {
            randIdx[i3] = (int)(r.nextDouble() * (double)(max2 - 1));
        }
        System.out.println("Benchmarking java arrays (double, random)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i4 = 0; i4 < sizes.length; ++i4) {
                System.out.print("\tSize = " + sizes[i4]);
                final double[] a2 = new double[(int)sizes[i4]];
                final long size = sizes[i4];
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i4] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final int firstIdx = (int)((long)j2 * k2);
                        final int lastIdx = (int)(j2 == nt - 1 ? size : (long)firstIdx + k2);
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (int k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    int idx = (int)((long)randIdx[k2] % size);
                                    a2[idx] = 1.0;
                                    int n2 = idx;
                                    a2[n2] = a2[n2] + 1.0;
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i4] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i4]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysByteSequentual(long[] sizes, int[] nthreads, int iters, String file) {
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking JLargeArrays (bytes, sequentual)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                System.out.print("\tSize = " + sizes[i2]);
                final ByteLargeArray a2 = new ByteLargeArray(sizes[i2]);
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i2] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i2] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    a2.setByte(k2, (byte)1);
                                    a2.setByte(k2, (byte)(a2.getByte(k2) + 1));
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i2] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i2]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysByteSequentualNative(long[] sizes, int[] nthreads, int iters, String file) {
        LargeArray.setMaxSizeOf32bitArray(1);
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking JLargeArrays (bytes, sequentual, native)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                System.out.print("\tSize = " + sizes[i2]);
                final ByteLargeArray a2 = new ByteLargeArray(sizes[i2]);
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i2] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i2] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    a2.setToNative(k2, (byte)1);
                                    a2.setToNative(k2, (byte)(a2.getFromNative(k2) + 1));
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i2] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i2]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysByteSequentual_safe(long[] sizes, int[] nthreads, int iters, String file) {
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking JLargeArrays (bytes, sequentual, with bounds checking)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                System.out.print("\tSize = " + sizes[i2]);
                final ByteLargeArray a2 = new ByteLargeArray(sizes[i2]);
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i2] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i2] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    a2.setByte_safe(k2, (byte)1);
                                    a2.setByte_safe(k2, (byte)(a2.getByte_safe(k2) + 1));
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i2] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i2]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysDoubleSequentual(long[] sizes, int[] nthreads, int iters, String file) {
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking JLargeArrays (doubles, sequentual)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                System.out.print("\tSize = " + sizes[i2]);
                final DoubleLargeArray a2 = new DoubleLargeArray(sizes[i2]);
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i2] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i2] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    a2.setDouble(k2, 1.0);
                                    a2.setDouble(k2, a2.getDouble(k2) + 1.0);
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i2] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i2]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysDoubleSequentualNative(long[] sizes, int[] nthreads, int iters, String file) {
        LargeArray.setMaxSizeOf32bitArray(1);
        double[][] results = new double[nthreads.length][sizes.length];
        System.out.println("Benchmarking JLargeArrays (doubles, sequentual, native)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                System.out.print("\tSize = " + sizes[i2]);
                final DoubleLargeArray a2 = new DoubleLargeArray(sizes[i2]);
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i2] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i2] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    a2.setToNative(k2, 1.0);
                                    a2.setToNative(k2, a2.getFromNative(k2) + 1.0);
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i2] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i2]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysByteRandom(long[] sizes, int[] nthreads, int iters, String file) {
        final int[] randIdx = new int[(int)sizes[sizes.length - 1]];
        double[][] results = new double[nthreads.length][sizes.length];
        Random r = new Random(0L);
        System.out.println("generating random indices.");
        int max2 = (int)sizes[sizes.length - 1];
        for (int i2 = 0; i2 < max2; ++i2) {
            randIdx[i2] = (int)(r.nextDouble() * (double)(max2 - 1));
        }
        System.out.println("Benchmarking JLargeArrays (bytes, random)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i3 = 0; i3 < sizes.length; ++i3) {
                System.out.print("\tSize = " + sizes[i3]);
                final ByteLargeArray a2 = new ByteLargeArray(sizes[i3]);
                final int size = (int)sizes[i3];
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i3] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i3] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    long idx = randIdx[(int)k2] % size;
                                    a2.setByte(idx, (byte)1);
                                    a2.setByte(idx, (byte)(a2.getByte(idx) + 1));
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i3] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i3]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static double[][] benchmarkJLargeArraysDoubleRandom(long[] sizes, int[] nthreads, int iters, String file) {
        final int[] randIdx = new int[(int)sizes[sizes.length - 1]];
        double[][] results = new double[nthreads.length][sizes.length];
        Random r = new Random(0L);
        System.out.println("generating random indices.");
        int max2 = (int)sizes[sizes.length - 1];
        for (int i2 = 0; i2 < max2; ++i2) {
            randIdx[i2] = (int)(r.nextDouble() * (double)(max2 - 1));
        }
        System.out.println("Benchmarking JLargeArrays (doubles, random)");
        for (int th = 0; th < nthreads.length; ++th) {
            int nt = nthreads[th];
            Thread[] threads = new Thread[nt];
            System.out.println("\tNumber of threads = " + nt);
            for (int i3 = 0; i3 < sizes.length; ++i3) {
                System.out.print("\tSize = " + sizes[i3]);
                final DoubleLargeArray a2 = new DoubleLargeArray(sizes[i3]);
                final int size = (int)sizes[i3];
                double t = System.nanoTime();
                for (int it = 0; it < iters; ++it) {
                    int j2;
                    long k2 = sizes[i3] / (long)nt;
                    for (j2 = 0; j2 < nt; ++j2) {
                        final long firstIdx = (long)j2 * k2;
                        final long lastIdx = j2 == nt - 1 ? sizes[i3] : firstIdx + k2;
                        threads[j2] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                    long idx = randIdx[(int)k2] % size;
                                    a2.setDouble(idx, 1.0);
                                    a2.setDouble(idx, a2.getDouble(idx) + 1.0);
                                }
                            }
                        });
                        threads[j2].start();
                    }
                    try {
                        for (j2 = 0; j2 < nt; ++j2) {
                            threads[j2].join();
                            threads[j2] = null;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                results[th][i3] = ((double)System.nanoTime() - t) / 1.0E9 / (double)iters;
                System.out.println(" : " + String.format("%.7f sec", results[th][i3]));
            }
        }
        Benchmark.writeToFile(sizes, nthreads, results, file);
        return results;
    }

    public static void benchmarkByteSequential(long[] sizes, int[] nthreads, int iters, String directory) {
        Benchmark.benchmarkJavaArraysDoubleSequential(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "java_arrays_byte_sequential.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysByteSequentual(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "jlargearrays_byte_sequentual.txt");
    }

    public static void benchmarkDoubleSequential(long[] sizes, int[] nthreads, int iters, String directory) {
        Benchmark.benchmarkJavaArraysDoubleSequential(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "java_arrays_double_sequential.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysDoubleSequentual(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "jlargearrays_double_sequentual.txt");
    }

    public static void benchmarkByteRandom(long[] sizes, int[] nthreads, int iters, String directory) {
        Benchmark.benchmarkJavaArraysByteRandom(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "java_arrays_byte_random.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysByteRandom(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "jlargearrays_byte_random.txt");
    }

    public static void benchmarkDoubleRandom(long[] sizes, int[] nthreads, int iters, String directory) {
        Benchmark.benchmarkJavaArraysDoubleRandom(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "java_arrays_double_random.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysDoubleRandom(sizes, nthreads, iters, directory + System.getProperty("file.separator") + "jlargearrays_double_random.txt");
    }

    public static void benchmarkByteLargeArray() {
        System.out.println("Benchmarking ByteLargeArray.");
        long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        ByteLargeArray array = new ByteLargeArray(length);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        byte one = 1;
        for (int it = 0; it < iters; ++it) {
            start = System.nanoTime();
            for (long i2 = 0L; i2 < length; ++i2) {
                array.getByte(i2);
                array.setByte(i2, one);
                array.setByte(i2, (byte)(array.getByte(i2) + one));
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + "sec");
        }
    }

    public static void benchmarkByteLargeArrayInANewThread() {
        System.out.println("Benchmarking ByteLargeArray in a new thread.");
        final long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        final ByteLargeArray array = new ByteLargeArray(length);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        boolean one = true;
        for (int it = 0; it < 5; ++it) {
            start = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long k2 = 0L; k2 < length; ++k2) {
                        array.setByte(k2, (byte)1);
                        array.setByte(k2, (byte)(array.getByte(k2) + 1));
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkFloatLargeArray() {
        System.out.println("Benchmarking FloatLargeArray.");
        long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        FloatLargeArray array = new FloatLargeArray(length);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        for (int it = 0; it < iters; ++it) {
            start = System.nanoTime();
            for (long i2 = 0L; i2 < length; ++i2) {
                array.getFloat(i2);
                array.setFloat(i2, 1.0f);
                array.setFloat(i2, array.getFloat(i2) + 1.0f);
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + "sec");
        }
    }

    public static void benchmarkFloatLargeArrayInANewThread() {
        System.out.println("Benchmarking FloatLargeArray in a new thread.");
        final long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        final FloatLargeArray array = new FloatLargeArray(length);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        for (int it = 0; it < 5; ++it) {
            start = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long k2 = 0L; k2 < length; ++k2) {
                        array.setFloat(k2, 1.0f);
                        array.setFloat(k2, array.getFloat(k2) + 1.0f);
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkByteLargeArrayNative() {
        System.out.println("Benchmarking ByteLargeArray native.");
        long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        ByteLargeArray array = new ByteLargeArray(length, false);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        byte one = 1;
        if (array.isLarge()) {
            for (int it = 0; it < iters; ++it) {
                start = System.nanoTime();
                for (long i2 = 0L; i2 < length; ++i2) {
                    array.getFromNative(i2);
                    array.setToNative(i2, one);
                    array.setToNative(i2, (byte)(array.getFromNative(i2) + one));
                }
                System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
            }
        }
    }

    public static void benchmarkByteLargeArrayNativeInANewThread() {
        System.out.println("Benchmarking ByteLargeArray native in a new thread.");
        final long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        final ByteLargeArray array = new ByteLargeArray(length);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        boolean one = true;
        for (int it = 0; it < 5; ++it) {
            start = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long k2 = 0L; k2 < length; ++k2) {
                        array.setToNative(k2, (byte)1);
                        array.setToNative(k2, (byte)(array.getFromNative(k2) + 1));
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkFloatLargeArrayNative() {
        System.out.println("Benchmarking FloatLargeArray native.");
        long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        FloatLargeArray array = new FloatLargeArray(length, false);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        if (array.isLarge()) {
            for (int it = 0; it < iters; ++it) {
                start = System.nanoTime();
                for (long i2 = 0L; i2 < length; ++i2) {
                    array.getFromNative(i2);
                    array.setToNative(i2, Float.valueOf(1.0f));
                    array.setToNative(i2, Float.valueOf(array.getFromNative(i2).floatValue() + 1.0f));
                }
                System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
            }
        }
    }

    public static void benchmarkFloatLargeArrayNativeInANewThread() {
        System.out.println("Benchmarking FloatLargeArray native in a new thread.");
        final long length = (long)Math.pow(2.0, 32.0);
        long start = System.nanoTime();
        final FloatLargeArray array = new FloatLargeArray(length);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        int iters = 5;
        for (int it = 0; it < 5; ++it) {
            start = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long k2 = 0L; k2 < length; ++k2) {
                        array.setToNative(k2, Float.valueOf(1.0f));
                        array.setToNative(k2, Float.valueOf(array.getFromNative(k2).floatValue() + 1.0f));
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkArithmeticAdd() {
        int it;
        long start;
        LargeArray c2;
        int t;
        System.out.println("Benchmarking addition of two ByteLargeArrays.");
        LargeArray.setMaxSizeOf32bitArray(1);
        long length = (long)Math.pow(2.0, 27.0);
        LargeArray a2 = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, length);
        LargeArray b2 = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, length);
        LargeArray al = LargeArrayUtils.convert(a2, LargeArrayType.LONG);
        LargeArray bl = LargeArrayUtils.convert(b2, LargeArrayType.LONG);
        int iters = 5;
        for (t = 1; t <= 16; t += 2) {
            ConcurrencyUtils.setNumberOfThreads(t);
            c2 = LargeArrayArithmetics.add(a2, b2);
            c2 = LargeArrayArithmetics.add(a2, b2);
            start = System.nanoTime();
            for (it = 0; it < 5; ++it) {
                c2 = LargeArrayArithmetics.add(a2, b2);
            }
            System.out.println("Average computation time using " + t + " threads: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
        System.out.println("Benchmarking addition of two LongLargeArrays.");
        for (t = 1; t <= 16; t += 2) {
            ConcurrencyUtils.setNumberOfThreads(t);
            c2 = LargeArrayArithmetics.add(al, bl);
            c2 = LargeArrayArithmetics.add(al, bl);
            start = System.nanoTime();
            for (it = 0; it < 5; ++it) {
                c2 = LargeArrayArithmetics.add(al, bl);
            }
            System.out.println("Average computation time using " + t + " threads: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkStatisticsAvg() {
        int it;
        long start;
        int t;
        System.out.println("Benchmarking avgKahan (DoubleLargeArray of length = 2^28).");
        LargeArray.setMaxSizeOf32bitArray(1);
        long length = (long)Math.pow(2.0, 28.0);
        LargeArray a2 = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, length);
        int iters = 5;
        for (t = 1; t <= 16; ++t) {
            ConcurrencyUtils.setNumberOfThreads(t);
            double avg1 = LargeArrayStatistics.avgKahan(a2);
            avg1 = LargeArrayStatistics.avgKahan(a2);
            start = System.nanoTime();
            for (it = 0; it < 5; ++it) {
                avg1 = LargeArrayStatistics.avgKahan(a2);
            }
            System.out.println("Average computation time using " + t + " threads: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
        System.out.println("Benchmarking avg (DoubleLargeArray of length = 2^28).");
        LargeArray.setMaxSizeOf32bitArray(1);
        for (t = 1; t <= 16; ++t) {
            ConcurrencyUtils.setNumberOfThreads(t);
            double avg2 = LargeArrayStatistics.avg(a2);
            avg2 = LargeArrayStatistics.avg(a2);
            start = System.nanoTime();
            for (it = 0; it < 5; ++it) {
                avg2 = LargeArrayStatistics.avg(a2);
            }
            System.out.println("Average computation time using " + t + " threads: " + (double)(System.nanoTime() - start) / 1.0E9 + " sec");
        }
    }

    public static void main(String[] args) {
        int smallSizesIters = 10;
        int initial_power_of_two_exp = 27;
        int final_power_of_two_exp = 32;
        int length = final_power_of_two_exp - initial_power_of_two_exp + 1;
        long[] smallSizes = new long[length];
        for (int i2 = 0; i2 < length; ++i2) {
            smallSizes[i2] = initial_power_of_two_exp + i2 == 31 ? (long)Math.pow(2.0, 31.0) - 4L : (long)Math.pow(2.0, initial_power_of_two_exp + i2);
        }
        int largeSizesIters = 2;
        initial_power_of_two_exp = 32;
        final_power_of_two_exp = 35;
        length = final_power_of_two_exp - initial_power_of_two_exp + 1;
        long[] largeSizes = new long[length];
        for (int i3 = 0; i3 < length; ++i3) {
            largeSizes[i3] = (long)Math.pow(2.0, initial_power_of_two_exp + i3);
        }
        int[] threads = new int[]{1, 2, 4, 8, 16};
        LargeArray.setMaxSizeOf32bitArray(1);
        Benchmark.benchmarkByteSequential(smallSizes, threads, 10, "/tmp/");
        Benchmark.benchmarkDoubleSequential(smallSizes, threads, 10, "/tmp/");
        Benchmark.benchmarkByteRandom(smallSizes, threads, 10, "/tmp/");
        Benchmark.benchmarkDoubleRandom(smallSizes, threads, 10, "/tmp/");
        System.exit(0);
    }
}

