/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.IntLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LogicLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.ObjectLargeArray;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.StringLargeArray;
import pl.edu.icm.jlargearrays.UnsignedByteLargeArray;
import sun.misc.Unsafe;

public class LargeArrayUtils {
    public static final Unsafe UNSAFE;

    private LargeArrayUtils() {
    }

    public static void arraycopy(LargeArray src, long srcPos, LargeArray dest, long destPos, long length) {
        if (src.getType() != dest.getType()) {
            throw new IllegalArgumentException("The type of source array is different than the type of destimation array.");
        }
        switch (src.getType()) {
            case LOGIC: {
                LargeArrayUtils.arraycopy((LogicLargeArray)src, srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                LargeArrayUtils.arraycopy((UnsignedByteLargeArray)src, srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                LargeArrayUtils.arraycopy((ShortLargeArray)src, srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                LargeArrayUtils.arraycopy((IntLargeArray)src, srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                LargeArrayUtils.arraycopy((LongLargeArray)src, srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                LargeArrayUtils.arraycopy((FloatLargeArray)src, srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                LargeArrayUtils.arraycopy((DoubleLargeArray)src, srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                LargeArrayUtils.arraycopy((ComplexFloatLargeArray)src, srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                LargeArrayUtils.arraycopy((ComplexDoubleLargeArray)src, srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                LargeArrayUtils.arraycopy((StringLargeArray)src, srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                LargeArrayUtils.arraycopy((ObjectLargeArray)src, srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(Object src, long srcPos, LargeArray dest, long destPos, long length) {
        switch (dest.getType()) {
            case LOGIC: {
                LargeArrayUtils.arraycopy((boolean[])src, (int)srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                LargeArrayUtils.arraycopy((byte[])src, (int)srcPos, (ByteLargeArray)dest, destPos, length);
                break;
            }
            case UNSIGNED_BYTE: {
                Class<?> dataClass = src.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((byte[])src, (int)srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                    break;
                }
                LargeArrayUtils.arraycopy((short[])src, (int)srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                LargeArrayUtils.arraycopy((short[])src, (int)srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                LargeArrayUtils.arraycopy((int[])src, (int)srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                LargeArrayUtils.arraycopy((long[])src, (int)srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                LargeArrayUtils.arraycopy((float[])src, (int)srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                LargeArrayUtils.arraycopy((double[])src, (int)srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                LargeArrayUtils.arraycopy((float[])src, (int)srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                LargeArrayUtils.arraycopy((double[])src, (int)srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                LargeArrayUtils.arraycopy((String[])src, (int)srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                LargeArrayUtils.arraycopy((Object[])src, (int)srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(final LogicLargeArray src, final long srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setByte(j2, src.getByte(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setByte(destPos + k2, src.getByte(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setByte(j3, src.getByte(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setByte(j3, src.getByte(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final boolean[] src, final int srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setBoolean(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setBoolean(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setBoolean(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setBoolean(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final ByteLargeArray src, final long srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setByte(j2, src.getByte(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setByte(destPos + k2, src.getByte(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setByte(j3, src.getByte(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setByte(j3, src.getByte(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final byte[] src, final int srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setByte(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setByte(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setByte(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setByte(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final UnsignedByteLargeArray src, final long srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setByte(j2, src.getByte(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setByte(destPos + k2, src.getByte(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setByte(j3, src.getByte(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setByte(j3, src.getByte(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final byte[] src, final int srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setByte(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setByte(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setByte(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setByte(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final short[] src, final int srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setUnsignedByte(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setUnsignedByte(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setUnsignedByte(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setUnsignedByte(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final ShortLargeArray src, final long srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setShort(j2, src.getShort(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setShort(destPos + k2, src.getShort(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setShort(j3, src.getShort(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setShort(j3, src.getShort(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final short[] src, final int srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setShort(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setShort(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setShort(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setShort(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final IntLargeArray src, final long srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setInt(j2, src.getInt(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setInt(destPos + k2, src.getInt(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setInt(j3, src.getInt(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setInt(j3, src.getInt(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final int[] src, final int srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setInt(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setInt(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setInt(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setInt(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final LongLargeArray src, final long srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setLong(j2, src.getLong(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setLong(destPos + k2, src.getLong(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setLong(j3, src.getLong(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setLong(j3, src.getLong(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final long[] src, final int srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setLong(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setLong(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setLong(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setLong(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final FloatLargeArray src, final long srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setFloat(j2, src.getFloat(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setFloat(destPos + k2, src.getFloat(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setFloat(j3, src.getFloat(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setFloat(j3, src.getFloat(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final float[] src, final int srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setFloat(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setFloat(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setFloat(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setFloat(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final DoubleLargeArray src, final long srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setDouble(j2, src.getDouble(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setDouble(destPos + k2, src.getDouble(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setDouble(j3, src.getDouble(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setDouble(j3, src.getDouble(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final double[] src, final int srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.setDouble(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setDouble(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setDouble(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.setDouble(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final ComplexFloatLargeArray src, final long srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setComplexFloat(j2, src.getComplexFloat(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setComplexFloat(destPos + k2, src.getComplexFloat(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setComplexFloat(j3, src.getComplexFloat(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setComplexFloat(j3, src.getComplexFloat(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final float[] src, final int srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (src.length % 2 != 0) {
            throw new IllegalArgumentException("The length of the source array must be even.");
        }
        if (srcPos < 0 || srcPos >= src.length / 2) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length / 2");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            float[] elem = new float[2];
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                elem[0] = src[2 * i2];
                elem[1] = src[2 * i2 + 1];
                dest.setComplexFloat(j2, elem);
                ++i2;
            }
        } else {
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j3 = 0; j3 < nthreads; ++j3) {
                final long firstIdx = (long)j3 * k2;
                final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k2;
                threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            elem[0] = src[2 * (srcPos + (int)k2)];
                            elem[1] = src[2 * (srcPos + (int)k2) + 1];
                            dest.setComplexFloat(destPos + k2, elem);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                float[] elem = new float[2];
                for (long j4 = destPos; j4 < destPos + length; ++j4) {
                    elem[0] = src[2 * i2];
                    elem[1] = src[2 * i2 + 1];
                    dest.setComplexFloat(j4, elem);
                    ++i2;
                }
            }
            catch (ExecutionException ex) {
                float[] elem = new float[2];
                for (long j5 = destPos; j5 < destPos + length; ++j5) {
                    elem[0] = src[2 * i2];
                    elem[1] = src[2 * i2 + 1];
                    dest.setComplexFloat(j5, elem);
                    ++i2;
                }
            }
        }
    }

    public static void arraycopy(final ComplexDoubleLargeArray src, final long srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.setComplexDouble(j2, src.getComplexDouble(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.setComplexDouble(destPos + k2, src.getComplexDouble(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setComplexDouble(j3, src.getComplexDouble(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.setComplexDouble(j3, src.getComplexDouble(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final double[] src, final int srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (src.length % 2 != 0) {
            throw new IllegalArgumentException("The length of the source array must be even.");
        }
        if (srcPos < 0 || srcPos >= src.length / 2) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length / 2");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            double[] elem = new double[2];
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                elem[0] = src[2 * i2];
                elem[1] = src[2 * i2 + 1];
                dest.setComplexDouble(j2, elem);
                ++i2;
            }
        } else {
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j3 = 0; j3 < nthreads; ++j3) {
                final long firstIdx = (long)j3 * k2;
                final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k2;
                threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            elem[0] = src[2 * (srcPos + (int)k2)];
                            elem[1] = src[2 * (srcPos + (int)k2) + 1];
                            dest.setComplexDouble(destPos + k2, elem);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                double[] elem = new double[2];
                for (long j4 = destPos; j4 < destPos + length; ++j4) {
                    elem[0] = src[2 * i2];
                    elem[1] = src[2 * i2 + 1];
                    dest.setComplexDouble(j4, elem);
                    ++i2;
                }
            }
            catch (ExecutionException ex) {
                double[] elem = new double[2];
                for (long j5 = destPos; j5 < destPos + length; ++j5) {
                    elem[0] = src[2 * i2];
                    elem[1] = src[2 * i2 + 1];
                    dest.setComplexDouble(j5, elem);
                    ++i2;
                }
            }
        }
    }

    public static void arraycopy(final StringLargeArray src, final long srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.set(j2, src.get(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.set(destPos + k2, src.get(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.set(j3, src.get(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.set(j3, src.get(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final String[] src, final int srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.set(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.set(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.set(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.set(j3, src[i2++]);
                }
            }
        }
    }

    public static void arraycopy(final ObjectLargeArray src, final long srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i2 = srcPos;
            long j2 = destPos;
            while (i2 < srcPos + length) {
                dest.set(j2, src.get(i2));
                ++i2;
                ++j2;
            }
        } else {
            long j3;
            long i3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.set(destPos + k2, src.get(srcPos + k2));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.set(j3, src.get(i3));
                    ++i3;
                    ++j3;
                }
            }
            catch (ExecutionException ex) {
                i3 = srcPos;
                j3 = destPos;
                while (i3 < srcPos + length) {
                    dest.set(j3, src.get(i3));
                    ++i3;
                    ++j3;
                }
            }
        }
    }

    public static void arraycopy(final Object[] src, final int srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i2 = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j2 = destPos; j2 < destPos + length; ++j2) {
                dest.set(j2, src[i2++]);
            }
        } else {
            long j3;
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j4 = 0; j4 < nthreads; ++j4) {
                final long firstIdx = (long)j4 * k2;
                final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k2;
                threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            dest.set(destPos + k2, src[srcPos + (int)k2]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.set(j3, src[i2++]);
                }
            }
            catch (ExecutionException ex) {
                for (j3 = destPos; j3 < destPos + length; ++j3) {
                    dest.set(j3, src[i2++]);
                }
            }
        }
    }

    public static LargeArray createConstant(LargeArrayType type2, long length, Object value) {
        switch (type2) {
            case LOGIC: {
                byte v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (byte)1 : 0;
                } else if (value instanceof Byte) {
                    v = (Byte)value;
                } else if (value instanceof Short) {
                    v = ((Short)value).byteValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).byteValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).byteValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).byteValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).byteValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new LogicLargeArray(length, v);
            }
            case BYTE: {
                byte v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (byte)1 : 0;
                } else if (value instanceof Byte) {
                    v = (Byte)value;
                } else if (value instanceof Short) {
                    v = ((Short)value).byteValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).byteValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).byteValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).byteValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).byteValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new ByteLargeArray(length, v);
            }
            case UNSIGNED_BYTE: {
                short v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (short)1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).shortValue();
                } else if (value instanceof Short) {
                    v = (Short)value;
                } else if (value instanceof Integer) {
                    v = ((Integer)value).shortValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).shortValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).shortValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).shortValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new UnsignedByteLargeArray(length, v);
            }
            case SHORT: {
                short v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (short)1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).shortValue();
                } else if (value instanceof Short) {
                    v = (Short)value;
                } else if (value instanceof Integer) {
                    v = ((Integer)value).shortValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).shortValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).shortValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).shortValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new ShortLargeArray(length, v);
            }
            case INT: {
                int v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).intValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).intValue();
                } else if (value instanceof Integer) {
                    v = (Integer)value;
                } else if (value instanceof Long) {
                    v = ((Long)value).intValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).intValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).intValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new IntLargeArray(length, v);
            }
            case LONG: {
                long v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1L : 0L;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).longValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).longValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).longValue();
                } else if (value instanceof Long) {
                    v = (Long)value;
                } else if (value instanceof Float) {
                    v = ((Float)value).longValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).longValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new LongLargeArray(length, v);
            }
            case FLOAT: {
                float v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1.0f : 0.0f;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).floatValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).floatValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).floatValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).floatValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).floatValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).floatValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new FloatLargeArray(length, v);
            }
            case DOUBLE: {
                double v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1.0 : 0.0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).doubleValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).doubleValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).doubleValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).doubleValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).doubleValue();
                } else if (value instanceof Double) {
                    v = (Double)value;
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new DoubleLargeArray(length, v);
            }
            case COMPLEX_FLOAT: {
                Class<?> dataClass = value.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass != Float.TYPE) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                float[] v = (float[])value;
                return new ComplexFloatLargeArray(length, v);
            }
            case COMPLEX_DOUBLE: {
                Class<?> dataClass = value.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass != Double.TYPE) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                double[] v = (double[])value;
                return new ComplexDoubleLargeArray(length, v);
            }
            case STRING: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                String v = (String)value;
                return new StringLargeArray(length, v);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, value);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray create(LargeArrayType type2, long length) {
        return LargeArrayUtils.create(type2, length, true);
    }

    public static LargeArray create(LargeArrayType type2, long length, boolean zeroNativeMemory) {
        switch (type2) {
            case LOGIC: {
                return new LogicLargeArray(length, zeroNativeMemory);
            }
            case BYTE: {
                return new ByteLargeArray(length, zeroNativeMemory);
            }
            case UNSIGNED_BYTE: {
                return new UnsignedByteLargeArray(length, zeroNativeMemory);
            }
            case SHORT: {
                return new ShortLargeArray(length, zeroNativeMemory);
            }
            case INT: {
                return new IntLargeArray(length, zeroNativeMemory);
            }
            case LONG: {
                return new LongLargeArray(length, zeroNativeMemory);
            }
            case FLOAT: {
                return new FloatLargeArray(length, zeroNativeMemory);
            }
            case DOUBLE: {
                return new DoubleLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_FLOAT: {
                return new ComplexFloatLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_DOUBLE: {
                return new ComplexDoubleLargeArray(length, zeroNativeMemory);
            }
            case STRING: {
                return new StringLargeArray(length, 100, zeroNativeMemory);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, 100, zeroNativeMemory);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray generateRandom(LargeArrayType type2, long length) {
        LargeArray res = LargeArrayUtils.create(type2, length, false);
        Random rand = new Random();
        switch (type2) {
            case LOGIC: {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setBoolean(i2, rand.nextBoolean());
                }
                break;
            }
            case BYTE: 
            case UNSIGNED_BYTE: {
                int r;
                long i3;
                for (i3 = 0L; i3 < length / 4L; i3 += 4L) {
                    r = rand.nextInt();
                    res.setByte(i3, (byte)(r >>= 8));
                    res.setByte(i3 + 1L, (byte)(r >>= 8));
                    res.setByte(i3 + 2L, (byte)(r >>= 8));
                    res.setByte(i3 + 3L, (byte)(r >>= 8));
                }
                r = rand.nextInt();
                while (i3 < length) {
                    res.setByte(i3, (byte)(r >>= 8));
                    ++i3;
                }
                break;
            }
            case SHORT: {
                int r;
                long i4;
                for (i4 = 0L; i4 < length / 2L; i4 += 2L) {
                    r = rand.nextInt();
                    res.setShort(i4, (short)(r >>= 16));
                    res.setShort(i4 + 1L, (short)(r >>= 16));
                }
                r = rand.nextInt();
                while (i4 < length) {
                    res.setShort(i4, (short)(r >>= 16));
                    ++i4;
                }
                break;
            }
            case INT: {
                for (long i5 = 0L; i5 < length; ++i5) {
                    res.setInt(i5, rand.nextInt());
                }
                break;
            }
            case LONG: {
                for (long i6 = 0L; i6 < length; ++i6) {
                    res.setLong(i6, rand.nextLong());
                }
                break;
            }
            case FLOAT: {
                for (long i7 = 0L; i7 < length; ++i7) {
                    res.setFloat(i7, rand.nextFloat());
                }
                break;
            }
            case DOUBLE: {
                for (long i8 = 0L; i8 < length; ++i8) {
                    res.setDouble(i8, rand.nextDouble());
                }
                break;
            }
            case COMPLEX_FLOAT: {
                ComplexFloatLargeArray res_c = (ComplexFloatLargeArray)res;
                float[] elem_res = new float[2];
                for (long i9 = 0L; i9 < length; ++i9) {
                    elem_res[0] = rand.nextFloat();
                    elem_res[1] = rand.nextFloat();
                    res_c.setComplexFloat(i9, elem_res);
                }
                break;
            }
            case COMPLEX_DOUBLE: {
                ComplexDoubleLargeArray res_c = (ComplexDoubleLargeArray)res;
                double[] elem_res = new double[2];
                for (long i10 = 0L; i10 < length; ++i10) {
                    elem_res[0] = rand.nextDouble();
                    elem_res[1] = rand.nextDouble();
                    res_c.setComplexDouble(i10, elem_res);
                }
                break;
            }
            case STRING: {
                for (long i11 = 0L; i11 < length; ++i11) {
                    res.setFloat(i11, rand.nextFloat());
                }
                break;
            }
            case OBJECT: {
                for (long i12 = 0L; i12 < length; ++i12) {
                    res.set(i12, Float.valueOf(rand.nextFloat()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
        return res;
    }

    public static LargeArray convert(final LargeArray src, final LargeArrayType type2) {
        LargeArray out;
        block111: {
            long i2;
            int nthreads;
            long length;
            block110: {
                if (src.getType() == type2) {
                    return src;
                }
                if (src.isConstant()) {
                    switch (type2) {
                        case LOGIC: {
                            return new LogicLargeArray(src.length(), src.getByte(0L));
                        }
                        case BYTE: {
                            return new ByteLargeArray(src.length(), src.getByte(0L));
                        }
                        case UNSIGNED_BYTE: {
                            return new UnsignedByteLargeArray(src.length(), src.getUnsignedByte(0L));
                        }
                        case SHORT: {
                            return new ShortLargeArray(src.length(), src.getShort(0L));
                        }
                        case INT: {
                            return new IntLargeArray(src.length(), src.getInt(0L));
                        }
                        case LONG: {
                            return new LongLargeArray(src.length(), src.getLong(0L));
                        }
                        case FLOAT: {
                            return new FloatLargeArray(src.length(), src.getFloat(0L));
                        }
                        case DOUBLE: {
                            return new DoubleLargeArray(src.length(), src.getDouble(0L));
                        }
                        case COMPLEX_FLOAT: {
                            return new ComplexFloatLargeArray(src.length(), ((ComplexFloatLargeArray)src).getComplexFloat(0L));
                        }
                        case COMPLEX_DOUBLE: {
                            return new ComplexDoubleLargeArray(src.length(), ((ComplexDoubleLargeArray)src).getComplexDouble(0L));
                        }
                        case STRING: {
                            return new StringLargeArray(src.length(), src.get(0L).toString());
                        }
                        case OBJECT: {
                            return new ObjectLargeArray(src.length(), src.get(0L));
                        }
                    }
                    throw new IllegalArgumentException("Invalid array type.");
                }
                length = src.length;
                out = LargeArrayUtils.create(type2, length, false);
                nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
                if (nthreads >= 2 && length >= ConcurrencyUtils.getConcurrentThreshold()) break block110;
                switch (type2) {
                    case LOGIC: 
                    case BYTE: {
                        for (long i3 = 0L; i3 < length; ++i3) {
                            out.setByte(i3, src.getByte(i3));
                        }
                        break block111;
                    }
                    case UNSIGNED_BYTE: {
                        for (long i4 = 0L; i4 < length; ++i4) {
                            out.setUnsignedByte(i4, src.getUnsignedByte(i4));
                        }
                        break block111;
                    }
                    case SHORT: {
                        for (long i5 = 0L; i5 < length; ++i5) {
                            out.setShort(i5, src.getShort(i5));
                        }
                        break block111;
                    }
                    case INT: {
                        for (long i6 = 0L; i6 < length; ++i6) {
                            out.setInt(i6, src.getInt(i6));
                        }
                        break block111;
                    }
                    case LONG: {
                        for (long i7 = 0L; i7 < length; ++i7) {
                            out.setLong(i7, src.getLong(i7));
                        }
                        break block111;
                    }
                    case FLOAT: {
                        for (long i8 = 0L; i8 < length; ++i8) {
                            out.setFloat(i8, src.getFloat(i8));
                        }
                        break block111;
                    }
                    case DOUBLE: {
                        for (long i9 = 0L; i9 < length; ++i9) {
                            out.setDouble(i9, src.getDouble(i9));
                        }
                        break block111;
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (long i10 = 0L; i10 < length; ++i10) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i10, ((ComplexDoubleLargeArray)src).getComplexDouble(i10));
                            }
                        } else {
                            for (long i11 = 0L; i11 < length; ++i11) {
                                out.setFloat(i11, src.getFloat(i11));
                            }
                        }
                        break block111;
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (long i12 = 0L; i12 < length; ++i12) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i12, ((ComplexFloatLargeArray)src).getComplexFloat(i12));
                            }
                        } else {
                            for (long i13 = 0L; i13 < length; ++i13) {
                                out.setDouble(i13, src.getDouble(i13));
                            }
                        }
                        break block111;
                    }
                    case STRING: {
                        for (long i14 = 0L; i14 < length; ++i14) {
                            out.set(i14, src.get(i14).toString());
                        }
                        break block111;
                    }
                    case OBJECT: {
                        for (long i15 = 0L; i15 < length; ++i15) {
                            out.set(i15, src.get(i15));
                        }
                        break block111;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        switch (type2) {
                            case BYTE: {
                                for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                    out.setByte(i2, src.getByte(i2));
                                }
                                break;
                            }
                            case UNSIGNED_BYTE: {
                                for (long i3 = firstIdx; i3 < lastIdx; ++i3) {
                                    out.setUnsignedByte(i3, src.getUnsignedByte(i3));
                                }
                                break;
                            }
                            case SHORT: {
                                for (long i4 = firstIdx; i4 < lastIdx; ++i4) {
                                    out.setShort(i4, src.getShort(i4));
                                }
                                break;
                            }
                            case INT: {
                                for (long i5 = firstIdx; i5 < lastIdx; ++i5) {
                                    out.setInt(i5, src.getInt(i5));
                                }
                                break;
                            }
                            case LONG: {
                                for (long i6 = firstIdx; i6 < lastIdx; ++i6) {
                                    out.setLong(i6, src.getLong(i6));
                                }
                                break;
                            }
                            case FLOAT: {
                                for (long i7 = firstIdx; i7 < lastIdx; ++i7) {
                                    out.setFloat(i7, src.getFloat(i7));
                                }
                                break;
                            }
                            case DOUBLE: {
                                for (long i8 = firstIdx; i8 < lastIdx; ++i8) {
                                    out.setDouble(i8, src.getDouble(i8));
                                }
                                break;
                            }
                            case COMPLEX_FLOAT: {
                                if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                                    for (long i9 = firstIdx; i9 < lastIdx; ++i9) {
                                        ((ComplexFloatLargeArray)out).setComplexDouble(i9, ((ComplexDoubleLargeArray)src).getComplexDouble(i9));
                                    }
                                } else {
                                    for (long i10 = firstIdx; i10 < lastIdx; ++i10) {
                                        out.setFloat(i10, src.getFloat(i10));
                                    }
                                }
                                break;
                            }
                            case COMPLEX_DOUBLE: {
                                if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                                    for (long i11 = firstIdx; i11 < lastIdx; ++i11) {
                                        ((ComplexDoubleLargeArray)out).setComplexFloat(i11, ((ComplexFloatLargeArray)src).getComplexFloat(i11));
                                    }
                                } else {
                                    for (long i12 = firstIdx; i12 < lastIdx; ++i12) {
                                        out.setDouble(i12, src.getDouble(i12));
                                    }
                                }
                                break;
                            }
                            case STRING: {
                                for (long i13 = firstIdx; i13 < lastIdx; ++i13) {
                                    out.set(i13, src.get(i13).toString());
                                }
                                break;
                            }
                            case OBJECT: {
                                for (long i14 = firstIdx; i14 < lastIdx; ++i14) {
                                    out.set(i14, src.get(i14));
                                }
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid array type.");
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                switch (type2) {
                    case LOGIC: 
                    case BYTE: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setByte(i2, src.getByte(i2));
                        }
                    }
                    case UNSIGNED_BYTE: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setUnsignedByte(i2, src.getUnsignedByte(i2));
                        }
                    }
                    case SHORT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setShort(i2, src.getShort(i2));
                        }
                    }
                    case INT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setInt(i2, src.getInt(i2));
                        }
                    }
                    case LONG: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setLong(i2, src.getLong(i2));
                        }
                    }
                    case FLOAT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setFloat(i2, src.getFloat(i2));
                        }
                    }
                    case DOUBLE: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setDouble(i2, src.getDouble(i2));
                        }
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (i2 = 0L; i2 < length; ++i2) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i2, ((ComplexDoubleLargeArray)src).getComplexDouble(i2));
                            }
                        } else {
                            for (i2 = 0L; i2 < length; ++i2) {
                                out.setFloat(i2, src.getFloat(i2));
                            }
                        }
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (i2 = 0L; i2 < length; ++i2) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i2, ((ComplexFloatLargeArray)src).getComplexFloat(i2));
                            }
                        } else {
                            for (i2 = 0L; i2 < length; ++i2) {
                                out.setDouble(i2, src.getDouble(i2));
                            }
                        }
                    }
                    case STRING: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.set(i2, src.get(i2).toString());
                        }
                    }
                    case OBJECT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.set(i2, src.get(i2));
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            catch (ExecutionException ex) {
                switch (type2) {
                    case LOGIC: 
                    case BYTE: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setByte(i2, src.getByte(i2));
                        }
                        break;
                    }
                    case UNSIGNED_BYTE: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setUnsignedByte(i2, src.getUnsignedByte(i2));
                        }
                        break;
                    }
                    case SHORT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setShort(i2, src.getShort(i2));
                        }
                        break;
                    }
                    case INT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setInt(i2, src.getInt(i2));
                        }
                        break;
                    }
                    case LONG: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setLong(i2, src.getLong(i2));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setFloat(i2, src.getFloat(i2));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.setDouble(i2, src.getDouble(i2));
                        }
                        break;
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (i2 = 0L; i2 < length; ++i2) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i2, ((ComplexDoubleLargeArray)src).getComplexDouble(i2));
                            }
                        } else {
                            for (i2 = 0L; i2 < length; ++i2) {
                                out.setFloat(i2, src.getFloat(i2));
                            }
                        }
                        break;
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (i2 = 0L; i2 < length; ++i2) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i2, ((ComplexFloatLargeArray)src).getComplexFloat(i2));
                            }
                        } else {
                            for (i2 = 0L; i2 < length; ++i2) {
                                out.setDouble(i2, src.getDouble(i2));
                            }
                        }
                        break;
                    }
                    case STRING: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.set(i2, src.get(i2).toString());
                        }
                        break;
                    }
                    case OBJECT: {
                        for (i2 = 0L; i2 < length; ++i2) {
                            out.set(i2, src.get(i2));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
        }
        return out;
    }

    public static LargeArray select(LargeArray src, final LogicLargeArray mask) {
        long j2;
        int j3;
        if (src.length != mask.length) {
            throw new IllegalArgumentException("src.length != mask.length");
        }
        long length = src.length;
        long count = 0L;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        long k2 = length / (long)nthreads;
        ExecutorService pool = Executors.newCachedThreadPool();
        Future[] futures = new Future[nthreads];
        for (j3 = 0; j3 < nthreads; ++j3) {
            final long firstIdx = (long)j3 * k2;
            final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k2;
            futures[j3] = pool.submit(new Callable(){

                public Long call() {
                    long count = 0L;
                    for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                        if (mask.getByte(k2) != 1) continue;
                        ++count;
                    }
                    return count;
                }
            });
        }
        try {
            for (j3 = 0; j3 < nthreads; ++j3) {
                count += ((Long)futures[j3].get()).longValue();
            }
        }
        catch (Exception ex) {
            for (j2 = 0L; j2 < length; ++j2) {
                if (mask.getByte(j2) != 1) continue;
                ++count;
            }
        }
        if (count <= 0L) {
            return null;
        }
        LargeArray res = LargeArrayUtils.create(src.getType(), count, false);
        k2 = 0L;
        for (j2 = 0L; j2 < length; ++j2) {
            if (mask.getByte(j2) != 1) continue;
            res.set(k2++, src.get(j2));
        }
        return res;
    }

    static {
        Object theUnsafe = null;
        Exception exception = null;
        try {
            Class<?> uc = Class.forName("sun.misc.Unsafe");
            Field f2 = uc.getDeclaredField("theUnsafe");
            f2.setAccessible(true);
            theUnsafe = f2.get(uc);
        }
        catch (ClassNotFoundException e2) {
            exception = e2;
        }
        catch (IllegalAccessException e3) {
            exception = e3;
        }
        catch (IllegalArgumentException e4) {
            exception = e4;
        }
        catch (NoSuchFieldException e5) {
            exception = e5;
        }
        catch (SecurityException e6) {
            exception = e6;
        }
        UNSAFE = (Unsafe)theUnsafe;
        if (UNSAFE == null) {
            throw new Error("Could not obtain access to sun.misc.Unsafe", exception);
        }
    }
}

