/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.APU;
import totoro.ocelot.brain.entity.CPU;
import totoro.ocelot.brain.entity.Case;
import totoro.ocelot.brain.entity.ComponentBus;
import totoro.ocelot.brain.entity.GraphicsCard;
import totoro.ocelot.brain.entity.HDDManaged;
import totoro.ocelot.brain.entity.HDDUnmanaged;
import totoro.ocelot.brain.entity.HologramProjector;
import totoro.ocelot.brain.entity.Memory;
import totoro.ocelot.brain.entity.Microcontroller;
import totoro.ocelot.brain.entity.Screen;
import totoro.ocelot.brain.entity.Server;
import totoro.ocelot.brain.entity.machine.MachineAPI$;
import totoro.ocelot.brain.entity.machine.Registry$;
import totoro.ocelot.brain.entity.machine.luac.LuaStateFactory$;
import totoro.ocelot.brain.entity.machine.luac.NativeLua52Architecture;
import totoro.ocelot.brain.entity.machine.luac.NativeLua53Architecture;
import totoro.ocelot.brain.entity.machine.luac.NativeLua54Architecture;
import totoro.ocelot.brain.entity.machine.luaj.LuaJLuaArchitecture;
import totoro.ocelot.brain.loot.Loot$;
import totoro.ocelot.brain.nbt.persistence.NBTPersistence;
import totoro.ocelot.brain.nbt.persistence.NBTPersistence$;
import totoro.ocelot.brain.util.FontUtils$;
import totoro.ocelot.brain.util.SafeThreadPool;
import totoro.ocelot.brain.util.ThreadPoolFactory$;

public final class Ocelot$ {
    public static final Ocelot$ MODULE$ = new Ocelot$();
    private static Option<Logger> logger = None$.MODULE$;
    private static Option<Path> configPath = None$.MODULE$;
    private static Option<Path> librariesPath = None$.MODULE$;
    private static Option<Function1<String, Object>> isPlayerOnlinePredicate = None$.MODULE$;

    public final String Name() {
        return "Ocelot";
    }

    public final String Version() {
        return "0.24.2";
    }

    public final String OpenComputersVersion() {
        return "1.8.9a";
    }

    public Logger log() {
        return (Logger)this.logger().getOrElse((Function0<Logger> & Serializable)() -> LogManager.getLogger("Ocelot"));
    }

    public Option<Logger> logger() {
        return logger;
    }

    public void logger_$eq(Option<Logger> x$1) {
        logger = x$1;
    }

    public Option<Path> configPath() {
        return configPath;
    }

    public void configPath_$eq(Option<Path> x$1) {
        configPath = x$1;
    }

    public Option<Path> librariesPath() {
        return librariesPath;
    }

    public void librariesPath_$eq(Option<Path> x$1) {
        librariesPath = x$1;
    }

    public Option<Function1<String, Object>> isPlayerOnlinePredicate() {
        return isPlayerOnlinePredicate;
    }

    public void isPlayerOnlinePredicate_$eq(Option<Function1<String, Object>> x$1) {
        isPlayerOnlinePredicate = x$1;
    }

    private void preInit() {
        this.log().info("Loading configuration...");
        Settings$.MODULE$.load(this.configPath().map((Function1<Path, File> & Serializable)x$1 -> x$1.toFile()));
    }

    private void init() {
        this.log().info("Loading Lua libraries...");
        LuaStateFactory$.MODULE$.init((Path)this.librariesPath().getOrElse((Function0<Path> & Serializable)() -> Paths.get("./", new String[0])));
        this.log().info("Registering available machine architectures...");
        if (LuaStateFactory$.MODULE$.isAvailable()) {
            if (LuaStateFactory$.MODULE$.include53()) {
                MachineAPI$.MODULE$.add(NativeLua53Architecture.class, "Lua 5.3");
            }
            if (LuaStateFactory$.MODULE$.include54()) {
                MachineAPI$.MODULE$.add(NativeLua54Architecture.class, "Lua 5.4");
            }
            if (LuaStateFactory$.MODULE$.include52()) {
                MachineAPI$.MODULE$.add(NativeLua52Architecture.class, "Lua 5.2");
            }
        }
        if (LuaStateFactory$.MODULE$.includeLuaJ()) {
            MachineAPI$.MODULE$.add(LuaJLuaArchitecture.class, "LuaJ");
        }
        this.log().info("Registering loot (floppies and EEPROMs with standard OpenComputers software)...");
        Loot$.MODULE$.init();
        this.log().info("Registering entity constructors (for persistence purposes)...");
        NBTPersistence.TieredConstructor tieredConstructor = new NBTPersistence.TieredConstructor();
        NBTPersistence$.MODULE$.registerConstructor(Case.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(Server.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(Microcontroller.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(Screen.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(HologramProjector.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(CPU.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(APU.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(GraphicsCard.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(HDDManaged.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(HDDUnmanaged.class.getName(), tieredConstructor);
        NBTPersistence$.MODULE$.registerConstructor(Memory.class.getName(), new NBTPersistence.MemoryConstructor());
        NBTPersistence$.MODULE$.registerConstructor(ComponentBus.class.getName(), tieredConstructor);
        FontUtils$.MODULE$.init();
        ThreadPoolFactory$.MODULE$.safePools().foreach((Function1<SafeThreadPool, Object> & Serializable)x$2 -> {
            x$2.newThreadPool();
            return BoxedUnit.UNIT;
        });
        if (Settings$.MODULE$.get().internetAccessConfigured()) {
            if (Settings$.MODULE$.get().internetFilteringRulesInvalid()) {
                this.log().warn("####################################################");
                this.log().warn("#                                                  #");
                this.log().warn("#  Could not parse Internet Card filtering rules!  #");
                this.log().warn("#  Review the server log and adjust the filtering  #");
                this.log().warn("#  list to ensure it is appropriately configured.  #");
                this.log().warn("#          (brain.conf => filteringRules)          #");
                this.log().warn("# Internet access has been automatically disabled. #");
                this.log().warn("#                                                  #");
                this.log().warn("####################################################");
                return;
            }
            this.log().info(StringOps$.MODULE$.format$extension("Successfully applied %s Internet Card filtering rules.", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(Settings$.MODULE$.get().internetFilteringRules().length)})));
            return;
        }
    }

    private void postInit() {
        Registry$.MODULE$.locked_$eq(true);
    }

    public void initialize(Logger logger) {
        this.logger_$eq(new Some<Logger>(logger));
        this.initialize();
    }

    public void initialize() {
        this.log().info("Brain initialization...");
        this.log().info(new StringBuilder(15).append("Version: ").append("0.24.2").toString());
        this.preInit();
        this.init();
        this.postInit();
        this.log().info("Initialization finished.");
    }

    public void shutdown() {
        this.log().info("Preparing for Ocelot shutdown...");
        ThreadPoolFactory$.MODULE$.safePools().foreach((Function1<SafeThreadPool, Object> & Serializable)x$3 -> {
            x$3.waitForCompletion();
            return BoxedUnit.UNIT;
        });
        this.log().info("Ocelot is shut down.");
    }

    private Ocelot$() {
    }
}

