/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.InputStream;
import scala.Array$;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;
import totoro.ocelot.brain.Ocelot$;
import totoro.ocelot.brain.Settings;
import totoro.ocelot.brain.util.ColorDepth$;

public final class Settings$ {
    public static final Settings$ MODULE$ = new Settings$();
    private static final String resourceDomain = "opencomputers";
    private static final String scriptPath = new StringBuilder(13).append("/assets/").append(MODULE$.resourceDomain()).append("/lua/").toString();
    private static final Tuple2<Object, Object>[] screenResolutionsByTier = (Tuple2[])((Object[])new Tuple2[]{new Tuple2$mcII$sp(50, 16), new Tuple2$mcII$sp(80, 25), new Tuple2$mcII$sp(160, 50)});
    private static final Enumeration.Value[] screenDepthsByTier = (Enumeration.Value[])((Object[])new Enumeration.Value[]{ColorDepth$.MODULE$.OneBit(), ColorDepth$.MODULE$.FourBit(), ColorDepth$.MODULE$.EightBit()});
    private static final int[] deviceComplexityByTier = new int[]{12, 24, 32, 9001};
    private static boolean rTreeDebugRenderer = false;
    private static int blockRenderId = -1;
    private static Settings settings;
    private static final Regex totoro$ocelot$brain$Settings$$cidrPattern;
    private static final int TapeSecondSize;
    private static final int TapeMinuteSize;
    private static final int TapeCount;
    private static final int[] totoro$ocelot$brain$Settings$$DefaultTapeLengths;

    static {
        totoro$ocelot$brain$Settings$$cidrPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})/(\\d{1,2})"));
        TapeSecondSize = 6000;
        TapeMinuteSize = MODULE$.TapeSecondSize() * 60;
        TapeCount = 10;
        totoro$ocelot$brain$Settings$$DefaultTapeLengths = new int[]{4, 8, 16, 32, 64, 2, 6, 16, 128, 128};
    }

    public String resourceDomain() {
        return resourceDomain;
    }

    public String scriptPath() {
        return scriptPath;
    }

    public Tuple2<Object, Object>[] screenResolutionsByTier() {
        return screenResolutionsByTier;
    }

    public Enumeration.Value[] screenDepthsByTier() {
        return screenDepthsByTier;
    }

    public int[] deviceComplexityByTier() {
        return deviceComplexityByTier;
    }

    public boolean rTreeDebugRenderer() {
        return rTreeDebugRenderer;
    }

    public void rTreeDebugRenderer_$eq(boolean x$1) {
        rTreeDebugRenderer = x$1;
    }

    public int blockRenderId() {
        return blockRenderId;
    }

    public void blockRenderId_$eq(int x$1) {
        blockRenderId = x$1;
    }

    public int basicScreenPixels() {
        return this.screenResolutionsByTier()[0]._1$mcI$sp() * this.screenResolutionsByTier()[0]._2$mcI$sp();
    }

    private Settings settings() {
        return settings;
    }

    private void settings_$eq(Settings x$1) {
        settings = x$1;
    }

    public Settings get() {
        return this.settings();
    }

    public void load(Option<File> file) {
        if (file.isDefined() && file.get().exists()) {
            try {
                BufferedSource source = Source$.MODULE$.fromFile(file.get(), Codec$.MODULE$.UTF8());
                String plain = source.getLines().mkString("", System.lineSeparator(), System.lineSeparator());
                Config config = ConfigFactory.parseString(plain);
                this.settings_$eq(new Settings(config.getConfig("opencomputers")));
                source.close();
                Ocelot$.MODULE$.log().info(new StringBuilder(40).append("Loaded Ocelot Brain configuration from: ").append(file.get().getCanonicalPath()).toString());
                return;
            }
            catch (Throwable e2) {
                Ocelot$.MODULE$.log().warn(new StringBuilder(19).append("(Failed to parse ").append(file.get().getCanonicalPath()).append("!)").toString(), e2);
            }
        }
        Ocelot$.MODULE$.log().info("Using default Ocelot Brain configuration.");
        InputStream in = Settings.class.getResourceAsStream("/application.conf");
        String config = Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.UTF8()).getLines().mkString("", System.lineSeparator(), System.lineSeparator());
        in.close();
        Config defaults = ConfigFactory.parseString(config);
        this.settings_$eq(new Settings(defaults.getConfig("opencomputers")));
    }

    public Regex totoro$ocelot$brain$Settings$$cidrPattern() {
        return totoro$ocelot$brain$Settings$$cidrPattern;
    }

    public int TapeSecondSize() {
        return TapeSecondSize;
    }

    public int TapeMinuteSize() {
        return TapeMinuteSize;
    }

    private int TapeCount() {
        return TapeCount;
    }

    public int[] totoro$ocelot$brain$Settings$$DefaultTapeLengths() {
        return totoro$ocelot$brain$Settings$$DefaultTapeLengths;
    }

    public int[] totoro$ocelot$brain$Settings$$loadTapeSizes(String lengthsStr) {
        int[] sizes = (int[])Array$.MODULE$.ofDim(this.TapeCount(), ClassTag$.MODULE$.Int());
        String[] lengths = lengthsStr.split(",");
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(sizes)).foreach$mVc$sp(i2 -> {
            if (i2 < lengths.length) {
                sizes$1[i2] = Settings$.liftedTree2$1(lengths, i2);
                if (sizes[i2] <= 0) {
                    sizes$1[i2] = 4;
                    return;
                }
                return;
            }
            Ocelot$.MODULE$.log().warn(new StringBuilder(77).append("Property 'tapedrive.tapeLengths' contains too few entries, ").append("setting entry ").append(i2 + 1).append(" to ").append(MODULE$.totoro$ocelot$brain$Settings$$DefaultTapeLengths()[i2]).toString());
            sizes$1[i2] = MODULE$.totoro$ocelot$brain$Settings$$DefaultTapeLengths()[i2] * MODULE$.TapeMinuteSize();
        });
        return sizes;
    }

    private static final /* synthetic */ int liftedTree2$1(String[] lengths$1, int i$1) {
        int n2;
        try {
            n2 = Integer.parseInt(lengths$1[i$1]) * MODULE$.TapeMinuteSize();
        }
        catch (NumberFormatException e2) {
            Ocelot$.MODULE$.log().error(new StringBuilder(104).append("Property 'tapedrive.tapeLengths' in brain.cfg contains entry this is not a number! Setting entry ").append(i$1 + 1).append(" [").append(lengths$1[i$1]).append("] to ").append(MODULE$.totoro$ocelot$brain$Settings$$DefaultTapeLengths()[i$1]).toString(), (Throwable)e2);
            n2 = MODULE$.totoro$ocelot$brain$Settings$$DefaultTapeLengths()[i$1] * MODULE$.TapeMinuteSize();
        }
        return n2;
    }

    private Settings$() {
    }
}

