/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity;

import scala.Predef$;
import scala.runtime.RichInt$;
import totoro.ocelot.brain.entity.GpuTextBuffer;
import totoro.ocelot.brain.entity.TextBuffer;
import totoro.ocelot.brain.entity.traits.TextBufferProxy;
import totoro.ocelot.brain.util.GenericTextBuffer;

public final class GpuTextBuffer$ {
    public static final GpuTextBuffer$ MODULE$ = new GpuTextBuffer$();

    public GpuTextBuffer wrap(String owner, int id, GenericTextBuffer data) {
        return new GpuTextBuffer(owner, id, data);
    }

    public void bitblt(TextBufferProxy dst, int col, int row, int w, int h2, TextBufferProxy src, int fromCol, int fromRow) {
        int x = col - 1;
        int y = row - 1;
        int fx = fromCol - 1;
        int fy = fromRow - 1;
        int adjustedDstX = x;
        int adjustedDstY = y;
        int adjustedWidth = w;
        int adjustedHeight = h2;
        int adjustedSourceX = fx;
        int adjustedSourceY = fy;
        if (x < 0) {
            adjustedWidth += x;
            adjustedSourceX -= x;
            adjustedDstX = 0;
        }
        if (y < 0) {
            adjustedHeight += y;
            adjustedSourceY -= y;
            adjustedDstY = 0;
        }
        if (adjustedSourceX < 0) {
            adjustedWidth += adjustedSourceX;
            adjustedDstX -= adjustedSourceX;
            adjustedSourceX = 0;
        }
        if (adjustedSourceY < 0) {
            adjustedHeight += adjustedSourceY;
            adjustedDstY -= adjustedSourceY;
            adjustedSourceY = 0;
        }
        adjustedWidth -= RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(adjustedDstX + adjustedWidth - dst.getWidth()), 0);
        adjustedWidth -= RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(adjustedSourceX + adjustedWidth - src.getWidth()), 0);
        adjustedHeight -= RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(adjustedDstY + adjustedHeight - dst.getHeight()), 0);
        adjustedHeight -= RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(adjustedSourceY + adjustedHeight - src.getHeight()), 0);
        if (adjustedWidth <= 0 || adjustedHeight <= 0) {
            return;
        }
        TextBufferProxy textBufferProxy = dst;
        if (textBufferProxy instanceof TextBuffer) {
            TextBuffer textBuffer = (TextBuffer)textBufferProxy;
            TextBufferProxy textBufferProxy2 = src;
            if (!(textBufferProxy2 instanceof GpuTextBuffer)) {
                throw new UnsupportedOperationException("Source buffer does not support bitblt operations to a screen");
            }
            GpuTextBuffer gpuTextBuffer = (GpuTextBuffer)textBufferProxy2;
            this.write_vram_to_screen(textBuffer, adjustedDstX, adjustedDstY, adjustedWidth, adjustedHeight, gpuTextBuffer, adjustedSourceX, adjustedSourceY);
            return;
        }
        if (textBufferProxy instanceof GpuTextBuffer) {
            GpuTextBuffer gpuTextBuffer = (GpuTextBuffer)textBufferProxy;
            TextBufferProxy textBufferProxy3 = src;
            if (textBufferProxy3 == null) {
                throw new UnsupportedOperationException("Source buffer does not support bitblt operations");
            }
            TextBufferProxy textBufferProxy4 = textBufferProxy3;
            this.write_to_vram(gpuTextBuffer, adjustedDstX, adjustedDstY, adjustedWidth, adjustedHeight, textBufferProxy4, adjustedSourceX, adjustedSourceY);
            return;
        }
        throw new UnsupportedOperationException("Destination buffer does not support bitblt operations");
    }

    public boolean write_vram_to_screen(TextBuffer dstScreen, int x, int y, int w, int h2, GpuTextBuffer srcRam, int fx, int fy) {
        if (dstScreen.data().rawcopy(x + 1, y + 1, w, h2, srcRam.data(), fx + 1, fy + 1)) {
            dstScreen.addBuffer(srcRam);
            dstScreen.onBufferBitBlt(x + 1, y + 1, w, h2, srcRam, fx + 1, fy + 1);
            return true;
        }
        return false;
    }

    public boolean write_to_vram(GpuTextBuffer dstRam, int x, int y, int w, int h2, TextBufferProxy src, int fx, int fy) {
        if (dstRam.data().rawcopy(x + 1, y + 1, w, h2, src.data(), fx + 1, fy + 1)) {
            dstRam.dirty_$eq(true);
            return true;
        }
        return false;
    }

    private GpuTextBuffer$() {
    }
}

