/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.fs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;
import totoro.ocelot.brain.Ocelot$;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.fs.Capacity;
import totoro.ocelot.brain.entity.fs.FileSystem;
import totoro.ocelot.brain.entity.fs.FileSystemAPI;
import totoro.ocelot.brain.entity.fs.FileSystemTrait;
import totoro.ocelot.brain.entity.fs.Label;
import totoro.ocelot.brain.entity.fs.ReadOnlyWrapper;
import totoro.ocelot.brain.entity.fs.ZipFileInputStreamFileSystem$;

public final class FileSystemAPI$ {
    public static final FileSystemAPI$ MODULE$ = new FileSystemAPI$();
    private static final Set<Object> invalidChars = Predef$.MODULE$.wrapString("\\:*?\"<>|").toSet();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCaseInsensitive(File path) {
        boolean bl;
        if (Settings$.MODULE$.get().forceCaseInsensitive()) return true;
        try {
            String uuid = UUID.randomUUID().toString();
            File lowerCase = new File(path, new StringBuilder(6).append(uuid).append("oc_rox").toString());
            File upperCase = new File(path, new StringBuilder(6).append(uuid).append("OC_ROX").toString());
            boolean bl2 = lowerCase.exists() && lowerCase.delete();
            boolean bl3 = upperCase.exists() && upperCase.delete();
            lowerCase.createNewFile();
            boolean insensitive = upperCase.exists();
            lowerCase.delete();
            bl = insensitive;
        }
        catch (Throwable t) {
            Ocelot$.MODULE$.log().warn("Couldn't determine if file system is case sensitive, falling back to insensitive.", t);
            return true;
        }
        if (!bl) return false;
        return true;
    }

    private Set<Object> invalidChars() {
        return invalidChars;
    }

    public boolean isValidFilename(String name) {
        return !StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(name), (Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(FileSystemAPI$.$anonfun$isValidFilename$1(BoxesRunTime.unboxToChar(elem))));
    }

    public String validatePath(String path) {
        if (!this.isValidFilename(path)) {
            throw new IOException("path contains invalid characters");
        }
        return path;
    }

    public FileSystemTrait fromClass(Class<?> clazz, String domain, String root) {
        Tuple2<String, Boolean> tuple2;
        String innerPath = new StringBuilder(10).append("/assets/").append(domain).append("/").append(root.trim()).append("/").toString().replace("//", "/");
        String codeSource = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        Tuple2<String, Boolean> tuple22 = codeSource.contains(".zip!") || codeSource.contains(".jar!") ? new Tuple2<String, Boolean>(codeSource.substring(0, codeSource.lastIndexOf(33)), BoxesRunTime.boxToBoolean(true)) : (tuple2 = codeSource.contains(".zip") || codeSource.contains(".jar") ? new Tuple2<String, Boolean>(codeSource, BoxesRunTime.boxToBoolean(true)) : new Tuple2<String, Boolean>(codeSource, BoxesRunTime.boxToBoolean(false)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String codeUrl = (String)tuple2._1();
        boolean isArchive = tuple2._2$mcZ$sp();
        Tuple2<String, Boolean> tuple23 = new Tuple2<String, Boolean>(codeUrl, BoxesRunTime.boxToBoolean(isArchive));
        String codeUrl2 = tuple23._1();
        boolean isArchive2 = tuple23._2$mcZ$sp();
        Try<URL> url2 = Try$.MODULE$.apply((Function0<URL> & Serializable)() -> new URL(codeUrl2)).recoverWith(new Serializable(codeUrl2){
            private static final long serialVersionUID = 0L;
            private final String codeUrl$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MalformedURLException) {
                    return (B1)Try$.MODULE$.apply((Function0<URL> & Serializable)() -> new URL(new StringBuilder(7).append("file://").append($this.codeUrl$1).toString()));
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof MalformedURLException;
            }
            {
                this.codeUrl$1 = codeUrl$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(totoro.ocelot.brain.entity.fs.FileSystemAPI$$anonfun$1 )}, serializedLambda);
            }
        });
        File file = (File)url2.map((Function1<URL, File> & Serializable)url -> new File(url.toURI())).recoverWith(new Serializable(url2){
            private static final long serialVersionUID = 0L;
            private final Try url$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof URISyntaxException) {
                    return (B1)this.url$1.map((Function1<URL, File> & Serializable)url -> new File(url.getPath()));
                }
                return function1.apply(x2);
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                return throwable instanceof URISyntaxException;
            }
            {
                this.url$1 = url$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(java.net.URL )}, serializedLambda);
            }
        }).getOrElse((Function0<File> & Serializable)() -> new File(codeSource));
        if (isArchive2) {
            return ZipFileInputStreamFileSystem$.MODULE$.fromFile(file, innerPath.substring(1));
        }
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(new File(file.getParent()), innerPath);
        if (file2.exists() && file2.isDirectory()) {
            return new FileSystemAPI.ReadOnlyFileSystem(file2);
        }
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps(System.getProperty("java.class.path").split(System.getProperty("path.separator"))), (Function1<String, Object> & Serializable)cp -> BoxesRunTime.boxToBoolean(FileSystemAPI$.$anonfun$fromClass$4(innerPath, cp)));
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String dir = (String)some.value();
            return new FileSystemAPI.ReadOnlyFileSystem(new File(new File(dir), innerPath));
        }
        throw new MatchError(option);
    }

    public Capacity fromDirectory(File file, long capacity, boolean buffered) {
        Serializable serializable = !file.isDirectory() ? BoxesRunTime.boxToBoolean(file.delete()) : BoxedUnit.UNIT;
        file.mkdirs();
        if (file.exists() && file.isDirectory()) {
            if (buffered) {
                return new FileSystemAPI.BufferedFileSystem(file, capacity);
            }
            return new FileSystemAPI.ReadWriteFileSystem(file, capacity);
        }
        return null;
    }

    public FileSystemTrait fromMemory(long capacity) {
        return new FileSystemAPI.RamFileSystem(capacity);
    }

    public FileSystemTrait asReadOnly(FileSystemTrait fileSystem) {
        if (fileSystem.isReadOnly()) {
            return fileSystem;
        }
        return new ReadOnlyWrapper(fileSystem);
    }

    public FileSystem asManagedEnvironment(FileSystemTrait fileSystem, Label label, int speed, Enumeration.Value activityType) {
        return (FileSystem)Option$.MODULE$.apply(fileSystem).flatMap((Function1<FileSystemTrait, Some> & Serializable)fs -> new Some<FileSystem>(new FileSystem((FileSystemTrait)fs, label, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(speed - 1), 0)), 5), Option$.MODULE$.apply(activityType)))).orNull($less$colon$less$.MODULE$.refl());
    }

    public FileSystem asManagedEnvironment(String address, FileSystemTrait fileSystem, Label label, int speed, Enumeration.Value activityType) {
        return (FileSystem)Option$.MODULE$.apply(fileSystem).flatMap((Function1<FileSystemTrait, Some> & Serializable)fs -> new Some<FileSystem>(new FileSystem(address, (FileSystemTrait)fs, label, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(speed - 1), 0)), 5), Option$.MODULE$.apply(activityType)))).orNull($less$colon$less$.MODULE$.refl());
    }

    public FileSystem asManagedEnvironment(FileSystemTrait fileSystem, String label, int speed, Enumeration.Value activityType) {
        return this.asManagedEnvironment(fileSystem, new FileSystemAPI.ReadOnlyLabel(label), speed, activityType);
    }

    public FileSystem asManagedEnvironment(FileSystemTrait fileSystem, Label label, Enumeration.Value activityType) {
        return this.asManagedEnvironment(fileSystem, label, 1, activityType);
    }

    public FileSystem asManagedEnvironment(FileSystemTrait fileSystem, String label, Enumeration.Value activityType) {
        return this.asManagedEnvironment(fileSystem, new FileSystemAPI.ReadOnlyLabel(label), 1, activityType);
    }

    public FileSystem asManagedEnvironment(FileSystemTrait fileSystem, Enumeration.Value activityType) {
        return this.asManagedEnvironment(fileSystem, (Label)null, 1, activityType);
    }

    public static final /* synthetic */ boolean $anonfun$isValidFilename$1(char elem) {
        return MODULE$.invalidChars().contains(BoxesRunTime.boxToCharacter(elem));
    }

    public static final /* synthetic */ boolean $anonfun$fromClass$4(String innerPath$1, String cp) {
        File fsp = new File(new File(cp), innerPath$1);
        return fsp.exists() && fsp.isDirectory();
    }

    private FileSystemAPI$() {
    }
}

