/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.sound_card;

import scala.reflect.ScalaSignature;
import totoro.ocelot.brain.entity.sound_card.AudioChannel;
import totoro.ocelot.brain.entity.sound_card.AudioProcess;
import totoro.ocelot.brain.entity.sound_card.Modulator;
import totoro.ocelot.brain.nbt.NBTTagCompound;

@ScalaSignature(bytes="\u0006\u0005\u001d3Aa\u0002\u0005\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003!\u0011\u0015!\u0003\u0001\"\u0001&\u0011\u0015!\u0003\u0001\"\u0001)\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u00151\u0004\u0001\"\u00118\u0005I\tU\u000e\u001d7jiV$W-T8ek2\fGo\u001c:\u000b\u0005%Q\u0011AC:pk:$wlY1sI*\u00111\u0002D\u0001\u0007K:$\u0018\u000e^=\u000b\u00055q\u0011!\u00022sC&t'BA\b\u0011\u0003\u0019y7-\u001a7pi*\t\u0011#\u0001\u0004u_R|'o\\\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\u0005\n\u0005uA!!C'pIVd\u0017\r^8s\u00039iw\u000eZ;mCR|'/\u00138eKb,\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\u0007%sG/A\bn_\u0012,H.\u0019;pe&sG-\u001a=!\u0003\u0019a\u0014N\\5u}Q\u0011ae\n\t\u00037\u0001AQAH\u0002A\u0002\u0001\"\"AJ\u0015\t\u000b)\"\u0001\u0019A\u0016\u0002\u00079\u0014G\u000f\u0005\u0002-]5\tQF\u0003\u0002+\u0019%\u0011q&\f\u0002\u000f\u001d\n#F+Y4D_6\u0004x.\u001e8e\u0003\u0011\u0019\u0018M^3\u0015\u0005I*\u0004CA\u000b4\u0013\t!dC\u0001\u0003V]&$\b\"\u0002\u0016\u0006\u0001\u0004Y\u0013\u0001C7pIVd\u0017\r^3\u0015\taZ\u0004)\u0012\t\u0003+eJ!A\u000f\f\u0003\u000b\u0019cw.\u0019;\t\u000bq2\u0001\u0019A\u001f\u0002\u000fA\u0014xnY3tgB\u00111DP\u0005\u0003\u007f!\u0011A\"Q;eS>\u0004&o\\2fgNDQ!\u0011\u0004A\u0002\t\u000bqa\u00195b]:,G\u000e\u0005\u0002\u001c\u0007&\u0011A\t\u0003\u0002\r\u0003V$\u0017n\\\"iC:tW\r\u001c\u0005\u0006\r\u001a\u0001\r\u0001O\u0001\u0006m\u0006dW/\u001a")
public class AmplitudeModulator
implements Modulator {
    private final int modulatorIndex;

    public int modulatorIndex() {
        return this.modulatorIndex;
    }

    public void save(NBTTagCompound nbt) {
        nbt.setInteger("m", this.modulatorIndex());
    }

    @Override
    public float modulate(AudioProcess process, AudioChannel channel, float value) {
        AudioChannel modulator = process.channels()[this.modulatorIndex()];
        return value * (1.0f + modulator.generate(process, true));
    }

    public AmplitudeModulator(int modulatorIndex) {
        this.modulatorIndex = modulatorIndex;
    }

    public AmplitudeModulator(NBTTagCompound nbt) {
        this(nbt.getInteger("m"));
    }
}

