/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.sound_card;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichFloat$;
import totoro.ocelot.brain.entity.sound_card.ADSREnvelope;
import totoro.ocelot.brain.entity.sound_card.AmplitudeModulator;
import totoro.ocelot.brain.entity.sound_card.AudioChannel;
import totoro.ocelot.brain.entity.sound_card.AudioProcess;
import totoro.ocelot.brain.entity.sound_card.FrequencyModulator;
import totoro.ocelot.brain.entity.sound_card.Instruction$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$;
import totoro.ocelot.brain.nbt.NBTTagCompound;

@ScalaSignature(bytes="\u0006\u0005\t=f!\u00021b\u0003Ca\u0007\"B:\u0001\t\u0003!\b\"B<\u0001\r\u0003A\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u000f\u001d\u0011i+\u0019E\u0001\u0003O1a\u0001Y1\t\u0002\u0005\r\u0002BB:\u0007\t\u0003\t)\u0003C\u0004\u0002*\u0019!\t!a\u000b\u0007\r\u0005=b\u0001AA\u0019\u0011)\t\u0019$\u0003B\u0001B\u0003%\u0011Q\u0007\u0005\u0007g&!\t!a\u000f\t\rMLA\u0011AA\"\u0011\u001d\ti!\u0003C!\u0003\u000fBaa^\u0005\u0005B\u0005-\u0003bBA(\r\u0011%\u0011\u0011\u000b\u0004\b\u0003C1\u0011\u0011\u0005BK\u0011)\ti\u0006\u0005BC\u0002\u0013\u0005\u0011q\f\u0005\u000b\u0005/\u0003\"\u0011!Q\u0001\n\u0005U\u0002BB:\u0011\t\u0003\u0011I\nC\u0004\u0002\u000eA!\tE!(\t\u000f\u0005\r\u0001\u0003\"\u0011\u0002\u0006!1q\u000f\u0005D\u0001\u0005CCaa\u001e\t\u0005B\t\u001dfABA,\r\u0001\tI\u0006C\u0006\u0002^a\u0011\t\u0011)A\u0005\u0003k\t\u0002BB:\u0019\t\u0003\t\t\u0007\u0003\u0004t1\u0011\u0005\u0011q\r\u0005\u0007ob!\t%a\u001b\u0007\r\u0005ed\u0001AA>\u0011-\ti&\bB\u0001B\u0003%\u0011QG\t\t\rMlB\u0011AA?\u0011\u0019\u0019X\u0004\"\u0001\u0002\u0004\"1q/\bC!\u0003\u000f3a!!$\u0007\u0001\u0005=\u0005bCA/E\t\u0005\t\u0015!\u0003\u00026EA!\"!%#\u0005\u0003\u0005\u000b\u0011BAJ\u0011\u0019\u0019(\u0005\"\u0001\u0002\u001a\"11O\tC\u0001\u0003CCq!!\u0004#\t\u0003\n)\u000b\u0003\u0004xE\u0011\u0005\u0013\u0011\u0016\u0004\u0007\u0003_3\u0001!!-\t\u0017\u0005u\u0013F!A!\u0002\u0013\t)$\u0005\u0005\u000b\u0003gK#\u0011!Q\u0001\n\u0005U\u0006BB:*\t\u0003\tY\f\u0003\u0004tS\u0011\u0005\u00111\u0019\u0005\b\u0003\u001bIC\u0011IAd\u0011\u001d\t\u0019!\u000bC!\u0003\u000bAaa^\u0015\u0005B\u0005-gABAi\r\u0001\t\u0019\u000eC\u0006\u0002^E\u0012\t\u0011)A\u0005\u0003k\t\u0002BB:2\t\u0003\t)\u000e\u0003\u0004tc\u0011\u0005\u00111\u001c\u0005\u0007oF\"\t%a8\u0007\r\u0005\u0015h\u0001AAt\u0011-\tiF\u000eB\u0001B\u0003%\u0011QG\t\t\u0015\u0005%hG!A!\u0002\u0013\tY\u000f\u0003\u0004tm\u0011\u0005\u0011\u0011\u001f\u0005\u0007gZ\"\t!!?\t\u000f\u00055a\u0007\"\u0011\u0002~\"9\u00111\u0001\u001c\u0005B\u0005\u0015\u0001BB<7\t\u0003\u0012\tA\u0002\u0004\u0003\b\u0019\u0001!\u0011\u0002\u0005\f\u0003;r$\u0011!Q\u0001\n\u0005U\u0012\u0003\u0003\u0004t}\u0011\u0005!1\u0002\u0005\u0007gz\"\tA!\u0005\t\r]tD\u0011\tB\u000b\r\u0019\u0011YB\u0002\u0001\u0003\u001e!Y\u0011QL\"\u0003\u0002\u0003\u0006I!!\u000e\u0012\u0011)\u0011yb\u0011B\u0001B\u0003%\u0011Q\u0007\u0005\u000b\u0005C\u0019%\u0011!Q\u0001\n\u0005U\u0002B\u0003B\u0012\u0007\n\u0005\t\u0015!\u0003\u0003&!Q!1F\"\u0003\u0002\u0003\u0006I!!\u000e\t\rM\u001cE\u0011\u0001B\u0017\u0011\u0019\u00198\t\"\u0001\u0003<!9\u0011QB\"\u0005B\t}\u0002BB<D\t\u0003\u0012\u0019E\u0002\u0004\u0003J\u0019\u0001!1\n\u0005\f\u0003;j%\u0011!Q\u0001\n\u0005U\u0012\u0003\u0003\u0004t\u001b\u0012\u0005!Q\n\u0005\u0007g6#\tAa\u0015\t\r]lE\u0011\tB,\r\u0019\u0011iF\u0002\u0001\u0003`!Y\u0011Q\f*\u0003\u0002\u0003\u0006I!!\u000e\u0012\u0011)\u0011\tG\u0015B\u0001B\u0003%!Q\u0005\u0005\u0007gJ#\tAa\u0019\t\rM\u0014F\u0011\u0001B6\u0011\u001d\tiA\u0015C!\u0005_Baa\u001e*\u0005B\tMdA\u0002B=\r\u0001\u0011Y\bC\u0006\u0002^e\u0013\t\u0011)A\u0005\u0003k\t\u0002B\u0003B?3\n\u0005\t\u0015!\u0003\u0003&!11/\u0017C\u0001\u0005\u007fBaa]-\u0005\u0002\t\u001d\u0005bBA\u00073\u0012\u0005#1\u0012\u0005\u0007of#\tEa$\u0003\u0017%s7\u000f\u001e:vGRLwN\u001c\u0006\u0003E\u000e\f!b]8v]\u0012|6-\u0019:e\u0015\t!W-\u0001\u0004f]RLG/\u001f\u0006\u0003M\u001e\fQA\u0019:bS:T!\u0001[5\u0002\r=\u001cW\r\\8u\u0015\u0005Q\u0017A\u0002;pi>\u0014xn\u0001\u0001\u0014\u0005\u0001i\u0007C\u00018r\u001b\u0005y'\"\u00019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I|'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002kB\u0011a\u000fA\u0007\u0002C\u00069Q\r_3dkR,GCA=}!\tq'0\u0003\u0002|_\n!QK\\5u\u0011\u0015i(\u00011\u0001\u007f\u0003\u001d\u0001(o\\2fgN\u0004\"A^@\n\u0007\u0005\u0005\u0011M\u0001\u0007Bk\u0012Lw\u000e\u0015:pG\u0016\u001c8/A\u0004jgZ\u000bG.\u001b3\u0016\u0005\u0005\u001d\u0001c\u00018\u0002\n%\u0019\u00111B8\u0003\u000f\t{w\u000e\\3b]\u0006!1/\u0019<f)\rI\u0018\u0011\u0003\u0005\b\u0003'!\u0001\u0019AA\u000b\u0003\rq'\r\u001e\t\u0005\u0003/\tY\"\u0004\u0002\u0002\u001a)\u0019\u00111C3\n\t\u0005u\u0011\u0011\u0004\u0002\u000f\u001d\n#F+Y4D_6\u0004x.\u001e8eS\r\u0001\u0001#\u0003\u0002\u0010\u0007\"\fgN\\3m'B,7-\u001b4jGN\u0011a!\u001c\u000b\u0003\u0003O\u0001\"A\u001e\u0004\u0002\t1|\u0017\r\u001a\u000b\u0004k\u00065\u0002bBA\n\u0011\u0001\u0007\u0011Q\u0003\u0002\u0006\t\u0016d\u0017-_\n\u0003\u0013U\fQ\u0001Z3mCf\u00042A\\A\u001c\u0013\r\tId\u001c\u0002\u0004\u0013:$H\u0003BA\u001f\u0003\u0003\u00022!a\u0010\n\u001b\u00051\u0001bBA\u001a\u0017\u0001\u0007\u0011Q\u0007\u000b\u0005\u0003{\t)\u0005C\u0004\u0002\u00141\u0001\r!!\u0006\u0015\u0007e\fI\u0005C\u0004\u0002\u00145\u0001\r!!\u0006\u0015\u0007e\fi\u0005C\u0003~\u001d\u0001\u0007a0\u0001\bjg\u000eC\u0017M\u001c8fYZ\u000bG.\u001b3\u0015\t\u0005\u001d\u00111\u000b\u0005\b\u0003+z\u0001\u0019AA\u001b\u0003\t\u0019\u0007N\u0001\u0003Pa\u0016t7c\u0001\r\u0002\\A\u0019\u0011q\b\t\u0002\u0019\rD\u0017M\u001c8fY&sG-\u001a=\u0016\u0005\u0005UB\u0003BA2\u0003K\u00022!a\u0010\u0019\u0011\u001d\tiF\u0007a\u0001\u0003k!B!a\u0019\u0002j!9\u00111C\u000eA\u0002\u0005UA#B=\u0002n\u0005=\u0004\"B?\u001d\u0001\u0004q\bbBA99\u0001\u0007\u00111O\u0001\bG\"\fgN\\3m!\r1\u0018QO\u0005\u0004\u0003o\n'\u0001D!vI&|7\t[1o]\u0016d'!B\"m_N,7cA\u000f\u0002\\Q!\u0011qPAA!\r\ty$\b\u0005\b\u0003;z\u0002\u0019AA\u001b)\u0011\ty(!\"\t\u000f\u0005M\u0001\u00051\u0001\u0002\u0016Q)\u00110!#\u0002\f\")Q0\ta\u0001}\"9\u0011\u0011O\u0011A\u0002\u0005M$\u0001D*fi\u001e+g.\u001a:bi>\u00148c\u0001\u0012\u0002\\\u0005Iq-\u001a8fe\u0006$xN\u001d\t\u0004m\u0006U\u0015bAALC\ny1+[4oC2<UM\\3sCR|'\u000f\u0006\u0004\u0002\u001c\u0006u\u0015q\u0014\t\u0004\u0003\u007f\u0011\u0003bBA/K\u0001\u0007\u0011Q\u0007\u0005\b\u0003#+\u0003\u0019AAJ)\u0011\tY*a)\t\u000f\u0005Ma\u00051\u0001\u0002\u0016Q\u0019\u00110a*\t\u000f\u0005Mq\u00051\u0001\u0002\u0016Q)\u00110a+\u0002.\")Q\u0010\u000ba\u0001}\"9\u0011\u0011\u000f\u0015A\u0002\u0005M$!B*fi\u001ak5cA\u0015\u0002\\\u0005\u0011a-\u001c\t\u0004m\u0006]\u0016bAA]C\n\u0011bI]3rk\u0016t7-_'pIVd\u0017\r^8s)\u0019\ti,a0\u0002BB\u0019\u0011qH\u0015\t\u000f\u0005uC\u00061\u0001\u00026!9\u00111\u0017\u0017A\u0002\u0005UF\u0003BA_\u0003\u000bDq!a\u0005.\u0001\u0004\t)\u0002F\u0002z\u0003\u0013Dq!a\u0005/\u0001\u0004\t)\u0002F\u0003z\u0003\u001b\fy\rC\u0003~a\u0001\u0007a\u0010C\u0004\u0002rA\u0002\r!a\u001d\u0003\u000fI+7/\u001a;G\u001bN\u0019\u0011'a\u0017\u0015\t\u0005]\u0017\u0011\u001c\t\u0004\u0003\u007f\t\u0004bBA/g\u0001\u0007\u0011Q\u0007\u000b\u0005\u0003/\fi\u000eC\u0004\u0002\u0014Q\u0002\r!!\u0006\u0015\u000be\f\t/a9\t\u000bu,\u0004\u0019\u0001@\t\u000f\u0005ET\u00071\u0001\u0002t\t)1+\u001a;B\u001bN\u0019a'a\u0017\u0002\u0005\u0005l\u0007c\u0001<\u0002n&\u0019\u0011q^1\u0003%\u0005k\u0007\u000f\\5uk\u0012,Wj\u001c3vY\u0006$xN\u001d\u000b\u0007\u0003g\f)0a>\u0011\u0007\u0005}b\u0007C\u0004\u0002^e\u0002\r!!\u000e\t\u000f\u0005%\u0018\b1\u0001\u0002lR!\u00111_A~\u0011\u001d\t\u0019B\u000fa\u0001\u0003+!2!_A\u0000\u0011\u001d\t\u0019b\u000fa\u0001\u0003+!R!\u001fB\u0002\u0005\u000bAQ!`\u001fA\u0002yDq!!\u001d>\u0001\u0004\t\u0019HA\u0004SKN,G/Q'\u0014\u0007y\nY\u0006\u0006\u0003\u0003\u000e\t=\u0001cAA }!9\u0011Q\f!A\u0002\u0005UB\u0003\u0002B\u0007\u0005'Aq!a\u0005B\u0001\u0004\t)\u0002F\u0003z\u0005/\u0011I\u0002C\u0003~\u0005\u0002\u0007a\u0010C\u0004\u0002r\t\u0003\r!a\u001d\u0003\u0017M+G/\u00128wK2|\u0007/Z\n\u0004\u0007\u0006m\u0013AB1ui\u0006\u001c7.A\u0003eK\u000e\f\u00170A\u0004tkN$\u0018-\u001b8\u0011\u00079\u00149#C\u0002\u0003*=\u0014QA\u00127pCR\fqA]3mK\u0006\u001cX\r\u0006\u0007\u00030\tE\"1\u0007B\u001b\u0005o\u0011I\u0004E\u0002\u0002@\rCq!!\u0018J\u0001\u0004\t)\u0004C\u0004\u0003 %\u0003\r!!\u000e\t\u000f\t\u0005\u0012\n1\u0001\u00026!9!1E%A\u0002\t\u0015\u0002b\u0002B\u0016\u0013\u0002\u0007\u0011Q\u0007\u000b\u0005\u0005_\u0011i\u0004C\u0004\u0002\u0014)\u0003\r!!\u0006\u0015\u0007e\u0014\t\u0005C\u0004\u0002\u0014-\u0003\r!!\u0006\u0015\u000be\u0014)Ea\u0012\t\u000bud\u0005\u0019\u0001@\t\u000f\u0005ED\n1\u0001\u0002t\ti!+Z:fi\u0016sg/\u001a7pa\u0016\u001c2!TA.)\u0011\u0011yE!\u0015\u0011\u0007\u0005}R\nC\u0004\u0002^=\u0003\r!!\u000e\u0015\t\t=#Q\u000b\u0005\b\u0003'\u0001\u0006\u0019AA\u000b)\u0015I(\u0011\fB.\u0011\u0015i\u0018\u000b1\u0001\u007f\u0011\u001d\t\t(\u0015a\u0001\u0003g\u0012\u0011bU3u->dW/\\3\u0014\u0007I\u000bY&\u0001\u0004w_2,X.\u001a\u000b\u0007\u0005K\u00129G!\u001b\u0011\u0007\u0005}\"\u000bC\u0004\u0002^U\u0003\r!!\u000e\t\u000f\t\u0005T\u000b1\u0001\u0003&Q!!Q\rB7\u0011\u001d\t\u0019B\u0016a\u0001\u0003+!2!\u001fB9\u0011\u001d\t\u0019b\u0016a\u0001\u0003+!R!\u001fB;\u0005oBQ! -A\u0002yDq!!\u001dY\u0001\u0004\t\u0019H\u0001\u0007TKR4%/Z9vK:\u001c\u0017pE\u0002Z\u00037\n\u0011B\u001a:fcV,gnY=\u0015\r\t\u0005%1\u0011BC!\r\ty$\u0017\u0005\b\u0003;b\u0006\u0019AA\u001b\u0011\u001d\u0011i\b\u0018a\u0001\u0005K!BA!!\u0003\n\"9\u00111C/A\u0002\u0005UAcA=\u0003\u000e\"9\u00111\u00030A\u0002\u0005UA#B=\u0003\u0012\nM\u0005\"B?`\u0001\u0004q\bbBA9?\u0002\u0007\u00111O\n\u0003!U\fQb\u00195b]:,G.\u00138eKb\u0004C\u0003BA.\u00057Cq!!\u0018\u0014\u0001\u0004\t)\u0004F\u0002z\u0005?Cq!a\u0005\u0015\u0001\u0004\t)\u0002F\u0003z\u0005G\u0013)\u000bC\u0003~-\u0001\u0007a\u0010C\u0004\u0002rY\u0001\r!a\u001d\u0015\u0007e\u0014I\u000bC\u0003~/\u0001\u0007a0\u000b\u0007\u0011;aqT*\r\u001cDSe\u0013#+A\u0006J]N$(/^2uS>t\u0007")
public abstract class Instruction {
    public static Instruction load(NBTTagCompound nbt) {
        return Instruction$.MODULE$.load(nbt);
    }

    public abstract void execute(AudioProcess var1);

    public boolean isValid() {
        return true;
    }

    public void save(NBTTagCompound nbt) {
        int n2;
        Instruction instruction = this;
        if (instruction instanceof Delay) {
            n2 = 0;
        } else if (instruction instanceof Open) {
            n2 = 1;
        } else if (instruction instanceof Close) {
            n2 = 2;
        } else if (instruction instanceof SetGenerator) {
            n2 = 3;
        } else if (instruction instanceof SetFM) {
            n2 = 4;
        } else if (instruction instanceof ResetFM) {
            n2 = 5;
        } else if (instruction instanceof SetAM) {
            n2 = 6;
        } else if (instruction instanceof ResetAM) {
            n2 = 7;
        } else if (instruction instanceof SetEnvelope) {
            n2 = 8;
        } else if (instruction instanceof ResetEnvelope) {
            n2 = 9;
        } else if (instruction instanceof SetVolume) {
            n2 = 10;
        } else if (instruction instanceof SetFrequency) {
            n2 = 11;
        } else {
            throw new MatchError(instruction);
        }
        nbt.setByte("t", (byte)n2);
    }

    public static abstract class ChannelSpecific
    extends Instruction {
        private final int channelIndex;

        public int channelIndex() {
            return this.channelIndex;
        }

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setInteger("c", this.channelIndex());
        }

        @Override
        public boolean isValid() {
            return Instruction$.MODULE$.totoro$ocelot$brain$entity$sound_card$Instruction$$isChannelValid(this.channelIndex());
        }

        public abstract void execute(AudioProcess var1, AudioChannel var2);

        @Override
        public void execute(AudioProcess process) {
            this.execute(process, process.channels()[this.channelIndex()]);
        }

        public ChannelSpecific(int channelIndex) {
            this.channelIndex = channelIndex;
        }
    }

    public static class Close
    extends ChannelSpecific {
        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.isOpen_$eq(false);
        }

        public Close(int channelIndex) {
            super(channelIndex);
        }

        public Close(NBTTagCompound nbt) {
            this(nbt.getInteger("c"));
        }
    }

    public static class Delay
    extends Instruction {
        private final int delay;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setInteger("d", this.delay);
        }

        @Override
        public void execute(AudioProcess process) {
            process.delay_$eq(this.delay);
        }

        public Delay(int delay) {
            this.delay = delay;
        }

        public Delay(NBTTagCompound nbt) {
            this(nbt.getInteger("d"));
        }
    }

    public static class Open
    extends ChannelSpecific {
        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.isOpen_$eq(true);
            channel.envelope().foreach((Function1<ADSREnvelope, Object> & Serializable)env -> {
                env.trigger();
                return BoxedUnit.UNIT;
            });
        }

        public Open(int channelIndex) {
            super(channelIndex);
        }

        public Open(NBTTagCompound nbt) {
            this(nbt.getInteger("c"));
        }
    }

    public static class ResetAM
    extends ChannelSpecific {
        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.amplitudeMod().foreach((Function1<AmplitudeModulator, Object> & Serializable)old -> {
                ResetAM.$anonfun$execute$5(process, old);
                return BoxedUnit.UNIT;
            });
            channel.amplitudeMod_$eq(None$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$execute$5(AudioProcess process$4, AmplitudeModulator old) {
            process$4.channels()[old.modulatorIndex()].isAmMod_$eq(false);
        }

        public ResetAM(int channelIndex) {
            super(channelIndex);
        }

        public ResetAM(NBTTagCompound nbt) {
            this(nbt.getInteger("c"));
        }
    }

    public static class ResetEnvelope
    extends ChannelSpecific {
        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.envelope_$eq(None$.MODULE$);
        }

        public ResetEnvelope(int channelIndex) {
            super(channelIndex);
        }

        public ResetEnvelope(NBTTagCompound nbt) {
            this(nbt.getInteger("c"));
        }
    }

    public static class ResetFM
    extends ChannelSpecific {
        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.frequencyMod().foreach((Function1<FrequencyModulator, Object> & Serializable)old -> {
                ResetFM.$anonfun$execute$3(process, old);
                return BoxedUnit.UNIT;
            });
            channel.frequencyMod_$eq(None$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$execute$3(AudioProcess process$2, FrequencyModulator old) {
            process$2.channels()[old.modulatorIndex()].isFmMod_$eq(false);
        }

        public ResetFM(int channelIndex) {
            super(channelIndex);
        }

        public ResetFM(NBTTagCompound nbt) {
            this(nbt.getInteger("c"));
        }
    }

    public static class SetAM
    extends ChannelSpecific {
        private final AmplitudeModulator am;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            NBTTagCompound amNBT = new NBTTagCompound();
            this.am.save(amNBT);
            nbt.setTag("am", amNBT);
        }

        @Override
        public boolean isValid() {
            return super.isValid() && Instruction$.MODULE$.totoro$ocelot$brain$entity$sound_card$Instruction$$isChannelValid(this.am.modulatorIndex());
        }

        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            if (channel.isFmMod() || channel.isAmMod()) {
                return;
            }
            channel.amplitudeMod().foreach((Function1<AmplitudeModulator, Object> & Serializable)old -> {
                SetAM.$anonfun$execute$4(process, old);
                return BoxedUnit.UNIT;
            });
            AudioChannel modulator = process.channels()[this.am.modulatorIndex()];
            modulator.isAmMod_$eq(true);
            channel.amplitudeMod_$eq(new Some<AmplitudeModulator>(this.am));
        }

        public static final /* synthetic */ void $anonfun$execute$4(AudioProcess process$3, AmplitudeModulator old) {
            process$3.channels()[old.modulatorIndex()].isAmMod_$eq(false);
        }

        public SetAM(int channelIndex, AmplitudeModulator am) {
            this.am = am;
            super(channelIndex);
        }

        public SetAM(NBTTagCompound nbt) {
            this(nbt.getInteger("c"), new AmplitudeModulator(nbt.getCompoundTag("am")));
        }
    }

    public static class SetEnvelope
    extends ChannelSpecific {
        private final int attack;
        private final int decay;
        private final float sustain;
        private final int release;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setInteger("a", this.attack);
            nbt.setInteger("d", this.decay);
            nbt.setFloat("s", this.sustain);
            nbt.setInteger("r", this.release);
        }

        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            ADSREnvelope envelope = new ADSREnvelope(this.attack, this.decay, this.sustain, this.release);
            channel.envelope().foreach((Function1<ADSREnvelope, Object> & Serializable)oldEnvelope -> {
                SetEnvelope.$anonfun$execute$6(envelope, oldEnvelope);
                return BoxedUnit.UNIT;
            });
            channel.envelope_$eq(new Some<ADSREnvelope>(envelope));
        }

        public static final /* synthetic */ void $anonfun$execute$6(ADSREnvelope envelope$1, ADSREnvelope oldEnvelope) {
            envelope$1.phase_$eq(oldEnvelope.phase());
            envelope$1.factor_$eq(oldEnvelope.factor());
        }

        public SetEnvelope(int channelIndex, int attack, int decay, float sustain, int release) {
            this.attack = attack;
            this.decay = decay;
            this.sustain = sustain;
            this.release = release;
            super(channelIndex);
        }

        public SetEnvelope(NBTTagCompound nbt) {
            this(nbt.getInteger("c"), nbt.getInteger("a"), nbt.getInteger("d"), nbt.getFloat("s"), nbt.getInteger("r"));
        }
    }

    public static class SetFM
    extends ChannelSpecific {
        private final FrequencyModulator fm;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            NBTTagCompound fmNBT = new NBTTagCompound();
            this.fm.save(fmNBT);
            nbt.setTag("fm", fmNBT);
        }

        @Override
        public boolean isValid() {
            return super.isValid() && Instruction$.MODULE$.totoro$ocelot$brain$entity$sound_card$Instruction$$isChannelValid(this.fm.modulatorIndex());
        }

        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            if (channel.isFmMod() || channel.isAmMod()) {
                return;
            }
            channel.frequencyMod().foreach((Function1<FrequencyModulator, Object> & Serializable)old -> {
                SetFM.$anonfun$execute$2(process, old);
                return BoxedUnit.UNIT;
            });
            AudioChannel modulator = process.channels()[this.fm.modulatorIndex()];
            modulator.isFmMod_$eq(true);
            channel.frequencyMod_$eq(new Some<FrequencyModulator>(this.fm));
        }

        public static final /* synthetic */ void $anonfun$execute$2(AudioProcess process$1, FrequencyModulator old) {
            process$1.channels()[old.modulatorIndex()].isFmMod_$eq(false);
        }

        public SetFM(int channelIndex, FrequencyModulator fm) {
            this.fm = fm;
            super(channelIndex);
        }

        public SetFM(NBTTagCompound nbt) {
            this(nbt.getInteger("c"), new FrequencyModulator(nbt.getCompoundTag("fm")));
        }
    }

    public static class SetFrequency
    extends ChannelSpecific {
        private final float frequency;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setFloat("f", this.frequency);
        }

        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.frequency_$eq(this.frequency);
        }

        public SetFrequency(int channelIndex, float frequency) {
            this.frequency = frequency;
            super(channelIndex);
        }

        public SetFrequency(NBTTagCompound nbt) {
            this(nbt.getInteger("c"), nbt.getFloat("f"));
        }
    }

    public static class SetGenerator
    extends ChannelSpecific {
        private final SignalGenerator generator;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            NBTTagCompound generatorNBT = new NBTTagCompound();
            this.generator.save(generatorNBT);
            nbt.setTag("g", generatorNBT);
        }

        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.generator_$eq(this.generator);
        }

        public SetGenerator(int channelIndex, SignalGenerator generator) {
            this.generator = generator;
            super(channelIndex);
        }

        public SetGenerator(NBTTagCompound nbt) {
            this(nbt.getInteger("c"), SignalGenerator$.MODULE$.load(nbt.getCompoundTag("g")));
        }
    }

    public static class SetVolume
    extends ChannelSpecific {
        private final float volume;

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setFloat("v", this.volume);
        }

        @Override
        public void execute(AudioProcess process, AudioChannel channel) {
            channel.volume_$eq(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(this.volume), 1.0f)), 0.0f));
        }

        public SetVolume(int channelIndex, float volume) {
            this.volume = volume;
            super(channelIndex);
        }

        public SetVolume(NBTTagCompound nbt) {
            this(nbt.getInteger("c"), nbt.getFloat("v"));
        }
    }
}

