/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.sound_card;

import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Sawtooth$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Sine$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Square$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Triangle$;
import totoro.ocelot.brain.nbt.NBTTagCompound;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue!B\u001b7\u0003C\t\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0002'\u0001\r\u0003i\u0005\"B*\u0001\t\u0003!\u0006\"\u0002-\u0001\t\u0003IvABAJm!\u0005QMB\u00036m!\u00051\rC\u0003I\r\u0011\u0005A\rC\u0004g\r\t\u0007I\u0011A4\t\rM4\u0001\u0015!\u0003i\u0011\u0015!h\u0001\"\u0001v\u0011\u0015qh\u0001\"\u0001\u0000\r\u0015\u0011g\u0001AA2\u0011)\t)\u0002\u0004BA\u0002\u0013\u0005\u0011Q\r\u0005\u000b\u00033a!\u00111A\u0005\u0002\u0005\u001d\u0004\"CA\u0011\u0019\t\u0005\t\u0015)\u0003|\u0011)\tY\u0007\u0004BA\u0002\u0013\u0005\u0011Q\r\u0005\u000b\u0003[b!\u00111A\u0005\u0002\u0005=\u0004\"CA:\u0019\t\u0005\t\u0015)\u0003|\u0011\u0019AE\u0002\"\u0001\u0002v!I\u0011Q\u0010\u0007A\u0002\u0013%\u0011Q\r\u0005\n\u0003\u007fb\u0001\u0019!C\u0005\u0003\u0003Cq!!\"\rA\u0003&1\u0010\u0003\u0004I\u0019\u0011\u0005\u0011q\u0011\u0005\u000712!\t%a#\t\r1cA\u0011IAH\u0011\u0015\u0019F\u0002\"\u0011U\r\u0019\t\u0019A\u0002\u0001\u0002\u0006!1\u0001j\u0007C\u0001\u0003\u000fAa\u0001S\u000e\u0005\u0002\u00055\u0001B\u0002-\u001c\t\u0003\n\t\u0002C\u0005\u0002\u0016m\u0001\r\u0011\"\u0003\u0002\u0018!I\u0011\u0011D\u000eA\u0002\u0013%\u00111\u0004\u0005\b\u0003CY\u0002\u0015)\u0003O\u0011\u0019a5\u0004\"\u0011\u0002$!)1k\u0007C!)\"9\u0011qE\u000e\u0005\n\u0005%raBA\u0016\r!\u0005\u0011Q\u0006\u0004\b\u0003_1\u0001\u0012AA\u0019\u0011\u0019Ae\u0005\"\u0001\u00024!1AJ\nC!\u0003k9q!!\u000f\u0007\u0011\u0003\tYDB\u0004\u0002>\u0019A\t!a\u0010\t\r!SC\u0011AA!\u0011\u0019a%\u0006\"\u0011\u0002D\u001d9\u0011q\t\u0004\t\u0002\u0005%caBA&\r!\u0005\u0011Q\n\u0005\u0007\u0011:\"\t!a\u0014\t\r1sC\u0011IA)\u000f\u001d\t)F\u0002E\u0001\u0003/2q!!\u0017\u0007\u0011\u0003\tY\u0006\u0003\u0004Ie\u0011\u0005\u0011Q\f\u0005\u0007\u0019J\"\t%a\u0018\u0003\u001fMKwM\\1m\u000f\u0016tWM]1u_JT!a\u000e\u001d\u0002\u0015M|WO\u001c3`G\u0006\u0014HM\u0003\u0002:u\u00051QM\u001c;jifT!a\u000f\u001f\u0002\u000b\t\u0014\u0018-\u001b8\u000b\u0005ur\u0014AB8dK2|GOC\u0001@\u0003\u0019!x\u000e^8s_\u000e\u00011C\u0001\u0001C!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0013\t\u0003\u0017\u0002i\u0011AN\u0001\tO\u0016tWM]1uKR\u0011a*\u0015\t\u0003\u0007>K!\u0001\u0015#\u0003\u000b\u0019cw.\u0019;\t\u000bI\u0013\u0001\u0019\u0001(\u0002\r=4gm]3u\u0003)qW\r\u001f;QKJLw\u000e\u001a\u000b\u0002+B\u00111IV\u0005\u0003/\u0012\u0013A!\u00168ji\u0006!1/\u0019<f)\t)&\fC\u0003\\\t\u0001\u0007A,A\u0002oER\u0004\"!X0\u000e\u0003yS!a\u0017\u001e\n\u0005\u0001t&A\u0004(C)R\u000bwmQ8na>,h\u000eZ\u0015\b\u00011Y\"G\u000b\u0014/\u0005\u0011aei\u0015*\u0014\u0005\u0019\u0011E#A3\u0011\u0005-3\u0011!B7pI\u0016\u001cX#\u00015\u0011\t%\u0004(I\u0011\b\u0003U:\u0004\"a\u001b#\u000e\u00031T!!\u001c!\u0002\rq\u0012xn\u001c;?\u0013\tyG)\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u00141!T1q\u0015\tyG)\u0001\u0004n_\u0012,7\u000fI\u0001\tMJ|W.T8eKR\u0011a/\u001f\t\u0004\u0007^T\u0015B\u0001=E\u0005\u0019y\u0005\u000f^5p]\")!P\u0003a\u0001w\u0006\u0011\u0011\u000e\u001a\t\u0003\u0007rL!! #\u0003\u0007%sG/\u0001\u0003m_\u0006$Gc\u0001&\u0002\u0002!)1l\u0003a\u00019\n)aj\\5tKN\u00111D\u0013\u000b\u0003\u0003\u0013\u00012!a\u0003\u001c\u001b\u00051A\u0003BA\u0005\u0003\u001fAQaW\u000fA\u0002q#2!VA\n\u0011\u0015Yf\u00041\u0001]\u0003\u00151\u0018\r\\;f+\u0005q\u0015!\u0003<bYV,w\fJ3r)\r)\u0016Q\u0004\u0005\t\u0003?\u0001\u0013\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010J\u0019\u0002\rY\fG.^3!)\rq\u0015Q\u0005\u0005\u0006%\n\u0002\rAT\u0001\u0013aJ|G-^2f%\u0006tGm\\7WC2,X\rF\u0001O\u0003\u0019\u0019\u0016/^1sKB\u0019\u00111\u0002\u0014\u0003\rM\u000bX/\u0019:f'\t1#\n\u0006\u0002\u0002.Q\u0019a*a\u000e\t\u000bIC\u0003\u0019\u0001(\u0002\tMKg.\u001a\t\u0004\u0003\u0017Q#\u0001B*j]\u0016\u001c\"A\u000b&\u0015\u0005\u0005mBc\u0001(\u0002F!)!\u000b\fa\u0001\u001d\u0006AAK]5b]\u001edW\rE\u0002\u0002\f9\u0012\u0001\u0002\u0016:jC:<G.Z\n\u0003])#\"!!\u0013\u0015\u00079\u000b\u0019\u0006C\u0003Sa\u0001\u0007a*\u0001\u0005TC^$xn\u001c;i!\r\tYA\r\u0002\t'\u0006<Ho\\8uQN\u0011!G\u0013\u000b\u0003\u0003/\"2ATA1\u0011\u0015\u0011F\u00071\u0001O'\ta!*F\u0001|)\r)\u0016\u0011\u000e\u0005\t\u0003?q\u0011\u0011!a\u0001w\u0006!Q.Y:l\u0003!i\u0017m]6`I\u0015\fHcA+\u0002r!A\u0011qD\t\u0002\u0002\u0003\u000710A\u0003nCN\\\u0007\u0005\u0006\u0004\u0002x\u0005e\u00141\u0010\t\u0004\u0003\u0017a\u0001BBA\u000b'\u0001\u00071\u0010\u0003\u0004\u0002lM\u0001\ra_\u0001\u0007g\u0006l\u0007\u000f\\3\u0002\u0015M\fW\u000e\u001d7f?\u0012*\u0017\u000fF\u0002V\u0003\u0007C\u0001\"a\b\u0016\u0003\u0003\u0005\ra_\u0001\bg\u0006l\u0007\u000f\\3!)\u0011\t9(!#\t\u000bm;\u0002\u0019\u0001/\u0015\u0007U\u000bi\tC\u0003\\1\u0001\u0007A\fF\u0002O\u0003#CQAU\rA\u00029\u000bqbU5h]\u0006dw)\u001a8fe\u0006$xN\u001d")
public abstract class SignalGenerator {
    public static SignalGenerator load(NBTTagCompound nbt) {
        return SignalGenerator$.MODULE$.load(nbt);
    }

    public static Option<SignalGenerator> fromMode(int id) {
        return SignalGenerator$.MODULE$.fromMode(id);
    }

    public static Map<Object, Object> modes() {
        return SignalGenerator$.MODULE$.modes();
    }

    public abstract float generate(float var1);

    public void nextPeriod() {
    }

    public void save(NBTTagCompound nbt) {
        int n2;
        SignalGenerator signalGenerator = this;
        if (signalGenerator instanceof LFSR) {
            n2 = 0;
        } else if (signalGenerator instanceof Noise) {
            n2 = 1;
        } else if (SignalGenerator$Square$.MODULE$.equals(signalGenerator)) {
            n2 = 2;
        } else if (SignalGenerator$Sine$.MODULE$.equals(signalGenerator)) {
            n2 = 3;
        } else if (SignalGenerator$Triangle$.MODULE$.equals(signalGenerator)) {
            n2 = 4;
        } else if (SignalGenerator$Sawtooth$.MODULE$.equals(signalGenerator)) {
            n2 = 5;
        } else {
            throw new MatchError(signalGenerator);
        }
        nbt.setByte("t", (byte)n2);
    }

    public static class LFSR
    extends SignalGenerator {
        private int value;
        private int mask;
        private int sample;

        public int value() {
            return this.value;
        }

        public void value_$eq(int x$1) {
            this.value = x$1;
        }

        public int mask() {
            return this.mask;
        }

        public void mask_$eq(int x$1) {
            this.mask = x$1;
        }

        private int sample() {
            return this.sample;
        }

        private void sample_$eq(int x$1) {
            this.sample = x$1;
        }

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setInteger("v", this.value());
            nbt.setInteger("m", this.mask());
            nbt.setInteger("s", this.sample());
        }

        @Override
        public float generate(float offset) {
            return this.sample();
        }

        @Override
        public void nextPeriod() {
            if ((this.value() & 1) != 0) {
                this.value_$eq(this.value() >>> 1 ^ this.mask());
                this.sample_$eq(1);
                return;
            }
            this.value_$eq(this.value() >>> 1);
            this.sample_$eq(-1);
        }

        public LFSR(int value, int mask) {
            this.value = value;
            this.mask = mask;
            this.sample = 1;
        }

        public LFSR(NBTTagCompound nbt) {
            this(nbt.getInteger("v"), nbt.getInteger("m"));
            this.sample_$eq(nbt.getInteger("s"));
        }
    }

    public static class Noise
    extends SignalGenerator {
        private float value = this.produceRandomValue();

        @Override
        public void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.setFloat("v", this.value());
        }

        private float value() {
            return this.value;
        }

        private void value_$eq(float x$1) {
            this.value = x$1;
        }

        @Override
        public float generate(float offset) {
            return this.value();
        }

        @Override
        public void nextPeriod() {
            this.value_$eq(this.produceRandomValue());
        }

        private float produceRandomValue() {
            return (float)package$.MODULE$.random() * (float)2 - 1.0f;
        }

        public Noise() {
        }

        public Noise(NBTTagCompound nbt) {
            this();
            this.value_$eq(nbt.getFloat("v"));
        }
    }
}

