/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import totoro.ocelot.brain.nbt.NBTReadLimiter;
import totoro.ocelot.brain.nbt.NBTTagByte;
import totoro.ocelot.brain.nbt.NBTTagByteArray;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagDouble;
import totoro.ocelot.brain.nbt.NBTTagEnd;
import totoro.ocelot.brain.nbt.NBTTagFloat;
import totoro.ocelot.brain.nbt.NBTTagInt;
import totoro.ocelot.brain.nbt.NBTTagIntArray;
import totoro.ocelot.brain.nbt.NBTTagList;
import totoro.ocelot.brain.nbt.NBTTagLong;
import totoro.ocelot.brain.nbt.NBTTagShort;
import totoro.ocelot.brain.nbt.NBTTagString;

public abstract class NBTBase {
    abstract void write(DataOutput var1) throws IOException;

    abstract void load(DataInput var1, int var2, NBTReadLimiter var3) throws IOException;

    public abstract String toString();

    public abstract byte getId();

    protected NBTBase() {
    }

    protected static NBTBase createTag(byte by) {
        switch (by) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte();
            }
            case 2: {
                return new NBTTagShort();
            }
            case 3: {
                return new NBTTagInt();
            }
            case 4: {
                return new NBTTagLong();
            }
            case 5: {
                return new NBTTagFloat();
            }
            case 6: {
                return new NBTTagDouble();
            }
            case 7: {
                return new NBTTagByteArray();
            }
            case 8: {
                return new NBTTagString();
            }
            case 9: {
                return new NBTTagList();
            }
            case 10: {
                return new NBTTagCompound();
            }
            case 11: {
                return new NBTTagIntArray();
            }
        }
        return null;
    }

    public abstract NBTBase clone();

    public boolean equals(Object object) {
        if (!(object instanceof NBTBase)) {
            return false;
        }
        NBTBase nBTBase = (NBTBase)object;
        return this.getId() == nBTBase.getId();
    }

    public int hashCode() {
        return this.getId();
    }

    protected String getString() {
        return this.toString();
    }
}

