/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.network;

import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.traits.Environment;
import totoro.ocelot.brain.entity.traits.SidedEnvironment;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTTagByte;
import totoro.ocelot.brain.nbt.NBTTagByteArray;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagDouble;
import totoro.ocelot.brain.nbt.NBTTagFloat;
import totoro.ocelot.brain.nbt.NBTTagInt;
import totoro.ocelot.brain.nbt.NBTTagLong;
import totoro.ocelot.brain.nbt.NBTTagShort;
import totoro.ocelot.brain.nbt.NBTTagString;
import totoro.ocelot.brain.network.Network;
import totoro.ocelot.brain.network.Node;
import totoro.ocelot.brain.network.Packet;
import totoro.ocelot.brain.network.Packet$;
import totoro.ocelot.brain.network.WirelessEndpoint;
import totoro.ocelot.brain.network.WirelessNetwork$;
import totoro.ocelot.brain.util.Direction;
import totoro.ocelot.brain.util.Direction$;

public final class Network$ {
    public static final Network$ MODULE$ = new Network$();

    public void joinOrCreateNetwork(Object entity) {
        Direction$.MODULE$.values().foreach((Function1<Enumeration.Value, Object> & Serializable)side -> {
            Network$.$anonfun$joinOrCreateNetwork$1(entity, side);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Node> getNetworkNode(Object entity, Direction.DirectionVal side) {
        if (entity != null) {
            Object object = entity;
            if (object instanceof SidedEnvironment) {
                SidedEnvironment sidedEnvironment = (SidedEnvironment)object;
                return Option$.MODULE$.apply(sidedEnvironment.sidedNode(side));
            }
            if (object instanceof Environment) {
                Environment environment = (Environment)object;
                return Option$.MODULE$.apply(environment.node());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public void joinWirelessNetwork(WirelessEndpoint endpoint) {
        WirelessNetwork$.MODULE$.add(endpoint);
    }

    public void joinNewNetwork(Node node) {
        if (node.network() == null) {
            new Network(node);
            return;
        }
    }

    public void leaveWirelessNetwork(WirelessEndpoint endpoint) {
        WirelessNetwork$.MODULE$.remove(endpoint);
    }

    public void sendWirelessPacket(WirelessEndpoint source, double strength, Packet packet) {
        WirelessNetwork$.MODULE$.endpoints().foreach((Function1<WirelessEndpoint, Object> & Serializable)endpoint -> {
            endpoint.receivePacket(packet, source);
            return BoxedUnit.UNIT;
        });
    }

    public Network.NodeBuilder newNode(Environment host, Enumeration.Value reachability, String address) {
        return new Network.NodeBuilder(host, reachability, address);
    }

    public String newNode$default$3() {
        return null;
    }

    public Packet newPacket(String source, String destination, int port, Object[] data) {
        Packet packet = new Packet(source, destination, port, data, Packet$.MODULE$.$lessinit$greater$default$5());
        if (packet.size() > Settings$.MODULE$.get().maxNetworkPacketSize()) {
            throw new IllegalArgumentException(new StringBuilder(21).append("packet too big (max ").append(Settings$.MODULE$.get().maxNetworkPacketSize()).append(")").toString());
        }
        return packet;
    }

    public Packet newPacket(NBTTagCompound nbt) {
        String source = nbt.getString("source");
        String destination = nbt.hasKey("dest") ? null : nbt.getString("dest");
        int port = nbt.getInteger("port");
        int ttl = nbt.getInteger("ttl");
        Object[] data = (Object[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nbt.getInteger("dataLength")).map((Function1<Object, Object> & Serializable)i2 -> Network$.$anonfun$newPacket$1(nbt, BoxesRunTime.unboxToInt(i2))).toArray(ClassTag$.MODULE$.AnyRef());
        return new Packet(source, destination, port, data, ttl);
    }

    public Seq<Map<String, Network.Vertex>> totoro$ocelot$brain$network$Network$$searchGraphs(Seq<Network.Vertex> seeds) {
        Set seen = (Set)Set$.MODULE$.empty();
        return (Seq)((IterableOps)((IterableOps)seeds.map((Function1<Network.Vertex, Option> & Serializable)seed -> {
            if (seen.contains(seed)) {
                return None$.MODULE$;
            }
            Map addressed = (Map)Map$.MODULE$.empty();
            Queue queue = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Network.Vertex[]{seed}));
            while (queue.nonEmpty()) {
                Network.Vertex node = (Network.Vertex)queue.dequeue();
                seen.$plus$eq(node);
                addressed.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(node.data().address()), node));
                queue.$plus$plus$eq((IterableOnce)((StrictOptimizedIterableOps)node.edges().map((Function1<Network.Edge, Network.Vertex> & Serializable)x$32 -> x$32.other(node))).filter((Function1<Network.Vertex, Object> & Serializable)n2 -> BoxesRunTime.boxToBoolean(Network$.$anonfun$searchGraphs$3(seen, queue, n2))));
            }
            return new Some<Map>(addressed);
        })).filter((Function1<Option, Object> & Serializable)x$33 -> BoxesRunTime.boxToBoolean(x$33.nonEmpty()))).map((Function1<Option, Map> & Serializable)x$34 -> (Map)x$34.get());
    }

    public static final /* synthetic */ void $anonfun$joinOrCreateNetwork$1(Object entity$1, Enumeration.Value side) {
        Some some;
        Node node;
        Option<Node> option = MODULE$.getNetworkNode(entity$1, Direction$.MODULE$.valueToDirectionVal(side));
        if (option instanceof Some && (node = (Node)(some = (Some)option).value()).network() == null) {
            MODULE$.joinNewNetwork(node);
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$newPacket$1(NBTTagCompound nbt$1, int i2) {
        if (nbt$1.hasKey(new StringBuilder(4).append("data").append(i2).toString())) {
            NBTBase nBTBase = nbt$1.getTag(new StringBuilder(4).append("data").append(i2).toString());
            if (nBTBase instanceof NBTTagByte) {
                NBTTagByte nBTTagByte = (NBTTagByte)nBTBase;
                return BoxesRunTime.boxToBoolean(nBTTagByte.getByte() == 1);
            }
            if (nBTBase instanceof NBTTagShort) {
                NBTTagShort nBTTagShort = (NBTTagShort)nBTBase;
                return BoxesRunTime.boxToShort(nBTTagShort.getShort());
            }
            if (nBTBase instanceof NBTTagInt) {
                NBTTagInt nBTTagInt = (NBTTagInt)nBTBase;
                return BoxesRunTime.boxToInteger(nBTTagInt.getInt());
            }
            if (nBTBase instanceof NBTTagLong) {
                NBTTagLong nBTTagLong = (NBTTagLong)nBTBase;
                return BoxesRunTime.boxToLong(nBTTagLong.getLong());
            }
            if (nBTBase instanceof NBTTagFloat) {
                NBTTagFloat nBTTagFloat = (NBTTagFloat)nBTBase;
                return BoxesRunTime.boxToFloat(nBTTagFloat.getFloat());
            }
            if (nBTBase instanceof NBTTagDouble) {
                NBTTagDouble nBTTagDouble = (NBTTagDouble)nBTBase;
                return BoxesRunTime.boxToDouble(nBTTagDouble.getDouble());
            }
            if (nBTBase instanceof NBTTagString) {
                NBTTagString nBTTagString = (NBTTagString)nBTBase;
                return nBTTagString.getString();
            }
            if (nBTBase instanceof NBTTagByteArray) {
                NBTTagByteArray nBTTagByteArray = (NBTTagByteArray)nBTBase;
                return nBTTagByteArray.getByteArray();
            }
            throw new MatchError(nBTBase);
        }
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$searchGraphs$3(Set seen$1, Queue queue$1, Network.Vertex n2) {
        return !seen$1.contains(n2) && !queue$1.contains(n2);
    }

    private Network$() {
    }
}

