/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.util;

import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import totoro.ocelot.brain.util.GameTimeFormatter;

public final class GameTimeFormatter$ {
    public static final GameTimeFormatter$ MODULE$ = new GameTimeFormatter$();
    private static final String[] weekDays = (String[])((Object[])new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"});
    private static final String[] shortWeekDays = (String[])((Object[])new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"});
    private static final String[] months = (String[])((Object[])new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
    private static final String[] shortMonths = (String[])((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
    private static final String[] amPm = (String[])((Object[])new String[]{"AM", "PM"});
    private static final Map<Object, Function1<GameTimeFormatter.DateTime, String>> specifiers = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('a')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.shortWeekDays()[t.weekDay() - 1]), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('A')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.weekDays()[t.weekDay() - 1]), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('b')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.shortMonths()[t.month() - 1]), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('B')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.months()[t.month() - 1]), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('c')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%a %b %e %H:%M:%S %Y", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('C')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.year() / 100)}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('d')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.day())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('D')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%m/%d/%y", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('e')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%2d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.day())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('F')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%Y-%m-%d", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('h')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%b", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('H')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.hour())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('I')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger((t.hour() + 11) % 12 + 1)}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('j')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%03d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.yearDay())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('m')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.month())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('M')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.minute())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('n')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)x$1 -> "\n"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('p')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.amPm()[t.hour() < 12 ? 0 : 1]), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('r')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%I:%M:%S %p", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('R')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%H:%M", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('S')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.second())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('t')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)x$2 -> "\t"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('T')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%H:%M:%S", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('w')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> String.valueOf(BoxesRunTime.boxToInteger(t.weekDay() - 1))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('x')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%D", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('X')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> MODULE$.format("%T", (GameTimeFormatter.DateTime)t)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('y')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%02d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.year() % 100)}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('Y')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)t -> StringOps$.MODULE$.format$extension("%04d", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(t.year())}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToCharacter('%')), (Function1<GameTimeFormatter.DateTime, String> & Serializable)x$3 -> "%")}));

    private String[] weekDays() {
        return weekDays;
    }

    private String[] shortWeekDays() {
        return shortWeekDays;
    }

    private String[] months() {
        return months;
    }

    private String[] shortMonths() {
        return shortMonths;
    }

    private String[] amPm() {
        return amPm;
    }

    private Map<Object, Function1<GameTimeFormatter.DateTime, String>> specifiers() {
        return specifiers;
    }

    public GameTimeFormatter.DateTime parse(double time) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis((long)(time * (double)1000));
        return new GameTimeFormatter.DateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(7), calendar.get(6), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public String format(String format2, GameTimeFormatter.DateTime time) {
        StringBuilder result2 = new StringBuilder();
        Iterator<Object> iterator = StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(format2));
        while (iterator.hasNext()) {
            char c2 = BoxesRunTime.unboxToChar(iterator.next());
            switch (c2) {
                case '%': {
                    Serializable serializable;
                    if (iterator.hasNext()) {
                        Option option = this.specifiers().get(iterator.next());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Function1 specifier = (Function1)some.value();
                            serializable = result2.append((String)specifier.apply(time));
                            break;
                        }
                        serializable = BoxedUnit.UNIT;
                        break;
                    }
                }
                default: {
                    Serializable serializable = result2.append(c2);
                    break;
                }
            }
        }
        return result2.toString();
    }

    public Option<Object> mktime(int year, int mon, int mday, int hour, int min2, int sec) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(1, year);
        calendar.set(2, mon - 1);
        calendar.set(5, mday);
        calendar.set(11, hour);
        calendar.set(12, min2);
        calendar.set(13, sec);
        return Option$.MODULE$.apply(BoxesRunTime.boxToInteger((int)(calendar.getTimeInMillis() / 1000L)));
    }

    private GameTimeFormatter$() {
    }
}

