/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.util;

import java.io.Serializable;
import java.util.PrimitiveIterator;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArraySeq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagList;
import totoro.ocelot.brain.nbt.NBTTagString;
import totoro.ocelot.brain.nbt.NbtDataStream$;
import totoro.ocelot.brain.util.ColorDepth$;
import totoro.ocelot.brain.util.ExtendedUnicodeHelper$;
import totoro.ocelot.brain.util.FontUtils$;
import totoro.ocelot.brain.util.PackedColor;
import totoro.ocelot.brain.util.PackedColor$;
import totoro.ocelot.brain.util.PackedColor$Color$;
import totoro.ocelot.brain.util.PackedColor$Depth$;
import totoro.ocelot.brain.workspace.Workspace;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001\u0002\u00180\u0001aB\u0001b\u0010\u0001\u0003\u0002\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0019!C\u0001\u000b\"A1\n\u0001B\u0001B\u0003&\u0011\t\u0003\u0005M\u0001\t\u0005\r\u0011\"\u0001A\u0011!i\u0005A!a\u0001\n\u0003q\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0015B!\t\u0011E\u0003!\u0011!Q\u0001\nICQA\u0017\u0001\u0005\u0002mCQA\u0017\u0001\u0005\u0002\u0001Dq\u0001\u001b\u0001A\u0002\u0013%\u0011\u000eC\u0004k\u0001\u0001\u0007I\u0011B6\t\r5\u0004\u0001\u0015)\u0003S\u0011\u001dq\u0007\u00011A\u0005\n=Dqa\u001d\u0001A\u0002\u0013%A\u000f\u0003\u0004w\u0001\u0001\u0006K\u0001\u001d\u0005\bo\u0002\u0001\r\u0011\"\u0003p\u0011\u001dA\b\u00011A\u0005\neDaa\u001f\u0001!B\u0013\u0001\bb\u0002?\u0001\u0001\u0004%I! \u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000bAq!!\u0003\u0001A\u0003&a\u0010\u0003\u0004\u0002\f\u0001!\ta\u001c\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u0019\t)\u0002\u0001C\u0001_\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001\"B4\u0001\t\u0003I\u0007bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\n\u0003S\u0001\u0001\u0019!C\u0001\u0003WA\u0011\"!\u000e\u0001\u0001\u0004%\t!a\u000e\t\u0011\u0005m\u0002\u0001)Q\u0005\u0003[A\u0011\"!\u0010\u0001\u0001\u0004%\t!a\u0010\t\u0013\u0005\u0015\u0003\u00011A\u0005\u0002\u0005\u001d\u0003\u0002CA&\u0001\u0001\u0006K!!\u0011\t\r\t\u0004A\u0011AA'\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!?\u0001\t\u0003\tY\u0010C\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n\t\tr)\u001a8fe&\u001cG+\u001a=u\u0005V4g-\u001a:\u000b\u0005A\n\u0014\u0001B;uS2T!AM\u001a\u0002\u000b\t\u0014\u0018-\u001b8\u000b\u0005Q*\u0014AB8dK2|GOC\u00017\u0003\u0019!x\u000e^8s_\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u0006)q/\u001b3uQV\t\u0011\t\u0005\u0002;\u0005&\u00111i\u000f\u0002\u0004\u0013:$\u0018!C<jIRDw\fJ3r)\t1\u0015\n\u0005\u0002;\u000f&\u0011\u0001j\u000f\u0002\u0005+:LG\u000fC\u0004K\u0005\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'\u0001\u0004xS\u0012$\b\u000eI\u0001\u0007Q\u0016Lw\r\u001b;\u0002\u0015!,\u0017n\u001a5u?\u0012*\u0017\u000f\u0006\u0002G\u001f\"9!*BA\u0001\u0002\u0004\t\u0015a\u00025fS\u001eDG\u000fI\u0001\u000eS:LG/[1m\r>\u0014X.\u0019;\u0011\u0005M;fB\u0001+V\u001b\u0005y\u0013B\u0001,0\u0003-\u0001\u0016mY6fI\u000e{Gn\u001c:\n\u0005aK&aC\"pY>\u0014hi\u001c:nCRT!AV\u0018\u0002\rqJg.\u001b;?)\u0011aVLX0\u0011\u0005Q\u0003\u0001\"B \t\u0001\u0004\t\u0005\"\u0002'\t\u0001\u0004\t\u0005\"B)\t\u0001\u0004\u0011Fc\u0001/bM\")!-\u0003a\u0001G\u0006!1/\u001b>f!\u0011QD-Q!\n\u0005\u0015\\$A\u0002+va2,'\u0007C\u0003h\u0013\u0001\u0007!+\u0001\u0004g_Jl\u0017\r^\u0001\b?\u001a|'/\\1u+\u0005\u0011\u0016aC0g_Jl\u0017\r^0%KF$\"A\u00127\t\u000f)[\u0011\u0011!a\u0001%\u0006AqLZ8s[\u0006$\b%A\u0006`M>\u0014Xm\u001a:pk:$W#\u00019\u0011\u0005M\u000b\u0018B\u0001:Z\u0005\u0015\u0019u\u000e\\8s\u0003=yfm\u001c:fOJ|WO\u001c3`I\u0015\fHC\u0001$v\u0011\u001dQe\"!AA\u0002A\fAb\u00184pe\u0016<'o\\;oI\u0002\n1b\u00182bG.<'o\\;oI\u0006yqLY1dW\u001e\u0014x.\u001e8e?\u0012*\u0017\u000f\u0006\u0002Gu\"9!*EA\u0001\u0002\u0004\u0001\u0018\u0001D0cC\u000e\\wM]8v]\u0012\u0004\u0013A\u00029bG.,G-F\u0001\u007f!\tQt0C\u0002\u0002\u0002m\u0012Qa\u00155peR\f!\u0002]1dW\u0016$w\fJ3r)\r1\u0015q\u0001\u0005\b\u0015R\t\t\u00111\u0001\u007f\u0003\u001d\u0001\u0018mY6fI\u0002\n!BZ8sK\u001e\u0014x.\u001e8e\u000391wN]3he>,h\u000eZ0%KF$2\u0001XA\t\u0011\u0019\t\u0019b\u0006a\u0001a\u0006)a/\u00197vK\u0006Q!-Y2lOJ|WO\u001c3\u0002\u001d\t\f7m[4s_VtGm\u0018\u0013fcR\u0019A,a\u0007\t\r\u0005M\u0011\u00041\u0001q\u0003)1wN]7bi~#S-\u001d\u000b\u0005\u0003C\t9\u0003E\u0002;\u0003GI1!!\n<\u0005\u001d\u0011un\u001c7fC:Da!a\u0005\u001c\u0001\u0004\u0011\u0016!B2pY>\u0014XCAA\u0017!\u0015Q\u0014qFA\u001a\u0013\r\t\td\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005u\u0005=b0A\u0005d_2|'o\u0018\u0013fcR\u0019a)!\u000f\t\u0011)k\u0012\u0011!a\u0001\u0003[\taaY8m_J\u0004\u0013A\u00022vM\u001a,'/\u0006\u0002\u0002BA)!(a\f\u0002DA!!(a\fB\u0003)\u0011WO\u001a4fe~#S-\u001d\u000b\u0004\r\u0006%\u0003\u0002\u0003&!\u0003\u0003\u0005\r!!\u0011\u0002\u000f\t,hMZ3sAU\t1-\u0001\u0005tSj,w\fJ3r)\u0011\t\t#a\u0015\t\r\u0005M1\u00051\u0001d\u0003\r9W\r\u001e\u000b\u0006\u0003\u0006e\u0013Q\f\u0005\u0007\u00037\"\u0003\u0019A!\u0002\u0007\r|G\u000e\u0003\u0004\u0002`\u0011\u0002\r!Q\u0001\u0004e><\u0018aA:fiRQ\u0011\u0011EA3\u0003O\nI'a!\t\r\u0005mS\u00051\u0001B\u0011\u0019\ty&\na\u0001\u0003\"9\u00111N\u0013A\u0002\u00055\u0014!A:\u0011\t\u0005=\u0014Q\u0010\b\u0005\u0003c\nI\bE\u0002\u0002tmj!!!\u001e\u000b\u0007\u0005]t'\u0001\u0004=e>|GOP\u0005\u0004\u0003wZ\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\u0005\u0005%AB*ue&twMC\u0002\u0002|mBq!!\"&\u0001\u0004\t\t#\u0001\u0005wKJ$\u0018nY1m\u0003\u00111\u0017\u000e\u001c7\u0015\u0019\u0005\u0005\u00121RAG\u0003\u001f\u000b\u0019*a&\t\r\u0005mc\u00051\u0001B\u0011\u0019\tyF\na\u0001\u0003\"1\u0011\u0011\u0013\u0014A\u0002\u0005\u000b\u0011a\u001e\u0005\u0007\u0003+3\u0003\u0019A!\u0002\u0003!Da!!''\u0001\u0004\t\u0015!A2\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003C\ty*!)\u0002$\u0006\u0015\u0016qUAV\u0011\u0019\tYf\na\u0001\u0003\"1\u0011qL\u0014A\u0002\u0005Ca!!%(\u0001\u0004\t\u0005BBAKO\u0001\u0007\u0011\t\u0003\u0004\u0002*\u001e\u0002\r!Q\u0001\u0003ibDa!!,(\u0001\u0004\t\u0015A\u0001;z\u0003\u001d\u0011\u0018m^2paf$\u0002#!\t\u00024\u0006U\u0016qWA]\u0003w\u000by,a1\t\r\u0005m\u0003\u00061\u0001B\u0011\u0019\ty\u0006\u000ba\u0001\u0003\"1\u0011\u0011\u0013\u0015A\u0002\u0005Ca!!&)\u0001\u0004\t\u0005BBA_Q\u0001\u0007A,A\u0002te\u000eDa!!1)\u0001\u0004\t\u0015a\u00024s_6\u001cu\u000e\u001c\u0005\u0007\u0003\u000bD\u0003\u0019A!\u0002\u000f\u0019\u0014x.\u001c*po\u000691/\u001a;DQ\u0006\u0014H#\u0003$\u0002L\u0006=\u00171[Al\u0011\u001d\ti-\u000ba\u0001\u0003\u0007\nA\u0001\\5oK\"9\u0011\u0011[\u0015A\u0002\u0005M\u0012!\u00037j]\u0016\u001cu\u000e\\8s\u0011\u0019\t).\u000ba\u0001\u0003\u0006\t\u0001\u0010\u0003\u0004\u0002\u001a&\u0002\r!Q\u0001\u0005Y>\fG\rF\u0003G\u0003;\fY\u000fC\u0004\u0002`*\u0002\r!!9\u0002\u00079\u0014G\u000f\u0005\u0003\u0002d\u0006\u001dXBAAs\u0015\r\ty.M\u0005\u0005\u0003S\f)O\u0001\bO\u0005R#\u0016mZ\"p[B|WO\u001c3\t\u000f\u00055(\u00061\u0001\u0002p\u0006Iqo\u001c:lgB\f7-\u001a\t\u0005\u0003c\f)0\u0004\u0002\u0002t*\u0019\u0011Q^\u0019\n\t\u0005]\u00181\u001f\u0002\n/>\u00148n\u001d9bG\u0016\fAa]1wKR\u0019a)!@\t\u000f\u0005}7\u00061\u0001\u0002b\u0006aA.\u001b8f)>\u001cFO]5oOR!\u0011Q\u000eB\u0002\u0011\u0019\u0011)\u0001\fa\u0001\u0003\u0006\t\u00110\u0001\u0005u_N#(/\u001b8h)\t\ti\u0007")
public class GenericTextBuffer {
    private int width;
    private int height;
    private PackedColor.ColorFormat _format;
    private PackedColor.Color _foreground;
    private PackedColor.Color _background;
    private short packed;
    private short[][] color;
    private int[][] buffer;

    public int width() {
        return this.width;
    }

    public void width_$eq(int x$1) {
        this.width = x$1;
    }

    public int height() {
        return this.height;
    }

    public void height_$eq(int x$1) {
        this.height = x$1;
    }

    private PackedColor.ColorFormat _format() {
        return this._format;
    }

    private void _format_$eq(PackedColor.ColorFormat x$1) {
        this._format = x$1;
    }

    private PackedColor.Color _foreground() {
        return this._foreground;
    }

    private void _foreground_$eq(PackedColor.Color x$1) {
        this._foreground = x$1;
    }

    private PackedColor.Color _background() {
        return this._background;
    }

    private void _background_$eq(PackedColor.Color x$1) {
        this._background = x$1;
    }

    private short packed() {
        return this.packed;
    }

    private void packed_$eq(short x$1) {
        this.packed = x$1;
    }

    public PackedColor.Color foreground() {
        return this._foreground();
    }

    public GenericTextBuffer foreground_$eq(PackedColor.Color value) {
        this.format().validate(value);
        this._foreground_$eq(value);
        this.packed_$eq(PackedColor$.MODULE$.pack(this._foreground(), this._background(), this._format()));
        return this;
    }

    public PackedColor.Color background() {
        return this._background();
    }

    public GenericTextBuffer background_$eq(PackedColor.Color value) {
        this.format().validate(value);
        this._background_$eq(value);
        this.packed_$eq(PackedColor$.MODULE$.pack(this._foreground(), this._background(), this._format()));
        return this;
    }

    public PackedColor.ColorFormat format() {
        return this._format();
    }

    public boolean format_$eq(PackedColor.ColorFormat value) {
        Enumeration.Value value2 = this.format().depth();
        Enumeration.Value value3 = value.depth();
        if (value2 == null ? value3 != null : !((Object)value2).equals(value3)) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach$mVc$sp(row -> {
                short[] rowColor = this.color()[row];
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach$mVc$sp(col -> {
                    short packed = rowColor[col];
                    PackedColor.Color fg = new PackedColor.Color(PackedColor$.MODULE$.unpackForeground(packed, this._format()), PackedColor$Color$.MODULE$.apply$default$2());
                    PackedColor.Color bg = new PackedColor.Color(PackedColor$.MODULE$.unpackBackground(packed, this._format()), PackedColor$Color$.MODULE$.apply$default$2());
                    rowColor$1[col] = PackedColor$.MODULE$.pack(fg, bg, value);
                });
            });
            this._format_$eq(value);
            this.packed_$eq(PackedColor$.MODULE$.pack(this._foreground(), this._background(), this._format()));
            return true;
        }
        return false;
    }

    public short[][] color() {
        return this.color;
    }

    public void color_$eq(short[][] x$1) {
        this.color = x$1;
    }

    public int[][] buffer() {
        return this.buffer;
    }

    public void buffer_$eq(int[][] x$1) {
        this.buffer = x$1;
    }

    public Tuple2<Object, Object> size() {
        return new Tuple2$mcII$sp(this.width(), this.height());
    }

    public boolean size_$eq(Tuple2<Object, Object> value) {
        Tuple2<Object, Object> tuple2 = value;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int iw = tuple2._1$mcI$sp();
        int ih = tuple2._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(iw, ih);
        int iw2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
        int ih2 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp2 = new Tuple2$mcII$sp(package$.MODULE$.max(iw2, 1), package$.MODULE$.max(ih2, 1));
        if (tuple2$mcII$sp2 == null) {
            throw new MatchError(tuple2$mcII$sp2);
        }
        int w = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
        int h2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp3 = new Tuple2$mcII$sp(w, h2);
        int w2 = ((Tuple2)tuple2$mcII$sp3)._1$mcI$sp();
        int h3 = ((Tuple2)tuple2$mcII$sp3)._2$mcI$sp();
        if (this.width() != w2 || this.height() != h3) {
            int[][] newBuffer = (int[][])Array$.MODULE$.fill(h3, w2, () -> 32, ClassTag$.MODULE$.Int());
            short[][] newColor = (short[][])Array$.MODULE$.fill(h3, w2, () -> this.packed(), ClassTag$.MODULE$.Short());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(h3, this.height())).foreach$mVc$sp(y -> {
                Array$.MODULE$.copy(this.buffer()[y], 0, newBuffer[y], 0, package$.MODULE$.min(w2, this.width()));
                Array$.MODULE$.copy(this.color()[y], 0, newColor[y], 0, package$.MODULE$.min(w2, this.width()));
            });
            this.buffer_$eq(newBuffer);
            this.color_$eq(newColor);
            this.width_$eq(w2);
            this.height_$eq(h3);
            return true;
        }
        return false;
    }

    public int get(int col, int row) {
        if (col < 0 || col >= this.width() || row < 0 || row >= this.height()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer()[row][col];
    }

    public boolean set(int col, int row, String s, boolean vertical) {
        int sLength = ExtendedUnicodeHelper$.MODULE$.length(s);
        if (vertical) {
            if (col < 0 || col >= this.width()) {
                return false;
            }
            BooleanRef changed = BooleanRef.create(false);
            IntRef cx = IntRef.create(0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(row), package$.MODULE$.min(row + sLength, this.height())).foreach$mVc$sp(y -> {
                if (y >= 0) {
                    int[] line = this.buffer()[y];
                    short[] lineColor = this.color()[y];
                    int c2 = s.codePointAt(cx$1.elem);
                    changed$1.elem = changed$1.elem || line[col] != c2 || lineColor[col] != this.packed();
                    this.setChar(line, lineColor, col, c2);
                    cx$1.elem = s.offsetByCodePoints(cx$1.elem, 1);
                    return;
                }
            });
            return changed.elem;
        }
        if (row < 0 || row >= this.height()) {
            return false;
        }
        BooleanRef changed = BooleanRef.create(false);
        int[] line = this.buffer()[row];
        short[] lineColor = this.color()[row];
        IntRef bx = IntRef.create(package$.MODULE$.max(col, 0));
        IntRef cx = IntRef.create(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(bx.elem), package$.MODULE$.min(col + sLength, this.width())).withFilter(x -> bx$1.elem < line.length).foreach(x -> {
            int c2 = s.codePointAt(cx$2.elem);
            changed$2.elem = changed$2.elem || line[bx$1.elem] != c2 || lineColor[bx$1.elem] != this.packed();
            this.setChar(line, lineColor, bx$1.elem, c2);
            bx$1.elem += package$.MODULE$.max(1, FontUtils$.MODULE$.wcwidth(c2));
            cx$2.elem = s.offsetByCodePoints(cx$2.elem, 1);
        });
        return changed.elem;
    }

    public boolean fill(int col, int row, int w, int h2, int c2) {
        if (w <= 0 || h2 <= 0) {
            return false;
        }
        if (col + w < 0 || row + h2 < 0 || col >= this.width() || row >= this.height()) {
            return false;
        }
        BooleanRef changed = BooleanRef.create(false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(package$.MODULE$.max(row, 0)), package$.MODULE$.min(row + h2, this.height())).foreach$mVc$sp(y -> {
            int[] line = this.buffer()[y];
            short[] lineColor = this.color()[y];
            IntRef bx = IntRef.create(package$.MODULE$.max(col, 0));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(bx.elem), package$.MODULE$.min(col + w, this.width())).withFilter(x$3 -> {
                int n2 = x$3;
                return bx$2.elem < line.length;
            }).foreach(x$4 -> {
                int n2 = x$4;
                changed$3.elem = changed$3.elem || line[bx$2.elem] != c2 || lineColor[bx$2.elem] != this.packed();
                this.setChar(line, lineColor, bx$2.elem, c2);
                bx$2.elem += package$.MODULE$.max(1, FontUtils$.MODULE$.wcwidth(c2));
            });
        });
        return changed.elem;
    }

    public boolean copy(int col, int row, int w, int h2, int tx, int ty) {
        Tuple2$mcII$sp tuple2$mcII$sp;
        Tuple2$mcII$sp tuple2$mcII$sp2;
        if (w <= 0 || h2 <= 0) {
            return false;
        }
        if (tx == 0 && ty == 0) {
            return false;
        }
        Tuple2$mcII$sp tuple2$mcII$sp3 = new Tuple2$mcII$sp(package$.MODULE$.max(0, package$.MODULE$.min(this.width() - 1, col + tx + w - 1)), package$.MODULE$.max(0, package$.MODULE$.min(this.width(), col + tx)));
        Tuple2 tuple2 = tuple2$mcII$sp2 = tx > 0 ? tuple2$mcII$sp3 : ((Tuple2)tuple2$mcII$sp3).swap$mcII$sp();
        if (tuple2$mcII$sp2 == null) {
            throw new MatchError(tuple2$mcII$sp2);
        }
        int dx0 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
        int dx1 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp4 = new Tuple2$mcII$sp(dx0, dx1);
        int dx02 = ((Tuple2)tuple2$mcII$sp4)._1$mcI$sp();
        int dx12 = ((Tuple2)tuple2$mcII$sp4)._2$mcI$sp();
        int left_edge = package$.MODULE$.min(dx02, dx12) - 1;
        if (left_edge >= this.width() - 1) {
            return false;
        }
        Tuple2$mcII$sp tuple2$mcII$sp5 = new Tuple2$mcII$sp(package$.MODULE$.max(0, package$.MODULE$.min(this.height() - 1, row + ty + h2 - 1)), package$.MODULE$.max(0, package$.MODULE$.min(this.height(), row + ty)));
        Tuple2 tuple22 = tuple2$mcII$sp = ty > 0 ? tuple2$mcII$sp5 : ((Tuple2)tuple2$mcII$sp5).swap$mcII$sp();
        if (tuple2$mcII$sp == null) {
            throw new MatchError(tuple2$mcII$sp);
        }
        int dy0 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
        int dy1 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp6 = new Tuple2$mcII$sp(dy0, dy1);
        int dy02 = ((Tuple2)tuple2$mcII$sp6)._1$mcI$sp();
        int dy12 = ((Tuple2)tuple2$mcII$sp6)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp7 = new Tuple2$mcII$sp(tx > 0 ? -1 : 1, ty > 0 ? -1 : 1);
        if (tuple2$mcII$sp7 == null) {
            throw new MatchError(tuple2$mcII$sp7);
        }
        int sx = ((Tuple2)tuple2$mcII$sp7)._1$mcI$sp();
        int sy = ((Tuple2)tuple2$mcII$sp7)._2$mcI$sp();
        Tuple2$mcII$sp tuple2$mcII$sp8 = new Tuple2$mcII$sp(sx, sy);
        int sx2 = ((Tuple2)tuple2$mcII$sp8)._1$mcI$sp();
        int sy2 = ((Tuple2)tuple2$mcII$sp8)._2$mcI$sp();
        BooleanRef changed = BooleanRef.create(false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(dy02), dy12).by(sy2).foreach$mVc$sp(ny -> {
            int[] nl = this.buffer()[ny];
            short[] nc = this.color()[ny];
            int n2 = ny - ty;
            switch (n2) {
                default: 
            }
            if (n2 >= 0 && n2 < this.height()) {
                int[] ol = this.buffer()[n2];
                short[] oc = this.color()[n2];
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(dx02), dx12).by(sx2).foreach$mVc$sp(nx -> {
                    int n2 = nx - tx;
                    switch (n2) {
                        default: 
                    }
                    if (n2 >= 0 && n2 < this.width()) {
                        changed$4.elem = changed$4.elem || nl[nx] != ol[n2] || nc[nx] != oc[n2];
                        nl$1[nx] = ol[n2];
                        nc$1[nx] = oc[n2];
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), FontUtils$.MODULE$.wcwidth(nl[nx])).foreach$mVc$sp(offset -> {
                            nl$1[nx$1 + offset] = 32;
                            nc$1[nx$1 + offset] = oc[nx];
                        });
                        return;
                    }
                });
                if (left_edge >= 0 && FontUtils$.MODULE$.wcwidth(nl[left_edge]) > 1) {
                    nl[left_edge$1] = 32;
                    changed$4.elem = true;
                    return;
                }
                return;
            }
        });
        return changed.elem;
    }

    public boolean rawcopy(int col, int row, int w, int h2, GenericTextBuffer src, int fromCol, int fromRow) {
        BooleanRef changed = BooleanRef.create(false);
        int col_index = col - 1;
        int row_index = row - 1;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), h2).foreach$mVc$sp(yOffset -> {
            int[] dstCharLine = this.buffer()[row_index + yOffset];
            short[] dstColorLine = this.color()[row_index + yOffset];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), w).foreach$mVc$sp(xOffset -> {
                int srcChar = src.buffer()[fromRow + yOffset - 1][fromCol + xOffset - 1];
                short srcColor = src.color()[fromRow + yOffset - 1][fromCol + xOffset - 1];
                Enumeration.Value value = this.format().depth();
                Enumeration.Value value2 = src.format().depth();
                if (value == null ? value2 != null : !((Object)value).equals(value2)) {
                    PackedColor.Color fg = new PackedColor.Color(PackedColor$.MODULE$.unpackForeground(srcColor, src.format()), PackedColor$Color$.MODULE$.apply$default$2());
                    PackedColor.Color bg = new PackedColor.Color(PackedColor$.MODULE$.unpackBackground(srcColor, src.format()), PackedColor$Color$.MODULE$.apply$default$2());
                    srcColor = PackedColor$.MODULE$.pack(fg, bg, this.format());
                }
                if (srcChar != dstCharLine[col_index + xOffset] || srcColor != dstColorLine[col_index + xOffset]) {
                    changed$5.elem = true;
                    dstCharLine$1[col_index$1 + xOffset] = srcChar;
                    dstColorLine$1[col_index$1 + xOffset] = srcColor;
                    return;
                }
            });
        });
        return changed.elem;
    }

    private void setChar(int[] line, short[] lineColor, int x, int c2) {
        if (FontUtils$.MODULE$.wcwidth(c2) > 1 && x >= line.length - 1) {
            return;
        }
        line[x] = c2;
        lineColor[x] = this.packed();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(x + 1), x + FontUtils$.MODULE$.wcwidth(c2)).foreach$mVc$sp(x1 -> {
            line$3[x1] = 32;
            lineColor$3[x1] = this.packed();
        });
        if (x > 0 && FontUtils$.MODULE$.wcwidth(line[x - 1]) > 1) {
            line[x - 1] = 32;
            return;
        }
    }

    public void load(NBTTagCompound nbt, Workspace workspace) {
        int maxResolution = package$.MODULE$.max(((Tuple2)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(Settings$.MODULE$.screenResolutionsByTier())))._1$mcI$sp(), ((Tuple2)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(Settings$.MODULE$.screenResolutionsByTier())))._2$mcI$sp());
        int w = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(nbt.getInteger("width")), maxResolution)), 1);
        int h2 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(nbt.getInteger("height")), maxResolution)), 1);
        this.size_$eq(new Tuple2$mcII$sp(w, h2));
        NBTTagList b2 = nbt.getTagList("buffer", 8);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(h2, b2.tagCount())).foreach$mVc$sp(i2 -> {
            String value = b2.getStringTagAt(i2);
            PrimitiveIterator.OfInt valueIt = value.codePoints().iterator();
            for (int j2 = 0; j2 < this.buffer()[i2].length && valueIt.hasNext(); ++j2) {
                $this.buffer()[i2][j2] = valueIt.nextInt();
            }
        });
        Enumeration.Value depth = ColorDepth$.MODULE$.apply(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(nbt.getInteger("depth")), ColorDepth$.MODULE$.maxId())), 0));
        this._format_$eq(PackedColor$Depth$.MODULE$.format(depth));
        this._format().load(nbt, workspace);
        this.foreground_$eq(new PackedColor.Color(nbt.getInteger("foreground"), nbt.getBoolean("foregroundIsPalette")));
        this.background_$eq(new PackedColor.Color(nbt.getInteger("background"), nbt.getBoolean("backgroundIsPalette")));
        if (!NbtDataStream$.MODULE$.getShortArray(nbt, "colors", this.color(), w, h2)) {
            NbtDataStream$.MODULE$.getIntArrayLegacy(nbt, "color", this.color(), w, h2);
            return;
        }
    }

    public void save(NBTTagCompound nbt) {
        nbt.setInteger("width", this.width());
        nbt.setInteger("height", this.height());
        NBTTagList b2 = new NBTTagList();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach$mVc$sp(i2 -> b2.appendTag(new NBTTagString(this.lineToString(i2))));
        nbt.setTag("buffer", b2);
        nbt.setInteger("depth", this._format().depth().id());
        this._format().save(nbt);
        nbt.setInteger("foreground", this._foreground().value());
        nbt.setBoolean("foregroundIsPalette", this._foreground().isPalette());
        nbt.setInteger("background", this._background().value());
        nbt.setBoolean("backgroundIsPalette", this._background().isPalette());
        NbtDataStream$.MODULE$.setShortArray(nbt, "colors", (short[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])this.color()), (Function1<short[], ArraySeq.ofShort> & Serializable)xs -> Predef$.MODULE$.wrapShortArray((short[])xs), ClassTag$.MODULE$.Short()));
    }

    public String lineToString(int y) {
        StringBuilder b2;
        block0: {
            b2 = new StringBuilder();
            if (this.buffer().length <= 0) break block0;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1<Object, StringBuilder> & Serializable)x -> b2.appendCodePoint(this.buffer()[y][BoxesRunTime.unboxToInt(x)]));
        }
        return b2.toString();
    }

    public String toString() {
        StringBuilder b2;
        block0: {
            b2 = new StringBuilder();
            if (this.buffer().length <= 0) break block0;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1<Object, StringBuilder> & Serializable)x -> b2.appendCodePoint(this.buffer()[0][BoxesRunTime.unboxToInt(x)]));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.height()).foreach$mVc$sp(y -> {
                b2.append('\n');
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1<Object, StringBuilder> & Serializable)x -> b2.appendCodePoint(this.buffer()[y][BoxesRunTime.unboxToInt(x)]));
            });
        }
        return b2.toString();
    }

    public GenericTextBuffer(int width, int height, PackedColor.ColorFormat initialFormat) {
        this.width = width;
        this.height = height;
        this._format = initialFormat;
        this._foreground = new PackedColor.Color(0xFFFFFF, PackedColor$Color$.MODULE$.apply$default$2());
        this._background = new PackedColor.Color(0, PackedColor$Color$.MODULE$.apply$default$2());
        this.packed = PackedColor$.MODULE$.pack(this._foreground(), this._background(), this._format());
        this.color = (short[][])Array$.MODULE$.fill(this.height(), this.width(), () -> this.packed(), ClassTag$.MODULE$.Short());
        this.buffer = (int[][])Array$.MODULE$.fill(this.height(), this.width(), () -> 32, ClassTag$.MODULE$.Int());
    }

    public GenericTextBuffer(Tuple2<Object, Object> size, PackedColor.ColorFormat format2) {
        this(size._1$mcI$sp(), size._2$mcI$sp(), format2);
    }
}

