/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.util;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import totoro.ocelot.brain.util.InetAddressRange;

public final class InetAddressRange$ {
    public static final InetAddressRange$ MODULE$ = new InetAddressRange$();

    public InetAddressRange parse(String addressStr, String prefixSizeStr) {
        InetAddress inetAddress;
        int n2;
        try {
            n2 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(prefixSizeStr));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(76).append("Malformed address range entry '").append(addressStr).append("/").append(prefixSizeStr).append("': Cannot extract size of CIDR mask from '").append(prefixSizeStr).append("'.").toString());
        }
        int prefixSize = n2;
        try {
            inetAddress = InetAddresses.forString(addressStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(new StringBuilder(69).append("Malformed address range entry '").append(addressStr).append("/").append(prefixSizeStr).append("': Cannot extract IP address from '").append(addressStr).append("'.").toString());
        }
        InetAddress address = inetAddress;
        byte[] minBytes = address.getAddress();
        byte[] maxBytes = address.getAddress();
        IntRef size = IntRef.create(prefixSize);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), minBytes.length).foreach$mVc$sp(i2 -> {
            if (size$1.elem <= 0) {
                minBytes$1[i2] = (byte)0;
                maxBytes$1[i2] = (byte)255;
            } else if (size$1.elem < 8) {
                minBytes$1[i2] = (byte)(minBytes[i2] & 255 << 8 - size$1.elem);
                maxBytes$1[i2] = (byte)(maxBytes[i2] | ~(255 << 8 - size$1.elem));
            }
            size$1.elem -= 8;
        });
        return new InetAddressRange(minBytes, maxBytes);
    }

    private InetAddressRange$() {
    }
}

